/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.operators;

import com.aol.cyclops.sequence.Monoid;
import com.aol.cyclops.streams.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class MultiReduceOperator<R> {
    private final Stream<R> stream;

    public List<R> reduce(final Iterable<Monoid<R>> reducers) {
        Monoid m = new Monoid(){

            public List zero() {
                return StreamUtils.stream(reducers).map(r -> r.zero()).collect(Collectors.toList());
            }

            public BiFunction<List, List, List> combiner() {
                return (c1, c2) -> {
                    ArrayList l = new ArrayList();
                    int i = 0;
                    for (Monoid next : reducers) {
                        l.add(next.combiner().apply(c1.get(i), c2.get(0)));
                        ++i;
                    }
                    return l;
                };
            }

            public Stream mapToType(Stream stream) {
                return stream.map(value -> Arrays.asList(value));
            }
        };
        return (List)m.mapReduce(this.stream);
    }

    @ConstructorProperties(value={"stream"})
    public MultiReduceOperator(Stream<R> stream) {
        this.stream = stream;
    }

    public Stream<R> getStream() {
        return this.stream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiReduceOperator)) {
            return false;
        }
        MultiReduceOperator other = (MultiReduceOperator)o;
        Stream<R> this$stream = this.getStream();
        Stream<R> other$stream = other.getStream();
        return !(this$stream == null ? other$stream != null : !this$stream.equals(other$stream));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Stream<R> $stream = this.getStream();
        result = result * 59 + ($stream == null ? 0 : $stream.hashCode());
        return result;
    }

    public String toString() {
        return "MultiReduceOperator(stream=" + this.getStream() + ")";
    }
}

