/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.sequence.spliterators;

import com.aol.cyclops.sequence.spliterators.ReversableSpliterator;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.IntConsumer;

public class ReversingRangeIntSpliterator
implements Spliterator.OfInt,
ReversableSpliterator {
    private int index;
    private final int max;
    private boolean reverse;

    @Override
    public ReversableSpliterator invert() {
        this.setReverse(!this.isReverse());
        this.index = this.max - 1;
        return this;
    }

    @Override
    public boolean tryAdvance(IntConsumer consumer) {
        Objects.requireNonNull(consumer);
        if (!this.reverse && this.index < this.max && this.index > -1) {
            consumer.accept(this.index++);
            return true;
        }
        if (this.reverse && this.index > -1 && this.index < this.max) {
            consumer.accept(this.index--);
            return true;
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return this.max;
    }

    @Override
    public int characteristics() {
        return 1024;
    }

    @Override
    public Spliterator.OfInt trySplit() {
        return this;
    }

    @Override
    public ReversableSpliterator copy() {
        return new ReversingRangeIntSpliterator(this.index, this.max, this.reverse);
    }

    @ConstructorProperties(value={"index", "max", "reverse"})
    public ReversingRangeIntSpliterator(int index, int max, boolean reverse) {
        this.index = index;
        this.max = max;
        this.reverse = reverse;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }
}

