/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.sequence.spliterators;

import com.aol.cyclops.sequence.spliterators.ReversableSpliterator;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;

public class ReversingListSpliterator<T>
implements Spliterator<T>,
ReversableSpliterator {
    private final List<T> list;
    private ListIterator<T> it;
    private boolean reverse = false;

    public ReversingListSpliterator(List<T> elements, boolean reverse) {
        this.list = elements;
        this.reverse = reverse;
        this.it = elements.listIterator();
    }

    @Override
    public ReversingListSpliterator<T> invert() {
        this.setReverse(!this.isReverse());
        this.it = this.list.listIterator(this.list.size());
        return this;
    }

    @Override
    public ReversableSpliterator copy() {
        return new ReversingListSpliterator<T>(this.list, this.reverse);
    }

    @Override
    public long estimateSize() {
        return this.list.size();
    }

    @Override
    public int characteristics() {
        return 1024;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        if (!this.reverse) {
            if (this.it.hasNext()) {
                action.accept(this.it.next());
                return true;
            }
        } else if (this.it.hasPrevious()) {
            action.accept(this.it.previous());
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<T> trySplit() {
        return this;
    }

    @ConstructorProperties(value={"list", "it", "reverse"})
    public ReversingListSpliterator(List<T> list, ListIterator<T> it, boolean reverse) {
        this.list = list;
        this.it = it;
        this.reverse = reverse;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }
}

