/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.monad;

import com.aol.cyclops.monad.AnyMFactory;
import com.aol.cyclops.monad.ApplyM;
import com.aol.cyclops.monad.FlatMapM;
import com.aol.cyclops.monad.ReduceM;
import com.aol.cyclops.sequence.Monoid;
import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.sequence.Unwrapable;
import com.aol.cyclops.sequence.streamable.Streamable;
import com.aol.cyclops.sequence.streamable.ToStream;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jooq.lambda.function.Function3;
import org.jooq.lambda.function.Function4;
import org.jooq.lambda.function.Function5;

public interface AnyM<T>
extends Unwrapable,
ToStream<T>,
ApplyM<T>,
FlatMapM<T>,
ReduceM<T> {
    @Override
    public SequenceM<T> stream();

    @Override
    public <R> R unwrap();

    public <X> X monad();

    public AnyM<T> filter(Predicate<? super T> var1);

    public <R> AnyM<R> map(Function<? super T, ? extends R> var1);

    public AnyM<T> peek(Consumer<? super T> var1);

    public <R> AnyM<R> bind(Function<? super T, ?> var1);

    public <R> AnyM<R> liftAndBind(Function<? super T, ?> var1);

    public <T1> AnyM<T1> flatten();

    public AnyM<List<T>> aggregate(AnyM<T> var1);

    public <R1, R> AnyM<R> forEach2(Function<? super T, ? extends AnyM<R1>> var1, Function<? super T, Function<? super R1, ? extends R>> var2);

    public <R1, R> AnyM<R> forEach2(Function<? super T, ? extends AnyM<R1>> var1, Function<? super T, Function<? super R1, Boolean>> var2, Function<? super T, Function<? super R1, ? extends R>> var3);

    public <R1, R2, R> AnyM<R> forEach3(Function<? super T, ? extends AnyM<R1>> var1, Function<? super T, Function<? super R1, ? extends AnyM<R2>>> var2, Function<? super T, Function<? super R1, Function<? super R2, Boolean>>> var3, Function<? super T, Function<? super R1, Function<? super R2, ? extends R>>> var4);

    public <R1, R2, R> AnyM<R> forEach3(Function<? super T, ? extends AnyM<R1>> var1, Function<? super T, Function<? super R1, ? extends AnyM<R2>>> var2, Function<? super T, Function<? super R1, Function<? super R2, ? extends R>>> var3);

    public <R> AnyM<R> flatMap(Function<? super T, AnyM<? extends R>> var1);

    public <NT> SequenceM<NT> toSequence(Function<T, Stream<NT>> var1);

    public <T> SequenceM<T> toSequence();

    public SequenceM<T> asSequence();

    public <R> AnyM<R> applyM(AnyM<Function<? super T, ? extends R>> var1);

    public <T> AnyM<T> unit(T var1);

    public <T> AnyM<T> empty();

    public AnyM<List<T>> replicateM(int var1);

    public AnyM<T> reduceM(Monoid<AnyM<T>> var1);

    public String toString();

    default public Optional<List<T>> toOptional() {
        return this.toSequence().toOptional();
    }

    default public CompletableFuture<List<T>> toCompletableFuture() {
        return this.toSequence().toCompletableFuture();
    }

    public List<T> toList();

    public Set<T> toSet();

    public <R, A> R collect(Collector<? super T, A, R> var1);

    public static AnyM<Integer> fromRange(int start, int end) {
        return AnyM.fromStream(SequenceM.range(start, end));
    }

    public static AnyM<Long> fromRangeLong(long start, long end) {
        return AnyM.fromStream(SequenceM.rangeLong(start, end));
    }

    public static <T> AnyM<T> fromStreamable(ToStream<T> streamable) {
        Objects.requireNonNull(streamable);
        return AnyMFactory.instance.monad(streamable);
    }

    public static <T> AnyM<T> fromList(List<T> list) {
        Objects.requireNonNull(list);
        return AnyMFactory.instance.monad(list);
    }

    public static <T> AnyM<T> fromSet(Set<T> set) {
        Objects.requireNonNull(set);
        return AnyMFactory.instance.monad(set);
    }

    public static <T> AnyM<T> fromArray(T ... streamData) {
        return AnyMFactory.instance.monad(Stream.of(streamData));
    }

    public static <T> AnyM<T> streamOf(T ... streamData) {
        return AnyMFactory.instance.monad(Stream.of(streamData));
    }

    public static <T> AnyM<T> fromStream(Stream<T> stream) {
        Objects.requireNonNull(stream);
        return AnyMFactory.instance.monad(stream);
    }

    public static AnyM<Integer> fromIntStream(IntStream stream) {
        Objects.requireNonNull(stream);
        return AnyMFactory.instance.monad(stream.boxed());
    }

    public static AnyM<Double> fromDoubleStream(DoubleStream stream) {
        Objects.requireNonNull(stream);
        return AnyMFactory.instance.monad(stream.boxed());
    }

    public static AnyM<Long> fromLongStream(LongStream stream) {
        Objects.requireNonNull(stream);
        return AnyMFactory.instance.monad(stream.boxed());
    }

    public static <T> AnyM<T> fromOptional(Optional<T> optional) {
        Objects.requireNonNull(optional);
        return AnyMFactory.instance.monad(optional);
    }

    public static AnyM<Double> fromOptionalDouble(OptionalDouble optional) {
        Objects.requireNonNull(optional);
        return AnyMFactory.instance.of(optional);
    }

    public static AnyM<Long> fromOptionalLong(OptionalLong optional) {
        Objects.requireNonNull(optional);
        return AnyMFactory.instance.of(optional);
    }

    public static AnyM<Integer> fromOptionalInt(OptionalInt optional) {
        Objects.requireNonNull(optional);
        return AnyMFactory.instance.of(optional);
    }

    public static <T> AnyM<T> fromCompletableFuture(CompletableFuture<T> future) {
        Objects.requireNonNull(future);
        return AnyMFactory.instance.monad(future);
    }

    public static <T> AnyM<T> fromCollection(Collection<T> collection) {
        Objects.requireNonNull(collection);
        return AnyMFactory.instance.of(collection);
    }

    public static <T> AnyM<T> fromIterable(Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        return AnyMFactory.instance.of(iterable);
    }

    public static AnyM<String> fromFile(File file) {
        Objects.requireNonNull(file);
        return AnyMFactory.instance.of(file);
    }

    public static AnyM<String> fromURL(URL url) {
        Objects.requireNonNull(url);
        return AnyMFactory.instance.of(url);
    }

    public static <T> AnyM<T> ofConvertable(Object monad) {
        Objects.requireNonNull(monad);
        return AnyMFactory.instance.of(monad);
    }

    public static <T> AnyM<T> ofMonad(Object monad) {
        Objects.requireNonNull(monad);
        return AnyMFactory.instance.monad(monad);
    }

    public static <T> AnyM<T> ofNullable(Object nullable) {
        return AnyMFactory.instance.monad(Optional.ofNullable(nullable));
    }

    public static <T> List<AnyM<T>> ofMonadList(Iterable<Object> anyM) {
        return StreamSupport.stream(anyM.spliterator(), false).map(i -> AnyM.ofMonad(i)).collect(Collectors.toList());
    }

    public static <T> List<AnyM<T>> listFromStreamable(Iterable<Streamable<T>> anyM) {
        return StreamSupport.stream(anyM.spliterator(), false).map(i -> AnyM.fromStreamable(i)).collect(Collectors.toList());
    }

    public static <T> List<AnyM<T>> listFromStream(Iterable<Stream<T>> anyM) {
        return StreamSupport.stream(anyM.spliterator(), false).map(i -> AnyM.fromStream(i)).collect(Collectors.toList());
    }

    public static <T> List<AnyM<T>> listFromOptional(Iterable<Optional<T>> anyM) {
        return StreamSupport.stream(anyM.spliterator(), false).map(i -> AnyM.fromOptional(i)).collect(Collectors.toList());
    }

    public static <T> List<AnyM<T>> listFromCompletableFuture(Iterable<CompletableFuture<T>> anyM) {
        return StreamSupport.stream(anyM.spliterator(), false).map(i -> AnyM.fromCompletableFuture(i)).collect(Collectors.toList());
    }

    public static <T> List<AnyM<T>> listFromIterable(Iterable<Iterable<T>> anyM) {
        return StreamSupport.stream(anyM.spliterator(), false).map(i -> AnyM.fromIterable(i)).collect(Collectors.toList());
    }

    public static <T> List<AnyM<T>> listFromCollection(Iterable<Collection<T>> anyM) {
        return StreamSupport.stream(anyM.spliterator(), false).map(i -> AnyM.fromCollection(i)).collect(Collectors.toList());
    }

    public static <T> List<AnyM<T>> listFromIterator(Iterable<Iterator<T>> anyM) {
        return StreamSupport.stream(anyM.spliterator(), false).map(i -> AnyM.fromIterable(() -> i)).collect(Collectors.toList());
    }

    public static <T, R> AnyM<List<R>> traverse(Collection<AnyM<T>> seq, Function<T, R> fn) {
        return AnyMFactory.instance.anyMonads().traverse(seq, fn);
    }

    public static <T, R> AnyM<List<R>> traverse(Stream<AnyM<T>> seq, Function<T, R> fn) {
        return AnyMFactory.instance.anyMonads().traverse(seq, fn);
    }

    public static <T1> AnyM<Stream<T1>> sequence(Collection<AnyM<T1>> seq) {
        return AnyMFactory.instance.anyMonads().sequence(seq);
    }

    public static <T1> AnyM<Stream<T1>> sequence(Stream<AnyM<T1>> seq) {
        return AnyMFactory.instance.anyMonads().sequence(seq);
    }

    public static <U, R> Function<AnyM<U>, AnyM<R>> liftM(Function<U, R> fn) {
        return u -> u.map(input -> fn.apply(input));
    }

    public static <U1, U2, R> BiFunction<AnyM<U1>, AnyM<U2>, AnyM<R>> liftM2(BiFunction<U1, U2, R> fn) {
        return (u1, u2) -> u1.bind(input1 -> u2.map(input2 -> fn.apply(input1, input2)).unwrap());
    }

    public static <U1, U2, U3, R> Function3<AnyM<U1>, AnyM<U2>, AnyM<U3>, AnyM<R>> liftM3(Function3<U1, U2, U3, R> fn) {
        return (u1, u2, u3) -> u1.bind(input1 -> u2.bind(input2 -> u3.map(input3 -> fn.apply(input1, input2, input3))).unwrap());
    }

    public static <U1, U2, U3, U4, R> Function4<AnyM<U1>, AnyM<U2>, AnyM<U3>, AnyM<U4>, AnyM<R>> liftM4(Function4<U1, U2, U3, U4, R> fn) {
        return (u1, u2, u3, u4) -> u1.bind(input1 -> u2.bind(input2 -> u3.bind(input3 -> u4.map(input4 -> fn.apply(input1, input2, input3, input4)))).unwrap());
    }

    public static <U1, U2, U3, U4, U5, R> Function5<AnyM<U1>, AnyM<U2>, AnyM<U3>, AnyM<U4>, AnyM<U5>, AnyM<R>> liftM5(Function5<U1, U2, U3, U4, U5, R> fn) {
        return (u1, u2, u3, u4, u5) -> u1.bind(input1 -> u2.bind(input2 -> u3.bind(input3 -> u4.bind(input4 -> u5.map(input5 -> fn.apply(input1, input2, input3, input4, input5))))).unwrap());
    }

    public static <U1, U2, R> Function<AnyM<U1>, Function<AnyM<U2>, AnyM<R>>> liftM2(Function<U1, Function<U2, R>> fn) {
        return u1 -> u2 -> u1.bind(input1 -> u2.map(input2 -> ((Function)fn.apply(input1)).apply(input2)).unwrap());
    }

    public static <U1, U2, U3, R> Function<AnyM<U1>, Function<AnyM<U2>, Function<AnyM<U3>, AnyM<R>>>> liftM3(Function<U1, Function<U2, Function<U3, R>>> fn) {
        return u1 -> u2 -> u3 -> u1.bind(input1 -> u2.bind(input2 -> u3.map(input3 -> ((Function)((Function)fn.apply(input1)).apply(input2)).apply(input3))).unwrap());
    }

    public static <U1, U2, U3, U4, R> Function<AnyM<U1>, Function<AnyM<U2>, Function<AnyM<U3>, Function<AnyM<U4>, AnyM<R>>>>> liftM4(Function<U1, Function<U2, Function<U3, Function<U4, R>>>> fn) {
        return u1 -> u2 -> u3 -> u4 -> u1.bind(input1 -> u2.bind(input2 -> u3.bind(input3 -> u4.map(input4 -> ((Function)((Function)((Function)fn.apply(input1)).apply(input2)).apply(input3)).apply(input4)))).unwrap());
    }

    public static <U1, U2, U3, U4, U5, R> Function<AnyM<U1>, Function<AnyM<U2>, Function<AnyM<U3>, Function<AnyM<U4>, Function<AnyM<U5>, AnyM<R>>>>>> liftM5(Function<U1, Function<U2, Function<U3, Function<U4, Function<U5, R>>>>> fn) {
        return u1 -> u2 -> u3 -> u4 -> u5 -> u1.bind(input1 -> u2.bind(input2 -> u3.bind(input3 -> u4.bind(input4 -> u5.map(input5 -> ((Function)((Function)((Function)((Function)fn.apply(input1)).apply(input2)).apply(input3)).apply(input4)).apply(input5))))).unwrap());
    }
}

