/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.matcher;

import com.aol.cyclops.lambda.utils.LazyImmutable;
import com.aol.cyclops.matcher.ActiveCase;
import com.aol.cyclops.matcher.Cases;
import com.aol.cyclops.matcher.EmptyCase;
import com.aol.cyclops.matcher.Two;
import com.aol.cyclops.matcher.builders.ADTPredicateBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Case<T, R, X extends Function<T, R>> {
    public static final Case empty = new EmptyCase();

    public boolean isEmpty();

    public Two<Predicate<T>, X> get();

    default public Predicate<T> getPredicate() {
        return (Predicate)this.get().v1;
    }

    default public X getAction() {
        return (X)((Function)this.get().v2);
    }

    default public Case<T, R, X> negate() {
        return this.map(t2 -> Two.tuple(((Predicate)t2.v1).negate(), t2.v2));
    }

    default public Case<T, R, X> negate(X action) {
        return this.map(t2 -> Two.tuple(((Predicate)t2.v1).negate(), action));
    }

    default public Case<T, R, X> filter(Predicate<Two<Predicate<T>, X>> predicate) {
        return predicate.test(this.get()) ? this : Case.empty();
    }

    default public Case<T, R, X> mapPredicate(Function<Predicate<T>, Predicate<T>> mapper) {
        return this.map(t2 -> Two.tuple(mapper.apply((Predicate)t2.v1), t2.v2));
    }

    default public <R1, X1 extends Function<T, R1>> Case<T, R1, X1> mapFunction(Function<Function<T, R>, X1> mapper) {
        return this.map(t2 -> Two.tuple(t2.v1, mapper.apply((Function)t2.v2)));
    }

    default public <T1, R1, X1 extends Function<T1, R1>> Case<T1, R1, X1> map(Function<Two<Predicate<T>, X>, Two<Predicate<T1>, X1>> mapper) {
        return Case.of(mapper.apply(this.get()));
    }

    default public <T1, R1, X1 extends Function<T1, R1>> Case<T1, R1, X1> flatMap(Function<Two<Predicate<T>, X>, Case<T1, R1, X1>> mapper) {
        return mapper.apply(this.get());
    }

    default public <T1> Case<T, T1, Function<T, T1>> andThen(Case<R, T1, ? extends Function<R, T1>> after) {
        return after.compose(this);
    }

    default public <T1> Case<T, T1, Function<T, T1>> andThen(Cases<R, T1, ? extends Function<R, T1>> after) {
        LazyImmutable var = new LazyImmutable();
        return this.andThen(Case.of(t -> ((Optional)var.setOnce(after.match((Object)t)).get()).isPresent(), t -> ((Optional)var.get()).get()));
    }

    default public <T1> Case<T1, R, Function<T1, R>> compose(Case<T1, T, ? extends Function<T1, T>> before) {
        LazyImmutable value = new LazyImmutable();
        Predicate<Object> predicate = t -> {
            boolean passed;
            if (((Predicate)case_.get().v1).test(t)) {
                passed = true;
                value.setOnce(((Function)case_.get().v2).apply(t));
            } else {
                passed = false;
            }
            return passed && ((Predicate)this.get().v1).test(value.get());
        };
        return Case.of(predicate, input -> ((Function)this.get().v2).apply(value.get()));
    }

    default public <T1> Case<T1, R, Function<T1, R>> composeOr(Case<T1, T, ? extends Function<T1, T>> before) {
        return Case.of(t -> ((Predicate)case_.get().v1).test(t) || ((Predicate)this.get().v1).test(((Function)case_.get().v2).apply(t)), input -> ((Function)this.get().v2).apply(((Function)case_.get().v2).apply(input)));
    }

    default public <T1> Case<T1, R, Function<T1, R>> composeFunction(Function<T1, T> before) {
        return this.compose(Case.of(t -> true, before));
    }

    default public Case<T, T, Function<T, T>> andThenFunction(Function<R, T> after) {
        return this.andThen(Case.of(r -> true, after));
    }

    default public Case<T, R, Function<T, R>> or(Predicate<T> or) {
        return this.composeOr(Case.of(or, Function.identity()));
    }

    default public <T1> Case<T1, R, Function<T1, R>> or(Predicate<T1> or, Function<T1, T> fn) {
        return this.composeOr(Case.of(or, fn));
    }

    default public Case<T, R, Function<T, R>> and(Predicate<T> and) {
        return this.compose(Case.of(and, Function.identity()));
    }

    default public Case<T, R, Function<T, R>> andOfType(Class<T> and) {
        return this.compose(Case.of(input -> input.getClass().isAssignableFrom(and), Function.identity()));
    }

    default public Case<T, R, Function<T, R>> andOfValue(T and) {
        return this.compose(Case.of(input -> Objects.equals(input, and), Function.identity()));
    }

    default public Case<T, R, Function<T, R>> andWithValues(Object ... with) {
        return this.compose(Case.of(new ADTPredicateBuilder<Object>(Object.class).with(with), Function.identity()));
    }

    default public <T1> Case<T1, R, Function<T1, R>> composeAnd(Predicate<T1> and, Function<T1, T> before) {
        return this.compose(Case.of(and, before));
    }

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    default public Optional<R> match(T value) {
        if (((Predicate)this.get().v1).test(value)) {
            return Optional.of(((Function)this.get().v2).apply(value));
        }
        return Optional.empty();
    }

    default public CompletableFuture<Optional<R>> matchAsync(Executor executor, T value) {
        return CompletableFuture.supplyAsync(() -> this.match(value), executor);
    }

    public static <T, R, X extends Function<T, R>> Case<T, R, X> of(Predicate<T> predicate, X action) {
        return new ActiveCase(Two.tuple(predicate, action));
    }

    public static <T, R, X extends Function<T, R>> Case<T, R, X> of(Two<Predicate<T>, X> pattern) {
        return new ActiveCase(pattern);
    }

    public static <T, R, X extends Function<T, R>> Case<T, R, X> empty() {
        return empty;
    }
}

