/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.matcher;

import com.aol.cyclops.matcher.Action;
import com.aol.cyclops.matcher.ActionWithReturn;
import com.aol.cyclops.matcher.Extractors;
import com.aol.cyclops.matcher.TestPredicates;
import com.aol.cyclops.matcher.builders.PatternMatcher;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class RunPatternMatcherTest {
    public static void main(String[] args) {
        PatternMatcher m = new PatternMatcher();
        m.matchOf(Matchers.instanceOf(String.class), (Action & Serializable)t -> System.out.println("Value " + t));
        m.caseOf(TestPredicates.rangeChecker(1, 10), (Action & Serializable)t -> System.out.println("Value in range " + t));
        m.matchOfThenExtract(Matchers.instanceOf(List.class), (Action & Serializable)head -> System.out.println("head is " + head), Extractors.at((int)0));
        m.caseOf(Extractors.at((int)0), TestPredicates.rangeChecker(1, 10), (Action & Serializable)head -> System.out.println("within range " + head));
        m.inCaseOf(Extractors.at((int)0), TestPredicates.rangeChecker(100, 200), (ActionWithReturn & Serializable)head -> head + 100);
        m.caseOf(Extractors.at((int)3), TestPredicates.rangeChecker(100, 200), System.out::println);
        m.match((Object)"hello world");
        m.match(String.class);
        m.match((Object)100);
        m.match((Object)5);
        m.match((Object)ImmutableList.of((Object)100, (Object)2, (Object)3, (Object)4));
        m.match((Object)ImmutableList.of((Object)5, (Object)2, (Object)3, (Object)4));
        System.out.println("*");
        m.match((Object)ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)150, (Object)160));
        System.out.println("*");
        System.out.println("Got (+100)" + m.match((Object)ImmutableList.of((Object)120, (Object)200, (Object)420)).get());
    }

    @Test
    public void testPostExtract() {
        PatternMatcher m = new PatternMatcher();
        m.matchOfThenExtract(Matchers.instanceOf(List.class), (Action & Serializable)head -> System.out.println("head is " + head), Extractors.at((int)0));
        m.match((Object)ImmutableList.of((Object)120, (Object)200, (Object)420));
    }

    @Test
    public void testPostExtractWithReturn() {
        PatternMatcher m = new PatternMatcher().inMatchOfThenExtract(Matchers.instanceOf(List.class), (ActionWithReturn & Serializable)head -> head, Extractors.at((int)0));
        Assert.assertThat((Object)120, (Matcher)Is.is(m.match((Object)ImmutableList.of((Object)120, (Object)200, (Object)420)).get()));
    }
}

