/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.matcher;

import com.aol.cyclops.matcher.Action;
import com.aol.cyclops.matcher.ActionWithReturn;
import com.aol.cyclops.matcher.Extractors;
import com.aol.cyclops.matcher.Predicates;
import com.aol.cyclops.matcher.Two;
import com.aol.cyclops.matcher.builders.Matching;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MatchingDataStructuresTest {
    String value;

    @Test
    public void allValues() {
        Assert.assertThat(Matching.whenIterable().allValues(new Object[]{1, Predicates.ANY(), 2}).thenApply((ActionWithReturn & Serializable)l -> "case1").whenIterable().allValues((Object[])new Integer[]{1, 3, 2}).thenApply((ActionWithReturn & Serializable)l -> "case2").whenIterable().bothTrue(i -> i == 1, s -> s.length() > 0).thenExtract(Extractors.of((int)0, (int)1)).thenApply((ActionWithReturn & Serializable)t -> t.v1 + (String)t.v2).match(new Object[]{1, "hello", 2}).get(), (Matcher)Matchers.is((Object)"case1"));
    }

    @Test
    public void inCaseOfManySingle() {
        Assert.assertThat(Matching.whenIterable(c -> c.allTrue(new Predicate[]{p -> p.isTall()}).thenApply((ActionWithReturn & Serializable)list -> ((Person)list.get(0)).getName() + " is tall")).whenIterable(c -> c.allTrue(new Predicate[]{p -> p.isTall()}).thenApply((ActionWithReturn & Serializable)list -> ((Person)list.get(0)).getName() + " is tall")).match((Object)new Person("bob")).get(), (Matcher)Matchers.is((Object)"bob is tall"));
    }

    @Test
    public void inCaseOfManyDouble() {
        Predicate<Person> isTall = p -> p.isTall();
        Assert.assertThat(Matching.whenIterable(c -> c.allTrue(new Predicate[]{isTall}).thenApply((ActionWithReturn & Serializable)list -> ((Person)list.get(0)).getName() + " is tall")).match(new Object[]{new Person("bob"), new Person("bob")}).get(), (Matcher)Matchers.is((Object)"bob is tall"));
    }

    @Test
    public void inCaseOfManyList() {
        Predicate<Person> isTall = p -> p.isTall();
        Assert.assertThat(Matching.whenIterable(c -> c.allTrue(new Predicate[]{isTall}).thenApply((ActionWithReturn & Serializable)list -> ((Person)list.get(0)).getName() + " is tall")).apply(Arrays.asList(new Person("bob"))).get(), (Matcher)Matchers.is((Object)"bob is tall"));
    }

    @Test
    public void inMatchOfManyList() {
        Assert.assertThat(Matching.whenIterable(c -> c.allMatch(new Matcher[]{Matchers.samePropertyValuesAs((Object)new Person("bob"))}).thenApply((ActionWithReturn & Serializable)list -> ((Person)list.get(0)).getName())).apply(Arrays.asList(new Person("bob"))).get(), (Matcher)Matchers.is((Object)"bob"));
    }

    @Test
    public void inMatchOfManySingle() {
        Assert.assertThat(Matching.whenIterable(c -> c.allMatch(new Matcher[]{Matchers.samePropertyValuesAs((Object)new Person("bob"))}).thenApply((ActionWithReturn & Serializable)list -> ((Person)list.get(0)).getName())).apply((Object)new Person("bob")).get(), (Matcher)Matchers.is((Object)"bob"));
    }

    @Test
    public void inMatchOfManyDouble() {
        Assert.assertThat(Matching.whenIterable(c -> c.allMatch(new Matcher[]{Matchers.samePropertyValuesAs((Object)new Person("bob"))}).thenApply((ActionWithReturn & Serializable)list -> ((Person)list.get(0)).getName())).match(new Object[]{new Person("bob"), new Person("two")}).get(), (Matcher)Matchers.is((Object)"bob"));
    }

    @Test
    public void inMatchOfMatchers() {
        Assert.assertThat(Matching.whenIterable().bothMatch(Matchers.samePropertyValuesAs((Object)new Person("bob")), Matchers.anything()).thenExtract(Extractors.first()).thenApply((ActionWithReturn & Serializable)bob -> bob.getName()).apply((Object)Two.tuple((Object)new Person("bob"), (Object)"boo hoo!")).get(), (Matcher)Matchers.is((Object)"bob"));
    }

    @Test
    public void inMatchOfMatchersSingle() {
        Assert.assertThat(Matching.whenIterable(c -> c.bothMatch(Matchers.samePropertyValuesAs((Object)new Person("bob")), Matchers.any(String.class)).thenExtract(Extractors.first()).thenApply((ActionWithReturn & Serializable)bob -> bob.getName())).match(new Object[]{new Person("bob"), "boo hoo!"}).get(), (Matcher)Matchers.is((Object)"bob"));
    }

    @Test
    public void inCaseOfPredicates() {
        Matching.whenIterable(c -> c.allTrueNoType(new Predicate[]{p -> p.isTall(), p -> true}).thenExtract(Extractors.first()).thenApply((ActionWithReturn & Serializable)p -> p.getName() + " is tall")).apply((Object)new Person("bob")).get();
        String result = (String)Matching.whenIterable(c -> c.allTrueNoType(new Predicate[]{p -> p.isTall(), p -> true}).thenExtract(Extractors.first()).thenApply((ActionWithReturn & Serializable)p -> p.getName() + " is tall")).apply((Object)new Person("bob")).get();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)"bob is tall"));
    }

    @Test
    public void inCaseOfPredicatesMultiple() {
        String result = (String)Matching.whenIterable(c -> c.allTrueNoType(new Predicate[]{p -> p.isTall(), p -> true}).thenExtract(Extractors.first()).thenApply((ActionWithReturn & Serializable)p -> p.getName() + " is tall")).whenIterable(c -> c.allTrueNoType(new Predicate[]{p -> p.isTall(), p -> true}).thenExtract(Extractors.first()).thenApply((ActionWithReturn & Serializable)p -> p.getName() + " is tall")).match(new Object[]{new Person("bob"), "test"}).get();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)"bob is tall"));
    }

    @Test
    public void inCaseOfTuple() {
        String result = (String)Matching.whenIterable().threeTrue(p -> p.isTall(), a -> a.getCountry().equals("Ireland"), p -> true).thenExtract(Extractors.of((int)0, (int)1)).thenApply((ActionWithReturn & Serializable)t -> ((Person)t.v1).getName() + " is tall and lives in " + ((Address)t.v2).getCity()).whenIterable().threeTrue(p -> !p.isTall(), a -> a.getCountry().equals("Ireland"), p -> true).thenExtract(Extractors.of((int)0, (int)1)).thenApply((ActionWithReturn & Serializable)t -> ((Person)t.v1).getName() + " is not tall and lives in " + ((Address)t.v2).getCity()).whenIterable().threeTrue(a -> a.getCountry().equals("Ireland"), p -> !p.isTall(), p -> true).thenExtract(Extractors.of((int)0, (int)1)).thenApply((ActionWithReturn & Serializable)t -> ((Person)t.v1).getName() + " is not tall and lives in " + ((Address)t.v2).getCity()).apply(Arrays.asList(new Person("bob"), new Address(), new Job())).get();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)"bob is tall and lives in Dublin"));
    }

    @Test
    public void inCaseOfTupleUnsuitableObject() {
        String result = (String)Matching.whenIterable().threeTrue(p -> p.isTall(), a -> a.getCountry().equals("Ireland"), p -> true).thenExtract(Extractors.of((int)0, (int)1)).thenApply((ActionWithReturn & Serializable)t -> ((Person)t.v1).getName() + " is tall and lives in " + ((Address)t.v2).getCity()).whenIterable().threeTrue(p -> p.isTall(), a -> a.getCountry().equals("France"), p -> true).thenExtract(Extractors.of((int)0, (int)1)).thenApply((ActionWithReturn & Serializable)t -> ((Person)t.v1).getName() + " is tall and lives in " + ((Address)t.v2).getCity()).match(new Object[]{new Person("bob"), new Address()}).get();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)"bob is tall and lives in Dublin"));
    }

    @Test
    public void inMatchOfTuple() {
        String result = (String)Matching.whenIterable().bothMatch(Matchers.samePropertyValuesAs((Object)new Person("bob")), Matchers.anything()).thenExtract(Extractors.of((int)0, (int)1)).thenApply((ActionWithReturn & Serializable)t -> ((Person)t.v1).getName() + " is tall and lives in " + ((Address)t.v2).getCity()).match(new Object[]{new Person("bob"), new Address()}).get();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)"bob is tall and lives in Dublin"));
    }

    @Before
    public void setup() {
        this.value = null;
    }

    @Test
    public void caseOfManyList() {
        Predicate<Person> isTall = p -> p.isTall();
        Matching.whenIterable().allTrue(new Predicate[]{isTall}).thenConsume((Action & Serializable)list -> {
            this.value = ((Person)list.get(0)).getName() + " is tall";
        }).whenIterable().allTrue(new Predicate[]{isTall}).thenConsume((Action & Serializable)list -> {
            this.value = ((Person)list.get(0)).getName() + " is tall";
        }).match(Arrays.asList(new Person("bob")));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)"bob is tall"));
    }

    @Test
    public void caseOfManySingle() {
        Matching.whenIterable().allTrue(new Predicate[]{p -> p.isTall()}).thenConsume((Action & Serializable)list -> {
            this.value = ((Person)list.get(0)).getName() + " is tall";
        }).match((Object)new Person("bob"));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)"bob is tall"));
    }

    @Test
    public void caseOfManyDouble() {
        Matching.whenIterable().allTrue(new Predicate[]{p -> p.isTall()}).thenConsume((Action & Serializable)list -> {
            this.value = ((Person)list.get(0)).getName() + " is tall";
        }).match(new Object[]{new Person("bob"), new Person("two")});
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)"bob is tall"));
    }

    @Test
    public void matchOfManyList() {
        Matching.whenIterable().allMatch(new Matcher[]{Matchers.samePropertyValuesAs((Object)new Person("bob"))}).thenConsume((Action & Serializable)list -> {
            this.value = ((Person)list.get(0)).getName();
        }).apply(Arrays.asList(new Person("bob")));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)"bob"));
    }

    @Test
    public void matchOfManySingle() {
        Matching.whenIterable().allMatch(new Matcher[]{Matchers.samePropertyValuesAs((Object)new Person("bob"))}).thenConsume((Action & Serializable)list -> {
            this.value = ((Person)list.get(0)).getName();
        }).apply((Object)new Person("bob"));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)"bob"));
    }

    @Test
    public void matchOfManyDouble() {
        Matching.whenIterable().allMatch(new Matcher[]{Matchers.samePropertyValuesAs((Object)new Person("bob"))}).thenConsume((Action & Serializable)list -> {
            this.value = ((Person)list.get(0)).getName();
        }).match(new Object[]{new Person("bob"), new Person("two")});
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)"bob"));
    }

    @Test
    public void matchOfMatchers() {
        Matching.whenIterable().bothMatch(Matchers.samePropertyValuesAs((Object)new Person("bob")), Matchers.anything()).thenExtract(Extractors.first()).thenApply((ActionWithReturn & Serializable)bob -> {
            this.value = bob.getName();
            return this.value;
        }).whenIterable().bothMatch(Matchers.samePropertyValuesAs((Object)new Person("bob2")), Matchers.anything()).thenExtract(Extractors.first()).thenApply((ActionWithReturn & Serializable)bob -> {
            this.value = bob.getName();
            return this.value;
        }).apply((Object)Two.tuple((Object)new Person("bob"), (Object)"boo hoo!"));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)"bob"));
    }

    @Test
    public void caseOfPredicates() {
        Stream.of(1, 2, 3, 4).map(Matching.when().isValue((Object)1).thenApply((ActionWithReturn & Serializable)v -> "found 1").when().isTrue(i -> i % 2 == 0).thenApply((ActionWithReturn & Serializable)v -> "found even")).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        Matching.whenIterable().bothTrue(p -> p.isTall(), p -> true).thenExtract(Extractors.first()).thenApply((ActionWithReturn & Serializable)p -> {
            this.value = p.getName() + " is tall";
            return this.value;
        }).whenIterable().bothTrue(p -> p.isTall(), p -> true).thenExtract(Extractors.first()).thenApply((ActionWithReturn & Serializable)p -> {
            this.value = p.getName() + " is tall";
            return this.value;
        }).apply((Object)new Person("bob"));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)"bob is tall"));
    }

    @Test
    public void caseOfTuple() {
        Matching.whenIterable().allTrueNoType(new Predicate[]{p -> p.isTall(), a -> a.getCountry().equals("Ireland"), p -> true}).thenExtract(Extractors.of((int)0, (int)1)).thenApply((ActionWithReturn & Serializable)t -> {
            this.value = ((Person)t.v1).getName() + " is tall and lives in " + ((Address)t.v2).getCity();
            return this.value;
        }).whenIterable().allTrueNoType(new Predicate[]{p -> p.isTall(), a -> a.getCountry().equals("France"), p -> true}).thenExtract(Extractors.of((int)0, (int)1)).thenApply((ActionWithReturn & Serializable)t -> {
            this.value = ((Person)t.v1).getName() + " is tall and lives in " + ((Address)t.v2).getCity();
            return this.value;
        }).apply(Arrays.asList(new Person("bob"), new Address(), new Job()));
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)"bob is tall and lives in Dublin"));
    }

    @Test
    public void matchOfTuple() {
        Matching.whenIterable().bothMatch(Matchers.samePropertyValuesAs((Object)new Person("bob")), Matchers.anything()).thenExtract(Extractors.of((int)0, (int)1)).thenApply((ActionWithReturn & Serializable)t -> {
            this.value = ((Person)t.v1).getName() + " is tall and lives in " + ((Address)t.v2).getCity();
            return this.value;
        }).match(new Object[]{new Person("bob"), new Address()});
        Assert.assertThat((Object)this.value, (Matcher)Matchers.is((Object)"bob is tall and lives in Dublin"));
    }

    public static class Job {
    }

    public static class Address {
        public String getCountry() {
            return "Ireland";
        }

        public String getCity() {
            return "Dublin";
        }
    }

    public static class Person {
        String name;

        public boolean isTall() {
            return true;
        }

        @ConstructorProperties(value={"name"})
        public Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

