/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.comprehensions.comprehenders;

import com.aol.cyclops.lambda.api.Comprehender;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ListComprehender
implements Comprehender {
    @Override
    public Class getTargetClass() {
        return List.class;
    }

    public Object filter(Object t, Predicate p) {
        if (t instanceof List) {
            return ((List)t).stream().filter(p);
        }
        return ((Stream)t).filter(p);
    }

    public Object map(Object t, Function fn) {
        if (t instanceof List) {
            return ((List)t).stream().map(fn);
        }
        return ((Stream)t).map(fn);
    }

    public Object executeflatMap(Object t, Function fn) {
        return this.flatMap(t, input -> ListComprehender.unwrapOtherMonadTypesLC(this, fn.apply(input)));
    }

    public Object flatMap(Object t, Function fn) {
        if (t instanceof List) {
            return ((List)t).stream().flatMap(fn);
        }
        return ((Stream)t).flatMap(fn);
    }

    @Override
    public boolean instanceOfT(Object apply) {
        return apply instanceof Stream;
    }

    public List empty() {
        return Arrays.asList(new Object[0]);
    }

    public List of(Object o) {
        return Arrays.asList(o);
    }

    public List unwrap(Object o) {
        if (o instanceof List) {
            return (List)o;
        }
        return ((Stream)o).collect(Collectors.toList());
    }

    static Stream unwrapOtherMonadTypesLC(Comprehender comp, Object apply) {
        if (apply instanceof Collection) {
            return ((Collection)apply).stream();
        }
        if (apply instanceof Iterable) {
            return StreamSupport.stream(((Iterable)apply).spliterator(), false);
        }
        Object o = Comprehender.unwrapOtherMonadTypes(comp, apply);
        if (o instanceof Collection) {
            return ((Collection)o).stream();
        }
        if (o instanceof Iterable) {
            return StreamSupport.stream(((Iterable)o).spliterator(), false);
        }
        return (Stream)o;
    }
}

