/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.trampoline;

import java.util.stream.Stream;

public interface Trampoline<T> {
    default public Trampoline<T> bounce() {
        return this;
    }

    public T result();

    default public boolean complete() {
        return true;
    }

    public static <T> Trampoline<T> done(T result) {
        return () -> result;
    }

    public static <T> Trampoline<T> more(final Trampoline<Trampoline<T>> trampoline) {
        return new Trampoline<T>(){

            @Override
            public boolean complete() {
                return false;
            }

            @Override
            public Trampoline<T> bounce() {
                return (Trampoline)trampoline.result();
            }

            @Override
            public T result() {
                return this.trampoline(this);
            }

            T trampoline(Trampoline<T> trampoline2) {
                return Stream.iterate(trampoline2, Trampoline::bounce).filter(Trampoline::complete).findFirst().get().result();
            }
        };
    }
}

