/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.closures.immutable;

import com.aol.cyclops.closures.Convertable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class LazyImmutable<T>
implements Supplier<T>,
Consumer<T>,
Convertable<T> {
    private static final Object UNSET = new Object();
    private AtomicReference value = new AtomicReference<Object>(UNSET);
    private final AtomicBoolean set = new AtomicBoolean(false);

    @Override
    public T get() {
        return (T)this.value.get();
    }

    public static <T> LazyImmutable<T> unbound() {
        return new LazyImmutable<T>();
    }

    public static <T> LazyImmutable<T> of(T value) {
        LazyImmutable<T> v = new LazyImmutable<T>();
        v.setOnce(value);
        return v;
    }

    public static <T> LazyImmutable<T> def() {
        return new LazyImmutable<T>();
    }

    public <R> LazyImmutable<R> map(Function<T, R> fn) {
        T val = this.get();
        if (val == UNSET) {
            return this;
        }
        return LazyImmutable.of(fn.apply(val));
    }

    public <R> LazyImmutable<R> flatMap(Function<T, LazyImmutable<R>> fn) {
        T val = this.get();
        if (val == UNSET) {
            return this;
        }
        return fn.apply(val);
    }

    public LazyImmutable<T> setOnce(T val) {
        this.value.compareAndSet(UNSET, val);
        this.set.set(true);
        return this;
    }

    private T setOnceFromSupplier(Supplier<T> lazy) {
        this.value.compareAndSet(UNSET, lazy.get());
        return (T)this.value.get();
    }

    public T computeIfAbsent(Supplier<T> lazy) {
        T val = this.get();
        if (val == UNSET) {
            return this.setOnceFromSupplier(lazy);
        }
        return val;
    }

    @Override
    public void accept(T t) {
        this.setOnce(t);
    }

    public String toString() {
        return "LazyImmutable(value=" + this.value + ", set=" + this.set + ")";
    }
}

