/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.comprehensions;

import com.aol.cyclops.comprehensions.ComprehensionData;
import com.aol.cyclops.comprehensions.Proxier;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

class InvocationHandlerProxy<X>
implements InvocationHandler {
    private final Proxier proxier = new Proxier();
    private final Class<X> type;
    private volatile ComprehensionData compData;
    private X proxy;
    private ThreadLocal<Map<Class, List>> activeProxyStore;

    public InvocationHandlerProxy(Class<X> type) {
        this.type = type;
        this.compData = null;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("yield") && method.getParameterCount() == 1) {
            return this.handleYield(method, args);
        }
        if (method.getName().equals("filter") && method.getParameterCount() == 1) {
            return this.handleFilter(method, args);
        }
        if (method.getName().equals("run") && method.getParameterCount() == 1) {
            return this.handleConsume(method, args);
        }
        if (method.getParameterCount() == 0) {
            return this.compData.$(method.getName());
        }
        if (method.getParameterCount() == 1) {
            return this.handleBind(method, args);
        }
        throw new RuntimeException("No method available for " + method.getName());
    }

    private <X> X handleYieldSupplier(Method method, ComprehensionData compData, Object[] args) {
        return (X)compData.yield((Supplier)args[0]);
    }

    private <X> X handleYield(Method method, Object[] args) {
        if (args[0] instanceof Supplier) {
            return this.handleYieldSupplier(method, this.compData, args);
        }
        return (X)this.compData.yieldFunction((Function)args[0]);
    }

    private <X> X handleConsume(Method method, Object[] args) {
        if (args[0] instanceof Runnable) {
            this.compData.yield(() -> {
                ((Runnable)args[0]).run();
                return null;
            });
        } else {
            this.compData.yieldFunction(input -> {
                ((Consumer)args[0]).accept(input);
                return null;
            });
        }
        return null;
    }

    private <X> X handleFilter(Method method, Object[] args) {
        if (args[0] instanceof Function) {
            this.compData.filterFunction((Function)args[0]);
        } else {
            this.compData.filter((Supplier)args[0]);
        }
        if (method.getReturnType().isInterface() && this.type != method.getReturnType()) {
            return (X)this.proxier.newProxy(method.getReturnType(), this.compData, this.activeProxyStore);
        }
        return this.proxy;
    }

    private <X> X handleBind(Method method, Object[] args) {
        String name = method.getName();
        if (method.getName().indexOf(36) != -1) {
            name = method.getName().substring(method.getName().indexOf(36));
        }
        this.compData.$(name, this.applyFunction(args[0]));
        if (method.getReturnType().isInterface() && this.type != method.getReturnType()) {
            return (X)this.proxier.newProxy(method.getReturnType(), this.compData, this.activeProxyStore);
        }
        return this.proxy;
    }

    private Object applyFunction(Object o) {
        if (o instanceof Function) {
            Supplier<Object> s = () -> ((Function)o).apply(this.compData.getVars());
            return s;
        }
        return o;
    }

    public void setCompData(ComprehensionData compData) {
        this.compData = compData;
    }

    public void setProxy(X proxy) {
        this.proxy = proxy;
    }

    public void setActiveProxyStore(ThreadLocal<Map<Class, List>> activeProxyStore) {
        this.activeProxyStore = activeProxyStore;
    }
}

