/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads;

import com.aol.cyclops.lambda.monads.AnyMonads;
import com.aol.cyclops.lambda.monads.SequenceM;
import com.aol.cyclops.streams.StreamUtils;
import com.nurkiewicz.lazyseq.LazySeq;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SequenceMTest {
    int peek = 0;

    @Test
    public void splitBy() {
        Assert.assertThat((Object)((SequenceM)SequenceM.of((Object[])new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2), Integer.valueOf((int)3), Integer.valueOf((int)4), Integer.valueOf((int)5), Integer.valueOf((int)6)}).splitBy((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$splitBy$288(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v1).toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
        Assert.assertThat((Object)((SequenceM)SequenceM.of((Object[])new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2), Integer.valueOf((int)3), Integer.valueOf((int)4), Integer.valueOf((int)5), Integer.valueOf((int)6)}).splitBy((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$splitBy$289(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v2).toList(), (Matcher)Matchers.equalTo(Arrays.asList(4, 5, 6)));
    }

    @Test
    public void testLazy() {
        Collection col = SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5}).peek(System.out::println).toLazyCollection();
        System.out.println("first!");
        col.forEach(System.out::println);
    }

    @Test
    public void testPeek() {
        this.peek = 0;
        AnyMonads.anyM(Stream.of(Arrays.asList(1, 3))).flatMap(c -> AnyMonads.anyM(c.stream())).asSequence().map(i -> i * 2).peek(i -> {
            this.peek = i;
        }).collect(Collectors.toList());
        Assert.assertThat((Object)this.peek, (Matcher)Matchers.equalTo((Object)6));
    }

    @Test
    public void testMap() {
        List list = (List)AnyMonads.anyM(Stream.of(Arrays.asList(1, 3))).flatMap(c -> AnyMonads.anyM(c.stream())).asSequence().map(i -> i * 2).peek(System.out::println).collect(Collectors.toList());
        Assert.assertThat(Arrays.asList(2, 6), (Matcher)Matchers.equalTo((Object)list));
    }

    @Test
    public void headAndTailTest() {
        Stream<String> s = Stream.of("hello", "world");
        Iterator it = s.iterator();
        String head = (String)it.next();
        Stream tail = StreamUtils.stream(it);
        tail.forEach(System.out::println);
    }

    @Test
    public void testOfType() {
        Assert.assertThat((Object)SequenceM.of((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3), null}).ofType(Integer.class).toList(), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat((Object)SequenceM.of((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3), null}).ofType(Integer.class).toList(), (Matcher)Matchers.not((Matcher)Matchers.containsInAnyOrder((Object[])new Serializable[]{"a", "b", null})));
        Assert.assertThat((Object)SequenceM.of((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3), null}).ofType(Serializable.class).toList(), (Matcher)Matchers.containsInAnyOrder((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3)}));
    }

    @Test
    public void testCastPast() {
        SequenceM.of((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3), null}).cast(Date.class).map(d -> d.getTime());
    }

    @Test
    public void flatMapCompletableFuture() {
        Assert.assertThat((Object)SequenceM.of((Object[])new Integer[]{1, 2, 3}).flatMapCompletableFuture(i -> CompletableFuture.completedFuture(i + 2)).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(3, 4, 5)));
    }

    @Test
    public void flatMapOptional() {
        Assert.assertThat((Object)SequenceM.of((Object[])new Integer[]{1, 2, 3, null}).flatMapOptional(Optional::ofNullable).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testIntersperse() {
        Assert.assertThat((Object)SequenceM.of((Object[])new Integer[]{1, 2, 3}).intersperse((Object)0).toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 0, 2, 0, 3)));
    }

    @Test(expected=ClassCastException.class)
    public void cast() {
        SequenceM.of((Object[])new Integer[]{1, 2, 3}).cast(String.class).collect(Collectors.toList());
    }

    @Test
    public void xMatch() {
        Assert.assertTrue((boolean)SequenceM.of((Object[])new Integer[]{1, 2, 3, 5, 6, 7}).xMatch(3, i -> i > 4));
    }

    @Test
    public void collectIterables() {
        List result = SequenceM.of((Object[])new Integer[]{1, 2, 3}).collectIterable(Arrays.asList(Collectors.toList(), Collectors.summingInt(Integer::intValue), Collectors.averagingInt(Integer::intValue)));
        Assert.assertThat(result.get(0), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
        Assert.assertThat(result.get(1), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat(result.get(2), (Matcher)Matchers.equalTo((Object)2.0));
    }

    @Test
    public void testFlatMap() {
        System.out.println(LazySeq.of((Object)1).flatMap(i -> LazySeq.of(Arrays.asList(1, 3))).toList());
        System.out.println(Stream.of(Integer.valueOf(1)).flatMap(i -> Stream.of(Arrays.asList(1, 3))).collect(Collectors.toList()));
    }

    private static /* synthetic */ boolean lambda$splitBy$289(Integer i) {
        return i < 4;
    }

    private static /* synthetic */ boolean lambda$splitBy$288(Integer i) {
        return i < 4;
    }
}

