/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads;

import com.aol.cyclops.lambda.api.Monoid;
import com.aol.cyclops.lambda.monads.SequenceM;
import com.aol.cyclops.streams.Pair;
import com.aol.cyclops.streams.Quadruple;
import com.aol.cyclops.streams.Triple;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BaseSequenceMTest {
    SequenceM<Integer> empty;
    SequenceM<Integer> nonEmpty;

    @Before
    public void setup() {
        this.empty = SequenceM.of((Object[])new Integer[0]);
        this.nonEmpty = SequenceM.of((Object[])new Integer[]{1});
    }

    protected Object value() {
        return "jello";
    }

    private int value2() {
        return 200;
    }

    @Test
    public void batchBySize() {
        System.out.println(SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).grouped(3).collect(Collectors.toList()));
        Assert.assertThat((Object)((List)SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).grouped(3).collect(Collectors.toList())).size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void zip() {
        List list = (List)SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).zip((Stream)SequenceM.of((Object[])new Integer[]{100, 200, 300, 400})).peek(it -> System.out.println(it)).collect(Collectors.toList());
        List right = list.stream().map(t -> (Integer)t.v2).collect(Collectors.toList());
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)100));
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)200));
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)300));
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)400));
        List left = list.stream().map(t -> (Integer)t.v1).collect(Collectors.toList());
        Assert.assertThat(Arrays.asList(1, 2, 3, 4, 5, 6), (Matcher)Matchers.hasItem(left.get(0)));
    }

    @Test
    public void zip3() {
        List list = (List)SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).zip3((Stream)SequenceM.of((Object[])new Integer[]{100, 200, 300, 400}), (Stream)SequenceM.of((Object[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')})).peek(it -> System.out.println(it)).collect(Collectors.toList());
        List right = list.stream().map(t -> (Integer)t.v2).collect(Collectors.toList());
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)100));
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)200));
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)300));
        Assert.assertThat(right, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)400)));
        List left = list.stream().map(t -> (Integer)t.v1).collect(Collectors.toList());
        Assert.assertThat(Arrays.asList(1, 2, 3, 4, 5, 6), (Matcher)Matchers.hasItem(left.get(0)));
        List three = list.stream().map(t -> (Character)t.v3).collect(Collectors.toList());
        Assert.assertThat(Arrays.asList(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')), (Matcher)Matchers.hasItem(three.get(0)));
    }

    @Test
    public void zip4() {
        List list = (List)SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).zip4((Stream)SequenceM.of((Object[])new Integer[]{100, 200, 300, 400}), (Stream)SequenceM.of((Object[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}), (Stream)SequenceM.of((Object[])new String[]{"hello", "world"})).peek(it -> System.out.println(it)).collect(Collectors.toList());
        System.out.println(list);
        List right = list.stream().map(t -> (Integer)t.v2).collect(Collectors.toList());
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)100));
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)200));
        Assert.assertThat(right, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)300)));
        Assert.assertThat(right, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)400)));
        List left = list.stream().map(t -> (Integer)t.v1).collect(Collectors.toList());
        Assert.assertThat(Arrays.asList(1, 2, 3, 4, 5, 6), (Matcher)Matchers.hasItem(left.get(0)));
        List three = list.stream().map(t -> (Character)t.v3).collect(Collectors.toList());
        Assert.assertThat(Arrays.asList(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')), (Matcher)Matchers.hasItem(three.get(0)));
        List four = list.stream().map(t -> (String)t.v4).collect(Collectors.toList());
        Assert.assertThat(Arrays.asList("hello", "world"), (Matcher)Matchers.hasItem(four.get(0)));
    }

    @Test
    public void zip2of() {
        List list = (List)SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).zip((Stream)SequenceM.of((Object[])new Integer[]{100, 200, 300, 400})).peek(it -> System.out.println(it)).collect(Collectors.toList());
        List right = list.stream().map(t -> (Integer)t.v2).collect(Collectors.toList());
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)100));
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)200));
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)300));
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)400));
        List left = list.stream().map(t -> (Integer)t.v1).collect(Collectors.toList());
        Assert.assertThat(Arrays.asList(1, 2, 3, 4, 5, 6), (Matcher)Matchers.hasItem(left.get(0)));
    }

    @Test
    public void zipInOrder() {
        List list = (List)SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).zip((Stream)SequenceM.of((Object[])new Integer[]{100, 200, 300, 400})).collect(Collectors.toList());
        Assert.assertThat(Arrays.asList(1, 2, 3, 4, 5, 6), (Matcher)Matchers.hasItem((Object)((Pair)list.get((int)0)).v1));
        Assert.assertThat(Arrays.asList(100, 200, 300, 400), (Matcher)Matchers.hasItem((Object)((Pair)list.get((int)0)).v2));
    }

    @Test
    public void zipEmpty() throws Exception {
        SequenceM zipped = this.empty.zip(SequenceM.of((Object[])new Integer[0]), (a, b) -> a + b);
        Assert.assertTrue((boolean)((List)zipped.collect(Collectors.toList())).isEmpty());
    }

    @Test
    public void shouldReturnEmptySeqWhenZipEmptyWithNonEmpty() throws Exception {
        SequenceM zipped = this.empty.zip(this.nonEmpty, (a, b) -> a + b);
        Assert.assertTrue((boolean)((List)zipped.collect(Collectors.toList())).isEmpty());
    }

    @Test
    public void shouldReturnEmptySeqWhenZipNonEmptyWithEmpty() throws Exception {
        SequenceM zipped = this.nonEmpty.zip(this.empty, (a, b) -> a + b);
        Assert.assertTrue((boolean)((List)zipped.collect(Collectors.toList())).isEmpty());
    }

    @Test
    public void shouldZipTwoFiniteSequencesOfSameSize() throws Exception {
        SequenceM first = SequenceM.of((Object[])new String[]{"A", "B", "C"});
        SequenceM second = SequenceM.of((Object[])new Integer[]{1, 2, 3});
        SequenceM zipped = first.zip(second, (a, b) -> a + b);
        Assert.assertThat((Object)((List)zipped.collect(Collectors.toList())).size(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void shouldTrimSecondFixedSeqIfLonger() throws Exception {
        SequenceM first = SequenceM.of((Object[])new String[]{"A", "B", "C"});
        SequenceM second = SequenceM.of((Object[])new Integer[]{1, 2, 3, 4});
        SequenceM zipped = first.zip(second, (a, b) -> a + b);
        Assert.assertThat((Object)((List)zipped.collect(Collectors.toList())).size(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void shouldTrimFirstFixedSeqIfLonger() throws Exception {
        SequenceM first = SequenceM.of((Object[])new String[]{"A", "B", "C", "D"});
        SequenceM second = SequenceM.of((Object[])new Integer[]{1, 2, 3});
        SequenceM zipped = first.zip(second, (a, b) -> a + b);
        Assert.assertThat((Object)((List)zipped.collect(Collectors.toList())).size(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void limitWhileTest() {
        List list = new ArrayList();
        while (list.size() == 0) {
            list = (List)SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).limitWhile(it -> it < 4).peek(it -> System.out.println(it)).collect(Collectors.toList());
        }
        Assert.assertThat(Arrays.asList(1, 2, 3, 4, 5, 6), (Matcher)Matchers.hasItem(list.get(0)));
    }

    @Test
    public void testScanLeftStringConcat() {
        Assert.assertThat((Object)SequenceM.of((Object[])new String[]{"a", "b", "c"}).scanLeft((Object)"", String::concat).toList().size(), (Matcher)Matchers.is((Object)4));
    }

    @Test
    public void testScanLeftSum() {
        Assert.assertThat((Object)SequenceM.of((Object[])new String[]{"a", "ab", "abc"}).map(str -> str.length()).scanLeft((Object)0, (u, t) -> u + t).toList().size(), (Matcher)Matchers.is((Object)Arrays.asList(0, 1, 3, 6).size()));
    }

    @Test
    public void testScanRightStringConcatMonoid() {
        Assert.assertThat((Object)SequenceM.of((Object[])new String[]{"a", "b", "c"}).scanRight(Monoid.of((Object)"", String::concat)).toList().size(), (Matcher)Matchers.is((Object)Arrays.asList("", "c", "bc", "abc").size()));
    }

    @Test
    public void testScanRightStringConcat() {
        Assert.assertThat((Object)SequenceM.of((Object[])new String[]{"a", "b", "c"}).scanRight((Object)"", String::concat).toList().size(), (Matcher)Matchers.is((Object)Arrays.asList("", "c", "bc", "abc").size()));
    }

    @Test
    public void testScanRightSum() {
        Assert.assertThat((Object)SequenceM.of((Object[])new String[]{"a", "ab", "abc"}).map(str -> str.length()).scanRight((Object)0, (t, u) -> u + t).toList().size(), (Matcher)Matchers.is((Object)Arrays.asList(0, 3, 5, 6).size()));
    }

    @Test
    public void testReverse() {
        Assert.assertThat((Object)SequenceM.of((Object[])new Integer[]{1, 2, 3}).reverse().toList().size(), (Matcher)Matchers.is((Object)Arrays.asList(3, 2, 1).size()));
    }

    @Test
    public void testCycle() {
        Assert.assertEquals(Arrays.asList(1, 1, 1, 1, 1, 1), (Object)SequenceM.of((Object[])new Integer[]{1}).cycle().limit(6L).toList());
    }

    @Test
    public void testIterable() {
        List list = (List)SequenceM.of((Object[])new Integer[]{1, 2, 3}).toCollection(LinkedList::new);
        for (Integer i : SequenceM.of((Object[])new Integer[]{1, 2, 3})) {
            Assert.assertThat((Object)list, (Matcher)Matchers.hasItem((Object)i));
        }
    }

    @Test
    public void testDuplicate() {
        Pair copies = SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).duplicate();
        Assert.assertTrue((boolean)((SequenceM)copies.v1).anyMatch(i -> i == 2));
        Assert.assertTrue((boolean)((SequenceM)copies.v2).anyMatch(i -> i == 2));
    }

    @Test(expected=ClassCastException.class)
    public void testCastException() {
        SequenceM.of((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3), null}).peek(it -> System.out.println(it)).cast(Integer.class).peek(it -> System.out.println(it)).toList();
    }

    @Test
    public void testGroupByEager() {
        Map map1 = SequenceM.of((Object[])new Integer[]{1, 2, 3, 4}).groupBy(i -> i % 2);
        Assert.assertThat(map1.get(0), (Matcher)Matchers.hasItem((Object)2));
        Assert.assertThat(map1.get(0), (Matcher)Matchers.hasItem((Object)4));
        Assert.assertThat(map1.get(1), (Matcher)Matchers.hasItem((Object)1));
        Assert.assertThat(map1.get(1), (Matcher)Matchers.hasItem((Object)3));
        Assert.assertEquals((long)2L, (long)map1.size());
    }

    @Test
    public void testJoin() {
        Assert.assertEquals((long)"123".length(), (long)SequenceM.of((Object[])new Integer[]{1, 2, 3}).join().length());
        Assert.assertEquals((long)"1, 2, 3".length(), (long)SequenceM.of((Object[])new Integer[]{1, 2, 3}).join(", ").length());
        Assert.assertEquals((long)"^1|2|3$".length(), (long)SequenceM.of((Object[])new Integer[]{1, 2, 3}).join("|", "^", "$").length());
    }

    @Test
    public void testZipDifferingLength() {
        List list = SequenceM.of((Object[])new Integer[]{1, 2}).zip((Stream)SequenceM.of((Object[])new String[]{"a", "b", "c", "d"})).toList();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((Pair)list.get((int)0)).v1));
        Assert.assertTrue((String)("" + (String)((Pair)list.get((int)1)).v2), (boolean)Arrays.asList(1, 2).contains(((Pair)list.get((int)1)).v1));
        Assert.assertTrue((boolean)Arrays.asList("a", "b", "c", "d").contains(((Pair)list.get((int)0)).v2));
        Assert.assertTrue((boolean)Arrays.asList("a", "b", "c", "d").contains(((Pair)list.get((int)1)).v2));
    }

    @Test
    public void testZipWithIndex() {
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)SequenceM.of((Object[])new Object[0]).zipWithIndex().toList());
        Assert.assertThat(SequenceM.of((Object[])new String[]{"a"}).zipWithIndex().map(t -> (Long)t.v2).findFirst().get(), (Matcher)Matchers.is((Object)0L));
        Assert.assertEquals(Arrays.asList(new Pair((Object)"a", (Object)0L)), (Object)SequenceM.of((Object[])new String[]{"a"}).zipWithIndex().toList());
    }

    @Test
    public void testSkipWhile() {
        Supplier<SequenceM> s = () -> SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5});
        Assert.assertTrue((boolean)s.get().skipWhile(i -> false).toList().containsAll(Arrays.asList(1, 2, 3, 4, 5)));
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)s.get().skipWhile(i -> true).toList());
    }

    @Test
    public void testSkipUntil() {
        Supplier<SequenceM> s = () -> SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5});
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)s.get().skipUntil(i -> false).toList());
        Assert.assertTrue((boolean)s.get().skipUntil(i -> true).toList().containsAll(Arrays.asList(1, 2, 3, 4, 5)));
    }

    @Test
    public void testSkipUntilWithNulls() {
        Supplier<SequenceM> s = () -> SequenceM.of((Object[])new Integer[]{1, 2, null, 3, 4, 5});
        Assert.assertTrue((boolean)s.get().skipUntil(i -> true).toList().containsAll(Arrays.asList(1, 2, null, 3, 4, 5)));
    }

    @Test
    public void testLimitWhile() {
        Supplier<SequenceM> s = () -> SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5});
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)s.get().limitWhile(i -> false).toList());
        Assert.assertTrue((s.get().limitWhile(i -> i < 3).toList().size() != 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.get().limitWhile(i -> true).toList().containsAll(Arrays.asList(1, 2, 3, 4, 5)));
    }

    @Test
    public void testLimitUntil() {
        Assert.assertTrue((boolean)SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5}).limitUntil(i -> false).toList().containsAll(Arrays.asList(1, 2, 3, 4, 5)));
        Assert.assertFalse((SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5}).limitUntil(i -> i % 3 == 0).toList().size() == 5 ? 1 : 0) != 0);
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5}).limitUntil(i -> true).toList());
    }

    @Test
    public void testLimitUntilWithNulls() {
        System.out.println(SequenceM.of((Object[])new Integer[]{1, 2, null, 3, 4, 5}).limitUntil(i -> false).toList());
        Assert.assertTrue((boolean)SequenceM.of((Object[])new Integer[]{1, 2, null, 3, 4, 5}).limitUntil(i -> false).toList().containsAll(Arrays.asList(1, 2, null, 3, 4, 5)));
    }

    @Test
    public void testMinByMaxBy() {
        Supplier<SequenceM> s = () -> SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6});
        Assert.assertEquals((long)1L, (long)((Integer)s.get().maxBy(t -> Math.abs(t - 5)).get()).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)s.get().minBy(t -> Math.abs(t - 5)).get()).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)s.get().maxBy(t -> "" + t).get()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)s.get().minBy(t -> "" + t).get()).intValue());
    }

    @Test
    public void testFoldLeft() {
        for (int i = 0; i < 100; ++i) {
            Supplier<SequenceM> s = () -> SequenceM.of((Object[])new String[]{"a", "b", "c"});
            Assert.assertTrue((boolean)((String)s.get().reduce((Object)"", String::concat)).contains("a"));
            Assert.assertTrue((boolean)((String)s.get().reduce((Object)"", String::concat)).contains("b"));
            Assert.assertTrue((boolean)((String)s.get().reduce((Object)"", String::concat)).contains("c"));
            Assert.assertEquals((long)3L, (long)((Integer)s.get().map(str -> str.length()).foldLeft((Object)0, (u, t) -> u + t)).intValue());
            Assert.assertEquals((long)3L, (long)((Integer)s.get().map(str -> str.length()).foldRight((Object)0, (t, u) -> u + t)).intValue());
        }
    }

    @Test
    public void testFoldRight() {
        Supplier<SequenceM> s = () -> SequenceM.of((Object[])new String[]{"a", "b", "c"});
        Assert.assertTrue((boolean)((String)s.get().foldRight((Object)"", String::concat)).contains("a"));
        Assert.assertTrue((boolean)((String)s.get().foldRight((Object)"", String::concat)).contains("b"));
        Assert.assertTrue((boolean)((String)s.get().foldRight((Object)"", String::concat)).contains("c"));
        Assert.assertEquals((long)3L, (long)((Integer)s.get().map(str -> str.length()).foldRight((Object)0, (t, u) -> u + t)).intValue());
    }

    @Test
    public void flattenEmpty() throws Exception {
        Assert.assertTrue((boolean)SequenceM.of((Object[])new Integer[0]).flatten().toList().isEmpty());
    }

    @Test
    public void flatten() throws Exception {
        Assert.assertThat((Object)SequenceM.of((Object[])new List[]{Arrays.asList(1, 2)}).flatten().toList().size(), (Matcher)Matchers.equalTo((Object)Arrays.asList(1, 2).size()));
    }

    @Test
    public void testSplitBy() {
        Supplier<SequenceM> s = () -> SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6});
        Assert.assertEquals((long)6L, (long)(((SequenceM)s.get().splitBy((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testSplitBy$127(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v1).toList().size() + ((SequenceM)s.get().splitBy((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testSplitBy$128(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v2).toList().size()));
        Assert.assertTrue((boolean)((SequenceM)s.get().splitBy((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testSplitBy$129(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v1).toList().containsAll(Arrays.asList(1, 2, 3, 4, 5, 6)));
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((SequenceM)s.get().splitBy((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testSplitBy$130(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v2).toList());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((SequenceM)s.get().splitBy((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testSplitBy$131(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v1).toList());
        Assert.assertTrue((boolean)((SequenceM)s.get().splitBy((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testSplitBy$132(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v2).toList().containsAll(Arrays.asList(1, 2, 3, 4, 5, 6)));
    }

    @Test
    public void flattenEmptyStream() throws Exception {
        Assert.assertThat((Object)((List)SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5, 5, 6, 8, 9, 10}).flatten().limit(10L).collect(Collectors.toList())).size(), (Matcher)Matchers.equalTo((Object)Arrays.asList(2, 3, 4, 5, 6, 7, 0, 0, 0, 0).size()));
    }

    @Test
    public void testSplitAt() {
        for (int i = 0; i < 1000; ++i) {
            Supplier<SequenceM> s = () -> SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6});
            Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((SequenceM)s.get().splitAt((int)0).v1).toList());
            Assert.assertTrue((boolean)((SequenceM)s.get().splitAt((int)0).v2).toList().containsAll(Arrays.asList(1, 2, 3, 4, 5, 6)));
            Assert.assertEquals((long)1L, (long)((SequenceM)s.get().splitAt((int)1).v1).toList().size());
            Assert.assertEquals((long)((SequenceM)s.get().splitAt((int)1).v2).toList().size(), (long)5L);
            Assert.assertEquals((long)3L, (long)((SequenceM)s.get().splitAt((int)3).v1).toList().size());
            Assert.assertEquals((long)3L, (long)((SequenceM)s.get().splitAt((int)3).v2).count());
            Assert.assertEquals((long)6L, (long)((SequenceM)s.get().splitAt((int)6).v1).toList().size());
            Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((SequenceM)s.get().splitAt((int)6).v2).toList());
            Assert.assertThat((Object)((SequenceM)s.get().splitAt((int)7).v1).toList().size(), (Matcher)Matchers.is((Object)6));
            Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((SequenceM)s.get().splitAt((int)7).v2).toList());
        }
    }

    @Test
    public void testSplitAtHead() {
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((SequenceM)SequenceM.of((Object[])new Integer[]{Integer.valueOf((int)1)}).splitAtHead().v2).toList());
        Assert.assertEquals(Optional.empty(), (Object)SequenceM.of((Object[])new Object[0]).splitAtHead().v1);
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((SequenceM)SequenceM.of((Object[])new Object[0]).splitAtHead().v2).toList());
        Assert.assertEquals(Optional.of(1), (Object)SequenceM.of((Object[])new Integer[]{Integer.valueOf((int)1)}).splitAtHead().v1);
        Assert.assertEquals(Optional.of(1), (Object)SequenceM.of((Object[])new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2)}).splitAtHead().v1);
        Assert.assertEquals(Arrays.asList(2), (Object)((SequenceM)SequenceM.of((Object[])new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2)}).splitAtHead().v2).toList());
        Assert.assertEquals(Optional.of(1), (Object)SequenceM.of((Object[])new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2), Integer.valueOf((int)3)}).splitAtHead().v1);
        Assert.assertEquals(Optional.of(2), (Object)((SequenceM)SequenceM.of((Object[])new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2), Integer.valueOf((int)3)}).splitAtHead().v2).splitAtHead().v1);
        Assert.assertEquals(Optional.of(3), (Object)((SequenceM)((SequenceM)SequenceM.of((Object[])new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2), Integer.valueOf((int)3)}).splitAtHead().v2).splitAtHead().v2).splitAtHead().v1);
        Assert.assertEquals(Arrays.asList(2, 3), (Object)((SequenceM)SequenceM.of((Object[])new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2), Integer.valueOf((int)3)}).splitAtHead().v2).toList());
        Assert.assertEquals(Arrays.asList(3), (Object)((SequenceM)((SequenceM)SequenceM.of((Object[])new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2), Integer.valueOf((int)3)}).splitAtHead().v2).splitAtHead().v2).toList());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((SequenceM)((SequenceM)((SequenceM)SequenceM.of((Object[])new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2), Integer.valueOf((int)3)}).splitAtHead().v2).splitAtHead().v2).splitAtHead().v2).toList());
    }

    @Test
    public void testUnzip() {
        Supplier<SequenceM> s = () -> SequenceM.of((Object[])new Pair[]{new Pair((Object)1, (Object)"a"), new Pair((Object)2, (Object)"b"), new Pair((Object)3, (Object)"c")});
        Pair u1 = SequenceM.unzip((SequenceM)s.get());
        Assert.assertTrue((boolean)((SequenceM)u1.v1).toList().containsAll(Arrays.asList(1, 2, 3)));
        Assert.assertTrue((boolean)((SequenceM)u1.v2).toList().containsAll(Arrays.asList("a", "b", "c")));
    }

    @Test
    public void testUnzipWithLimits() {
        Supplier<SequenceM> s = () -> SequenceM.of((Object[])new Pair[]{new Pair((Object)1, (Object)"a"), new Pair((Object)2, (Object)"b"), new Pair((Object)3, (Object)"c")});
        Pair u1 = SequenceM.unzip((SequenceM)s.get());
        Assert.assertTrue((boolean)((SequenceM)u1.v1).limit(2L).toList().containsAll(Arrays.asList(1, 2)));
        Assert.assertTrue((boolean)((SequenceM)u1.v2).toList().containsAll(Arrays.asList("a", "b", "c")));
    }

    @Test
    public void testUnzip3WithLimits() {
        Supplier<SequenceM> s = () -> SequenceM.of((Object[])new Triple[]{new Triple((Object)1, (Object)"a", (Object)2L), new Triple((Object)2, (Object)"b", (Object)3L), new Triple((Object)3, (Object)"c", (Object)4L)});
        Triple u1 = SequenceM.unzip3((SequenceM)s.get());
        Assert.assertTrue((boolean)((SequenceM)u1.v1).limit(1L).toList().containsAll(Arrays.asList(1)));
        Assert.assertTrue((boolean)((SequenceM)u1.v2).limit(2L).toList().containsAll(Arrays.asList("a", "b")));
        Assert.assertTrue((boolean)((SequenceM)u1.v3).toList().containsAll(Arrays.asList(2L, 3L, 4L)));
    }

    @Test
    public void testUnzip3() {
        Supplier<SequenceM> s = () -> SequenceM.of((Object[])new Triple[]{new Triple((Object)1, (Object)"a", (Object)2L), new Triple((Object)2, (Object)"b", (Object)3L), new Triple((Object)3, (Object)"c", (Object)4L)});
        Triple u1 = SequenceM.unzip3((SequenceM)s.get());
        Assert.assertTrue((boolean)((SequenceM)u1.v1).toList().containsAll(Arrays.asList(1, 2, 3)));
        Assert.assertTrue((boolean)((SequenceM)u1.v2).toList().containsAll(Arrays.asList("a", "b", "c")));
        Assert.assertTrue((boolean)((SequenceM)u1.v3).toList().containsAll(Arrays.asList(2L, 3L, 4L)));
    }

    @Test
    public void testUnzip4() {
        Supplier<SequenceM> s = () -> SequenceM.of((Object[])new Quadruple[]{new Quadruple((Object)1, (Object)"a", (Object)2L, (Object)Character.valueOf('z')), new Quadruple((Object)2, (Object)"b", (Object)3L, (Object)Character.valueOf('y')), new Quadruple((Object)3, (Object)"c", (Object)4L, (Object)Character.valueOf('x'))});
        Quadruple u1 = SequenceM.unzip4((SequenceM)s.get());
        Assert.assertTrue((boolean)((SequenceM)u1.v1).toList().containsAll(Arrays.asList(1, 2, 3)));
        Assert.assertTrue((boolean)((SequenceM)u1.v2).toList().containsAll(Arrays.asList("a", "b", "c")));
        Assert.assertTrue((boolean)((SequenceM)u1.v3).toList().containsAll(Arrays.asList(2L, 3L, 4L)));
        Assert.assertTrue((boolean)((SequenceM)u1.v4).toList().containsAll(Arrays.asList(Character.valueOf('z'), Character.valueOf('y'), Character.valueOf('x'))));
    }

    @Test
    public void testUnzip4WithLimits() {
        Supplier<SequenceM> s = () -> SequenceM.of((Object[])new Quadruple[]{new Quadruple((Object)1, (Object)"a", (Object)2L, (Object)Character.valueOf('z')), new Quadruple((Object)2, (Object)"b", (Object)3L, (Object)Character.valueOf('y')), new Quadruple((Object)3, (Object)"c", (Object)4L, (Object)Character.valueOf('x'))});
        Quadruple u1 = SequenceM.unzip4((SequenceM)s.get());
        Assert.assertTrue((boolean)((SequenceM)u1.v1).limit(1L).toList().containsAll(Arrays.asList(1)));
        Assert.assertTrue((boolean)((SequenceM)u1.v2).limit(2L).toList().containsAll(Arrays.asList("a", "b")));
        Assert.assertTrue((boolean)((SequenceM)u1.v3).limit(3L).toList().containsAll(Arrays.asList(2L, 3L, 4L)));
        Assert.assertTrue((boolean)((SequenceM)u1.v4).limit(4L).toList().containsAll(Arrays.asList(Character.valueOf('z'), Character.valueOf('y'), Character.valueOf('x'))));
    }

    private static /* synthetic */ boolean lambda$testSplitBy$132(Integer i) {
        return false;
    }

    private static /* synthetic */ boolean lambda$testSplitBy$131(Integer i) {
        return false;
    }

    private static /* synthetic */ boolean lambda$testSplitBy$130(Integer i) {
        return true;
    }

    private static /* synthetic */ boolean lambda$testSplitBy$129(Integer i) {
        return true;
    }

    private static /* synthetic */ boolean lambda$testSplitBy$128(Integer i) {
        return i % 2 != 0;
    }

    private static /* synthetic */ boolean lambda$testSplitBy$127(Integer i) {
        return i % 2 != 0;
    }
}

