/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams;

import com.aol.cyclops.lambda.api.AsAnyM;
import com.aol.cyclops.lambda.api.AsStreamable;
import com.aol.cyclops.lambda.api.Monoid;
import com.aol.cyclops.lambda.api.Streamable;
import com.aol.cyclops.streams.HeadAndTail;
import com.aol.cyclops.streams.Pair;
import com.aol.cyclops.streams.ReversedIterator;
import com.nurkiewicz.lazyseq.LazySeq;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamUtils {
    public static final <T> HeadAndTail<T> headAndTail(Stream<T> stream) {
        Iterator it = stream.iterator();
        return new HeadAndTail(it.next(), AsAnyM.anyM(StreamUtils.stream(it)).asSequence());
    }

    public static final <T> Optional<HeadAndTail<T>> headAndTailOptional(Stream<T> stream) {
        Iterator it = stream.iterator();
        if (it.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(new HeadAndTail(it.next(), AsAnyM.anyM(StreamUtils.stream(it)).asSequence()));
    }

    public static <U> Stream<U> skipUntil(Stream<U> stream, Predicate<? super U> predicate) {
        return LazySeq.of(stream.iterator()).dropWhile(predicate.negate()).stream();
    }

    public static <U> Stream<U> skipWhile(Stream<U> stream, Predicate<? super U> predicate) {
        return LazySeq.of(stream.iterator()).dropWhile(predicate).stream();
    }

    public static <U> Stream<U> limitWhile(Stream<U> stream, Predicate<? super U> predicate) {
        return LazySeq.of(stream.iterator()).takeWhile(predicate).stream();
    }

    public static <U> Stream<U> limitUntil(Stream<U> stream, Predicate<? super U> predicate) {
        return LazySeq.of(stream.iterator()).takeWhile(predicate.negate()).stream();
    }

    public static <U> Stream<U> reverse(Stream<U> stream) {
        return StreamUtils.reversedStream(stream.collect(Collectors.toList()));
    }

    public static <U> Stream<U> reversedStream(List<U> list) {
        return new ReversedIterator<U>(list).stream();
    }

    public static <U> Stream<U> cycle(Stream<U> s) {
        return StreamUtils.cycle(AsStreamable.asStreamable(s));
    }

    public static <U> Stream<U> cycle(Streamable<U> s) {
        return Stream.iterate(s.stream(), s1 -> s.stream()).flatMap(Function.identity());
    }

    public static <U> Stream<U> cycle(int times, Streamable<U> s) {
        return Stream.iterate(s.stream(), s1 -> s.stream()).limit(times).flatMap(Function.identity());
    }

    public static <U> Stream<U> stream(Iterable<U> it) {
        return StreamSupport.stream(it.spliterator(), false);
    }

    public static <U> Stream<U> stream(Iterator<U> it) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false);
    }

    public static <U> Stream<U> concat(Object o, Stream<U> stream) {
        Stream<Object> first = null;
        first = o instanceof Stream ? (Stream<U>)o : (o instanceof Iterable ? StreamUtils.stream((Iterable)o) : (o instanceof Streamable ? ((Streamable)o).stream() : Stream.of(o)));
        return Stream.concat(first, stream);
    }

    public static <K, V> Stream<Map.Entry<K, V>> stream(Map<K, V> it) {
        return it.entrySet().stream();
    }

    public static <R> List<R> reduce(Stream<R> stream, final Iterable<Monoid<R>> reducers) {
        Monoid m = new Monoid(){

            public List zero() {
                return StreamUtils.stream(reducers).map(r -> r.zero()).collect(Collectors.toList());
            }

            public BiFunction<List, List, List> combiner() {
                return (c1, c2) -> {
                    ArrayList l = new ArrayList();
                    int i = 0;
                    for (Monoid next : reducers) {
                        l.add(next.combiner().apply(c1.get(i), c2.get(0)));
                        ++i;
                    }
                    return l;
                };
            }

            public Stream mapToType(Stream stream) {
                return stream.map(value -> Arrays.asList(value));
            }
        };
        return (List)m.mapReduce(stream);
    }

    public static <R> List<R> reduce(Stream<R> stream, Stream<Monoid<R>> reducers) {
        return StreamUtils.reduce(stream, reducers.collect(Collectors.toList()));
    }

    public static <T, A, R> List<R> collect(Stream<T> stream, Stream<Collector> collectors) {
        return StreamUtils.collect(stream, AsStreamable.asStreamable(collectors));
    }

    public static <T, A, R> List<R> collect(Stream<T> stream, Iterable<Collector> collectors) {
        return StreamUtils.collect(stream, AsStreamable.asStreamable(collectors));
    }

    public static <T> List collect(Stream<T> stream, Streamable<Collector> collectors) {
        Supplier<Object> supplier = () -> collectors.stream().map(c -> c.supplier().get()).collect(Collectors.toList());
        BiConsumer<Object, Object> accumulator = (acc, next) -> LazySeq.of(collectors.stream().iterator()).zip(LazySeq.of((Iterable)((List)acc)), (a, b) -> new Pair<Collector, Object>((Collector)a, b)).forEach(t -> ((Collector)t._1()).accumulator().accept(t._2(), next));
        BinaryOperator combiner = (t1, t2) -> {
            Iterator t1It = ((Iterable)t1).iterator();
            Iterator t2It = ((Iterable)t2).iterator();
            return collectors.stream().map(c -> c.combiner().apply(t1It.next(), t2It.next())).collect(Collectors.toList());
        };
        Function<Object, Object> finisher = t1 -> {
            Iterator t1It = ((Iterable)t1).iterator();
            return collectors.stream().map(c -> c.finisher().apply(t1It.next())).collect(Collectors.toList());
        };
        Collector<Object, Object, Object> col = Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
        return (List)stream.collect(col);
    }
}

