/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads;

import com.aol.cyclops.internal.AsGenericMonad;
import com.aol.cyclops.internal.Monad;
import com.aol.cyclops.lambda.api.AsStreamable;
import com.aol.cyclops.lambda.api.Monoid;
import com.aol.cyclops.lambda.api.Streamable;
import com.aol.cyclops.lambda.api.Unwrapable;
import com.aol.cyclops.lambda.monads.AnyM;
import com.aol.cyclops.lambda.monads.ComprehenderSelector;
import com.aol.cyclops.streams.HeadAndTail;
import com.aol.cyclops.streams.StreamUtils;
import com.nurkiewicz.lazyseq.LazySeq;
import java.io.BufferedReader;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class SequenceM<T>
implements Unwrapable {
    private final Stream<T> monad;

    SequenceM(LazySeq<T> seq) {
        this.monad = seq.stream();
    }

    SequenceM(Stream<T> stream) {
        this.monad = stream;
    }

    static <T> SequenceM<T> monad(Stream<T> stream) {
        return new SequenceM<T>(stream);
    }

    static <T> SequenceM<T> monad(LazySeq<T> stream) {
        return new SequenceM<T>(stream);
    }

    @Override
    public final <R> R unwrap() {
        return (R)this.monad;
    }

    public final Stream<T> unwrapStream() {
        Stream<Integer> unwrapper = Stream.of(Integer.valueOf(1));
        return new ComprehenderSelector().selectComprehender(unwrapper).executeflatMap(unwrapper, i -> this.unwrap());
    }

    public final Optional<List<T>> unwrapOptional() {
        Optional<Integer> unwrapper = Optional.of(1);
        return new ComprehenderSelector().selectComprehender(unwrapper).executeflatMap(unwrapper, i -> this.unwrap());
    }

    public final CompletableFuture<List<T>> unwrapCompletableFuture() {
        CompletableFuture<Integer> unwrapper = CompletableFuture.completedFuture(1);
        return new ComprehenderSelector().selectComprehender(unwrapper).executeflatMap(unwrapper, i -> this.unwrap());
    }

    public final SequenceM<T> cycle(int times) {
        return new SequenceM<T>(StreamUtils.cycle(times, AsStreamable.asStreamable(this.monad)));
    }

    public final SequenceM<T> cycle(Monoid<T> m, int times) {
        return SequenceM.monad(StreamUtils.cycle(times, AsStreamable.asStreamable(m.reduce(this.monad))));
    }

    private Stream<T> createLazySeq() {
        return this.monad;
    }

    public final <R> SequenceM<R> cycle(Class<R> monadC, int times) {
        return this.cycle(times).map(r -> new ComprehenderSelector().selectComprehender(monadC).of(r));
    }

    public final SequenceM<T> cycleWhile(Predicate<? super T> predicate) {
        return SequenceM.monad(LazySeq.of(StreamUtils.cycle(this.monad).iterator()).takeWhile(predicate).stream());
    }

    public final SequenceM<T> cycleUntil(Predicate<? super T> predicate) {
        return SequenceM.monad(LazySeq.of(StreamUtils.cycle(this.monad).iterator()).takeWhile(predicate.negate()).stream());
    }

    public final <S, R> SequenceM<R> zip(SequenceM<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return SequenceM.monad(LazySeq.of(this.createLazySeq().iterator()).zip(LazySeq.of(super.createLazySeq().iterator()), zipper).stream());
    }

    public final <S, R> SequenceM<R> zip(AnyM<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return this.zip(second.toSequence(), zipper);
    }

    public final <S, R> SequenceM<R> zip(Stream<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return SequenceM.monad(this.steamToLazySeq().zip(LazySeq.of(second.iterator()), zipper).stream());
    }

    public final SequenceM<List<T>> sliding(int windowSize) {
        return SequenceM.monad(this.steamToLazySeq().sliding(windowSize).stream());
    }

    public final SequenceM<List<T>> grouped(int groupSize) {
        return SequenceM.monad(LazySeq.of(this.createLazySeq().iterator()).grouped(groupSize).stream());
    }

    public final SequenceM<T> distinct() {
        return SequenceM.monad(this.monad.distinct());
    }

    public final SequenceM<T> scanLeft(Monoid<T> monoid) {
        return SequenceM.monad(this.steamToLazySeq().scan(monoid.zero(), monoid.reducer()).stream());
    }

    private LazySeq<T> steamToLazySeq() {
        return LazySeq.of(this.monad.iterator());
    }

    public final SequenceM<T> sorted() {
        return SequenceM.monad(this.monad.sorted());
    }

    public final SequenceM<T> sorted(Comparator<? super T> c) {
        return SequenceM.monad(this.monad.sorted(c));
    }

    public final SequenceM<T> skip(int num) {
        return SequenceM.monad(this.steamToLazySeq().drop((long)num));
    }

    public final SequenceM<T> skipWhile(Predicate<? super T> p) {
        return SequenceM.monad(this.steamToLazySeq().dropWhile(p));
    }

    public final SequenceM<T> skipUntil(Predicate<? super T> p) {
        return SequenceM.monad(this.steamToLazySeq().dropWhile(p.negate()));
    }

    public final SequenceM<T> limit(int num) {
        return SequenceM.monad(this.monad.limit(num));
    }

    public final SequenceM<T> limitWhile(Predicate<? super T> p) {
        return SequenceM.monad(this.steamToLazySeq().takeWhile(p));
    }

    public final SequenceM<T> limitUntil(Predicate<? super T> p) {
        return SequenceM.monad(this.steamToLazySeq().takeWhile(p.negate()));
    }

    public final SequenceM<T> parallel() {
        return SequenceM.monad((Stream)this.monad.parallel());
    }

    public final boolean allMatch(Predicate<? super T> c) {
        return this.monad.allMatch(c);
    }

    public final boolean anyMatch(Predicate<? super T> c) {
        return this.monad.anyMatch(c);
    }

    public boolean xMatch(int num, Predicate<? super T> c) {
        return this.monad.map(t -> c.test(t)).collect(Collectors.counting()) == (long)num;
    }

    public final boolean noneMatch(Predicate<? super T> c) {
        return this.monad.allMatch(c.negate());
    }

    public final String mkString(String sep) {
        return this.steamToLazySeq().mkString(sep);
    }

    public final String mkString(String start, String sep, String end) {
        return this.steamToLazySeq().mkString(start, sep, end);
    }

    public final String mkString(String start, String sep, String end, boolean lazy) {
        return this.steamToLazySeq().mkString(start, sep, end, lazy);
    }

    public final <C extends Comparable<? super C>> Optional<T> minBy(Function<T, C> f) {
        return this.steamToLazySeq().minBy(f);
    }

    public final Optional<T> min(Comparator<? super T> comparator) {
        return this.steamToLazySeq().min(comparator);
    }

    public final <C extends Comparable<? super C>> Optional<T> maxBy(Function<T, C> f) {
        return this.steamToLazySeq().maxBy(f);
    }

    public final Optional<T> max(Comparator<? super T> comparator) {
        return this.steamToLazySeq().max(comparator);
    }

    public final HeadAndTail<T> headAndTail() {
        return StreamUtils.headAndTail(this.monad);
    }

    public final Optional<HeadAndTail<T>> headAndTailOptional() {
        return StreamUtils.headAndTailOptional(this.monad);
    }

    public final Optional<T> findFirst() {
        return this.monad.findFirst();
    }

    public final Optional<T> findAny() {
        return this.monad.findAny();
    }

    public final <R> R mapReduce(Monoid<R> reducer) {
        return reducer.mapReduce(this.monad);
    }

    public final <R> R mapReduce(Function<? super T, ? extends R> mapper, Monoid<R> reducer) {
        return reducer.reduce(this.monad.map(mapper));
    }

    public final <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.monad.collect(collector);
    }

    public final <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.monad.collect(supplier, accumulator, combiner);
    }

    public final List collect(Stream<Collector> collectors) {
        return StreamUtils.collect(this.monad, collectors);
    }

    public final T reduce(Monoid<T> reducer) {
        return reducer.reduce(this.monad);
    }

    public final Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.monad.reduce(accumulator);
    }

    public final T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.monad.reduce(identity, accumulator);
    }

    public final <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.monad.reduce(identity, accumulator, combiner);
    }

    public final List<T> reduce(Stream<Monoid<T>> reducers) {
        return StreamUtils.reduce(this.monad, reducers);
    }

    public final List<T> reduce(Iterable<Monoid<T>> reducers) {
        return StreamUtils.reduce(this.monad, reducers);
    }

    public final T foldLeft(Monoid<T> reducer) {
        return this.reduce(reducer);
    }

    public final <T> T foldLeftMapToType(Monoid<T> reducer) {
        return reducer.mapReduce(this.monad);
    }

    public final T foldRight(Monoid<T> reducer) {
        return reducer.reduce(StreamUtils.reverse(this.monad));
    }

    public final <T> T foldRightMapToType(Monoid<T> reducer) {
        return reducer.mapReduce(StreamUtils.reverse(this.monad));
    }

    public final Streamable<T> toStreamable() {
        return AsStreamable.asStreamable(this.stream());
    }

    public final Set<T> toSet() {
        return this.monad.collect(Collectors.toSet());
    }

    public final List<T> toList() {
        return this.monad.collect(Collectors.toList());
    }

    public final <T> Stream<T> toStream() {
        return this.monad;
    }

    public final Stream<T> stream() {
        return this.monad;
    }

    public final boolean startsWith(Iterable<T> iterable) {
        return this.steamToLazySeq().startsWith(iterable);
    }

    public final boolean startsWith(Iterator<T> iterator) {
        return this.steamToLazySeq().startsWith(iterator);
    }

    public AnyM<T> anyM() {
        return new AnyM(AsGenericMonad.asMonad(this.monad));
    }

    public final <R> SequenceM<R> map(Function<? super T, ? extends R> fn) {
        return new SequenceM<R>(this.monad.map(fn));
    }

    public final SequenceM<T> peek(Consumer<? super T> c) {
        return new SequenceM<T>(this.monad.peek(c));
    }

    public final <R> SequenceM<R> flatMap(Function<? super T, SequenceM<? extends R>> fn) {
        return AsGenericMonad.asMonad(this.monad).bind(in -> ((SequenceM)fn.apply(in)).unwrap()).sequence();
    }

    public final <R> SequenceM<R> flatMapAnyM(Function<? super T, AnyM<? extends R>> fn) {
        return AsGenericMonad.asMonad(this.monad).bind(in -> ((AnyM)fn.apply(in)).unwrap()).sequence();
    }

    public final <R> SequenceM<R> flatMapCollection(Function<? super T, Collection<? extends R>> fn) {
        return AsGenericMonad.asMonad(this.monad).bind(in -> (Collection)fn.apply(in)).sequence();
    }

    public final <R> SequenceM<R> flatMapStream(Function<? super T, BaseStream<? extends R, ?>> fn) {
        Monad m = AsGenericMonad.asMonad(this.monad);
        return m.flatMap((? super T in) -> (BaseStream)fn.apply(in)).sequence();
    }

    public final <R> SequenceM<R> flatMapOptional(Function<? super T, Optional<? extends R>> fn) {
        Monad m = AsGenericMonad.asMonad(this.monad);
        return m.flatMap((? super T in) -> (Optional)fn.apply(in)).sequence();
    }

    public final <R> SequenceM<R> flatMapCompletableFuture(Function<? super T, CompletableFuture<? extends R>> fn) {
        return AsGenericMonad.asMonad(this.monad).bind(in -> (CompletableFuture)fn.apply(in)).sequence();
    }

    public final <R> SequenceM<R> flatMapLazySeq(Function<? super T, LazySeq<? extends R>> fn) {
        return AsGenericMonad.asMonad(this.monad).bind(in -> (LazySeq)fn.apply(in)).sequence();
    }

    public final SequenceM<Character> liftAndBindCharSequence(Function<? super T, CharSequence> fn) {
        return AsGenericMonad.asMonad(this.monad).liftAndBind(fn).sequence();
    }

    public final SequenceM<String> liftAndBindFile(Function<? super T, File> fn) {
        return AsGenericMonad.asMonad(this.monad).liftAndBind(fn).sequence();
    }

    public final SequenceM<String> liftAndBindURL(Function<? super T, URL> fn) {
        return AsGenericMonad.asMonad(this.monad).liftAndBind(fn).sequence();
    }

    public final SequenceM<String> liftAndBindBufferedReader(Function<? super T, BufferedReader> fn) {
        return AsGenericMonad.asMonad(this.monad).liftAndBind(fn).sequence();
    }

    public final SequenceM<T> filter(Predicate<? super T> fn) {
        return AsGenericMonad.asMonad(this.monad).filter((Predicate)fn).sequence();
    }

    public void forEach(Consumer<? super T> action) {
        this.monad.forEach(action);
    }

    public Iterator<T> iterator() {
        return this.monad.iterator();
    }

    public Spliterator<T> spliterator() {
        return this.monad.spliterator();
    }

    public boolean isParallel() {
        return this.monad.isParallel();
    }

    public SequenceM<T> sequential() {
        return SequenceM.monad((Stream)this.monad.sequential());
    }

    public SequenceM<T> unordered() {
        return SequenceM.monad((Stream)this.monad.unordered());
    }

    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.monad.mapToInt(mapper);
    }

    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.monad.mapToLong(mapper);
    }

    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.monad.mapToDouble(mapper);
    }

    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.monad.flatMapToInt(mapper);
    }

    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.monad.flatMapToLong(mapper);
    }

    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.monad.flatMapToDouble(mapper);
    }

    public void forEachOrdered(Consumer<? super T> action) {
        this.monad.forEachOrdered(action);
    }

    public Object[] toArray() {
        return this.monad.toArray();
    }

    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.monad.toArray(generator);
    }

    public long count() {
        return this.monad.count();
    }
}

