/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal;

import com.aol.cyclops.internal.AsGenericMonad;
import com.aol.cyclops.internal.MonadFunctions;
import com.aol.cyclops.lambda.api.AsStreamable;
import com.aol.cyclops.lambda.monads.AnyM;
import com.aol.cyclops.lambda.monads.ComprehenderSelector;
import com.aol.cyclops.lambda.monads.Filterable;
import com.aol.cyclops.lambda.monads.Functor;
import com.aol.cyclops.lambda.monads.SequenceM;
import com.aol.cyclops.streams.StreamUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Monad<MONAD, T>
extends MonadFunctions<MONAD, T>,
Functor<T>,
Filterable<T> {
    public <MONAD, T> Monad<MONAD, T> withMonad(Object var1);

    default public <T> Monad<MONAD, T> withFunctor(T functor) {
        return this.withMonad(functor);
    }

    @Override
    default public Object getFunctor() {
        return this.unwrap();
    }

    default public <R, NT> Monad<R, NT> streamedMonad() {
        Stream<Integer> stream = Stream.of(Integer.valueOf(1));
        Monad<MONAD, Object> r = this.withMonad(new ComprehenderSelector().selectComprehender(stream).executeflatMap(stream, i -> this.unwrap()));
        return r.flatMap(e -> e);
    }

    @Override
    default public Stream<T> stream() {
        if (this.unwrap() instanceof Stream) {
            return (Stream)this.unwrap();
        }
        if (this.unwrap() instanceof Iterable) {
            return StreamSupport.stream(((Iterable)this.unwrap()).spliterator(), false);
        }
        Stream<Integer> stream = Stream.of(Integer.valueOf(1));
        return (Stream)this.withMonad(new ComprehenderSelector().selectComprehender(stream).executeflatMap(stream, i -> this.unwrap())).unwrap();
    }

    @Override
    default public Monad<Stream<T>, T> cycle(int times) {
        return AsGenericMonad.monad(StreamUtils.cycle(times, AsStreamable.asStreamable(this.stream())));
    }

    @Override
    default public Filterable<T> withFilterable(T filter) {
        return this.withMonad(filter);
    }

    @Override
    default public Object getFilterable() {
        return this.unwrap();
    }

    default public Monad<MONAD, T> filter(Predicate<? super T> fn) {
        return (Monad)Filterable.super.filter(fn);
    }

    default public <R> Monad<MONAD, R> map(Function<? super T, ? extends R> fn) {
        return (Monad)Functor.super.map(fn);
    }

    default public Monad<MONAD, T> peek(Consumer<? super T> c) {
        return (Monad)Functor.super.peek(c);
    }

    @Override
    default public <R> Monad<MONAD, T> bind(Function<? super T, ? extends R> fn) {
        return this.withMonad(new ComprehenderSelector().selectComprehender(this.unwrap()).executeflatMap(this.unwrap(), fn));
    }

    default public <MONAD1, R> Monad<MONAD1, R> liftAndBind(Function<? super T, ?> fn) {
        return this.withMonad(new ComprehenderSelector().selectComprehender(this.unwrap()).liftAndFlatMap(this.unwrap(), fn));
    }

    default public <T1> Monad<T, T1> flatten() {
        return this.flatMap(t -> t);
    }

    default public <T> Optional<T> toOptional() {
        Optional<Integer> stream = Optional.of(1);
        return (Optional)this.withMonad(new ComprehenderSelector().selectComprehender(stream).executeflatMap(stream, i -> this.unwrap())).unwrap();
    }

    default public <R> Monad<Optional<R>, R> flatMapToOptional(Function<? super MONAD, Optional<? extends R>> fn) {
        Optional<Integer> opt = Optional.of(1);
        return AsGenericMonad.monad(opt.flatMap((? super T i) -> (Optional)fn.apply((MONAD)this.unwrap())));
    }

    default public <R> Monad<Stream<R>, R> flatMapToStream(Function<? super MONAD, Stream<? extends R>> fn) {
        Stream<Integer> stream = Stream.of(Integer.valueOf(1));
        Monad<MONAD, Object> r = this.withMonad(new ComprehenderSelector().selectComprehender(stream).executeflatMap(stream, i -> this.unwrap()));
        return r.flatMap(e -> e);
    }

    default public <R> Monad<CompletableFuture<R>, R> flatMapToCompletableFuture(Function<? super MONAD, CompletableFuture<? extends R>> fn) {
        CompletableFuture<Integer> future = CompletableFuture.completedFuture(1);
        return AsGenericMonad.monad(future.thenCompose(i -> (CompletableFuture)fn.apply((MONAD)this.unwrap())));
    }

    @Override
    default public <MONAD, T> MONAD unit(T value) {
        return (MONAD)new ComprehenderSelector().selectComprehender(this.unwrap()).of(value);
    }

    default public <R> Monad<MONAD, R> aggregate(Monad<?, ?> next) {
        Stream<?> concat = StreamUtils.concat(this.stream(), next.stream());
        return this.withMonad(new ComprehenderSelector().selectComprehender(this.unwrap()).of(AsGenericMonad.monad(concat).flatMap(Function.identity()).sequence().collect(Collectors.toList()))).bind(Function.identity());
    }

    default public <MONAD2, NT> Monad<MONAD2, NT> monadMap(Function<? super MONAD, ? extends NT> fn) {
        return AsGenericMonad.asMonad(fn.apply(this.unwrap()));
    }

    default public Optional<MONAD> monadFilter(Predicate<? super MONAD> p) {
        return p.test(this.unwrap()) ? Optional.of(this.unwrap()) : Optional.empty();
    }

    default public <MONAD2, NT, R extends Monad<MONAD2, NT>> R monadFlatMap(Function<? super MONAD, ? extends R> fn) {
        return (R)((Monad)fn.apply(this.unwrap()));
    }

    default public <R extends MONAD, NT> Monad<R, NT> flatMap(Function<? super T, ? extends R> fn) {
        return this.bind(fn);
    }

    @Override
    default public MONAD unwrap() {
        return this.unwrap();
    }

    public <T> AnyM<T> anyM();

    public <T> SequenceM<T> sequence();

    public static <MONAD, T> Monad<MONAD, T> of(Object o) {
        return AsGenericMonad.asMonad(o);
    }
}

