/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.utils;

import com.aol.cyclops.lambda.utils.LazyImmutable;
import com.aol.cyclops.lambda.utils.LazyImmutableSetMoreThanOnceException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ImmutableClosedValueTest {
    @Test
    public void testSetOnce() {
        LazyImmutable value = new LazyImmutable();
        Supplier<Object> s = () -> (Integer)value.setOnce((Object)10).get();
        Assert.assertThat((Object)s.get(), (Matcher)Matchers.is((Object)10));
        Assert.assertThat((Object)value.get(), (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testSetOnce2Attempts() {
        LazyImmutable value = new LazyImmutable();
        Supplier<Object> s = () -> value.setOnce((Object)10);
        value.setOnce((Object)20);
        try {
            s.get();
        }
        catch (LazyImmutableSetMoreThanOnceException lazyImmutableSetMoreThanOnceException) {
            // empty catch block
        }
        Assert.assertThat((Object)value.get(), (Matcher)Matchers.is((Object)20));
    }

    @Test(expected=LazyImmutableSetMoreThanOnceException.class)
    public void testSetOnce2AttemptsException() {
        LazyImmutable value = new LazyImmutable();
        Supplier<Object> s = () -> value.setOnce((Object)10);
        value.setOnce((Object)20);
        s.get();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void setOnceLazy() {
        LazyImmutable value = new LazyImmutable();
        Supplier<Object> s = () -> (Integer)value.computeIfAbsent(() -> 10);
        Assert.assertThat((Object)s.get(), (Matcher)Matchers.is((Object)10));
        Assert.assertThat((Object)value.computeIfAbsent(() -> 20), (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testEqualsFalse() {
        LazyImmutable value = new LazyImmutable();
        value.setOnce((Object)10);
        LazyImmutable value2 = new LazyImmutable();
        value2.setOnce((Object)20);
        Assert.assertThat((Object)value, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)value2)));
    }

    @Test
    public void testEqualsTrue() {
        LazyImmutable value = new LazyImmutable();
        value.setOnce((Object)10);
        LazyImmutable value2 = new LazyImmutable();
        value2.setOnce((Object)10);
        Assert.assertThat((Object)value, (Matcher)Matchers.equalTo((Object)value2));
    }

    @Test
    public void testHashcode() {
        LazyImmutable value = new LazyImmutable();
        value.setOnce((Object)10);
        LazyImmutable value2 = new LazyImmutable();
        value2.setOnce((Object)10);
        Assert.assertThat((Object)value.hashCode(), (Matcher)Matchers.equalTo((Object)value2.hashCode()));
    }

    @Test
    public void testHashcodeFalse() {
        LazyImmutable value = new LazyImmutable();
        value.setOnce((Object)10);
        LazyImmutable value2 = new LazyImmutable();
        value2.setOnce((Object)20);
        Assert.assertThat((Object)value.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)value2.hashCode())));
    }

    @Test
    public void testMapUninitialised() {
        LazyImmutable value = new LazyImmutable();
        LazyImmutable value2 = value.map(i -> i + 10);
        Assert.assertThat((Object)value, (Matcher)Matchers.equalTo((Object)value2));
    }

    @Test
    public void testMap2() {
        LazyImmutable value = new LazyImmutable();
        value.setOnce((Object)10);
        LazyImmutable value2 = value.map(i -> i + 10);
        Assert.assertThat((Object)value2.get(), (Matcher)Matchers.equalTo((Object)20));
    }

    @Test
    public void testFlatMapUninitialised() {
        LazyImmutable value = new LazyImmutable();
        LazyImmutable value2 = value.flatMap(i -> LazyImmutable.of((Object)(i + 10)));
        Assert.assertThat((Object)value, (Matcher)Matchers.equalTo((Object)value2));
    }

    @Test
    public void testFlatMap2() {
        LazyImmutable value = new LazyImmutable();
        value.setOnce((Object)10);
        LazyImmutable value2 = value.flatMap(i -> LazyImmutable.of((Object)(i + 10)));
        Assert.assertThat((Object)value2.get(), (Matcher)Matchers.equalTo((Object)20));
    }

    @Test
    public void testLeftIdentity() {
        int a = 10;
        Function<Integer, LazyImmutable> f = i -> LazyImmutable.of((Object)(i + 10));
        Assert.assertThat((Object)LazyImmutable.of((Object)a).flatMap(f), (Matcher)Matchers.equalTo((Object)f.apply(10)));
    }

    @Test
    public void testRightIdentity() {
        int a = 10;
        LazyImmutable m = LazyImmutable.of((Object)a);
        Assert.assertThat((Object)m.flatMap(LazyImmutable::of), (Matcher)Matchers.equalTo((Object)m));
    }

    @Test
    public void associativity() {
        int a = 10;
        LazyImmutable m = LazyImmutable.of((Object)a);
        Function<Integer, LazyImmutable> f = i -> LazyImmutable.of((Object)(i + 10));
        Function<Integer, LazyImmutable> g = i -> LazyImmutable.of((Object)(i * 10));
        Assert.assertThat((Object)m.flatMap(f).flatMap(g), (Matcher)Matchers.equalTo((Object)m.flatMap(x -> ((LazyImmutable)f.apply((Integer)x)).flatMap(g))));
    }

    @Test
    public void testRightIdentityUninitialised() {
        LazyImmutable m = new LazyImmutable();
        Assert.assertThat((Object)m.flatMap(LazyImmutable::of), (Matcher)Matchers.equalTo((Object)m));
    }

    @Test
    public void associativityUninitialised() {
        int a = 10;
        LazyImmutable m = new LazyImmutable();
        Function<Integer, LazyImmutable> f = i -> LazyImmutable.of((Object)(i + 10));
        Function<Integer, LazyImmutable> g = i -> LazyImmutable.of((Object)(i * 10));
        Assert.assertThat((Object)m.flatMap(f).flatMap(g), (Matcher)Matchers.equalTo((Object)m.flatMap(x -> ((LazyImmutable)f.apply((Integer)x)).flatMap(g))));
    }
}

