/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.utils;

import com.aol.cyclops.lambda.utils.Lambda;
import com.aol.cyclops.lambda.utils.Mutable;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class MutableTest {
    @Test
    public void testMutate() {
        Mutable num = Mutable.of((Object)20);
        Stream.of(1, 2, 3, 4).map(i -> i * 10).peek(i -> num.mutate(n2 -> n2 + i)).forEach(System.out::println);
        Assert.assertThat((Object)num.get(), (Matcher)Matchers.is((Object)120));
    }

    @Test
    public void inClosure() {
        Mutable myInt = new Mutable((Object)0);
        ((Function)Lambda.\u03bb2(i -> j -> myInt.set((Object)(i * j))).apply(10)).apply(20);
        Assert.assertThat((Object)myInt.get(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void inClosure2() {
        Mutable myInt = new Mutable((Object)0);
        BiFunction<Integer, Integer, Mutable> fn = (i, j) -> myInt.set((Object)(i * j));
        fn.apply(10, 20);
        Assert.assertThat((Object)myInt.get(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void testSet() {
        Assert.assertThat((Object)new Mutable().set((Object)"hello").get(), (Matcher)Matchers.is((Object)"hello"));
    }

    @Test
    public void testClosedVar() {
        Assert.assertThat((Object)new Mutable((Object)10).get(), (Matcher)Matchers.equalTo((Object)10));
    }

    @Test
    public void testClosedVarEquals() {
        Assert.assertThat((Object)new Mutable((Object)10), (Matcher)Matchers.equalTo((Object)new Mutable((Object)10)));
    }

    @Test
    public void testClosedVarEqualsFalse() {
        Assert.assertThat((Object)new Mutable((Object)10), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)new Mutable((Object)20))));
    }

    @Test
    public void testClosedVarHashCode() {
        Assert.assertThat((Object)new Mutable((Object)10).hashCode(), (Matcher)Matchers.equalTo((Object)new Mutable((Object)10).hashCode()));
    }

    @Test
    public void testClosedVarHashCodeFalse() {
        Assert.assertThat((Object)new Mutable((Object)10).hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)new Mutable((Object)20).hashCode())));
    }
}

