/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads;

import com.aol.cyclops.lambda.api.AsGenericMonad;
import com.aol.cyclops.lambda.api.AsSimplexMonad;
import com.aol.cyclops.lambda.api.Monoid;
import com.aol.cyclops.lambda.api.Reducers;
import com.aol.cyclops.lambda.api.Streamable;
import com.aol.cyclops.lambda.monads.Monad;
import com.aol.cyclops.lambda.monads.MonadWrapper;
import com.aol.cyclops.lambda.monads.Simplex;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class MonadTest {
    int count;

    @Test
    public void test() {
        List list = ((Stream)MonadWrapper.of(Stream.of(Arrays.asList(1, 3))).flatMap(Collection::stream).unwrap()).map(i -> i * 2).peek(System.out::println).collect(Collectors.toList());
        Assert.assertThat(Arrays.asList(2, 6), (Matcher)Matchers.equalTo(list));
    }

    @Test
    public void testMixed() {
        List list = MonadWrapper.of(Stream.of(Arrays.asList(1, 3), null)).bind(Optional::ofNullable).map(i -> i.size()).peek(System.out::println).toList();
        Assert.assertThat(Arrays.asList(2), (Matcher)Matchers.equalTo((Object)list));
    }

    @Test
    public void testCycleWhile() {
        this.count = 0;
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2, 2)).cycleWhile(next -> this.count++ < 6).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2, 1, 2, 2)));
    }

    @Test
    public void testCycle() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2, 2)).cycle(3).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2, 1, 2, 2, 1, 2, 2)));
    }

    @Test
    public void testCycleReduce() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2, 2)).cycle(Reducers.toCountInt(), 3).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(3, 3, 3)));
    }

    @Test
    public void testCycleMonad() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2)).cycle(Optional.class, 2).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(Optional.of(1), Optional.of(2), Optional.of(1), Optional.of(2))));
    }

    @Test
    public void testJoin() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2, 2)).map(b -> Stream.of(b)).flatten().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2)));
    }

    @Test
    public void testJoin2() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(Arrays.asList(1, 2), Arrays.asList(2))).flatten().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2)));
    }

    @Test
    public void testToSet() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2, 2)).toSet().size(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void testToList() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2, 3)).toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testCollect() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2, 3)).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testToListFlatten() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2, 3, null)).bind(Optional::ofNullable).toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testToListOptional() {
        Assert.assertThat((Object)MonadWrapper.of(Optional.of(1)).toList(), (Matcher)Matchers.equalTo(Arrays.asList(1)));
    }

    @Test
    public void testFold() {
        Supplier<Monad> s = () -> AsGenericMonad.asMonad(Stream.of("a", "b", "c"));
        Assert.assertThat((Object)"cba", (Matcher)Matchers.equalTo((Object)s.get().foldRight(Reducers.toString((String)""))));
        Assert.assertThat((Object)"abc", (Matcher)Matchers.equalTo((Object)s.get().foldLeft(Reducers.toString((String)""))));
        Assert.assertThat((Object)3, (Matcher)Matchers.equalTo((Object)s.get().map(i -> "" + i.length()).foldRightMapToType(Reducers.toCountInt())));
        Assert.assertThat((Object)3, (Matcher)Matchers.equalTo((Object)s.get().map(i -> "" + i.length()).foldLeftMapToType(Reducers.toCountInt())));
    }

    @Test
    public void testLift() {
        List result = AsGenericMonad.asMonad(Stream.of("input.file")).map(this.getClass().getClassLoader()::getResource).peek(System.out::println).map(URL::getFile).liftAndBind(File::new).toList();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList("hello", "world")));
    }

    @Test
    public void testSequenceNative() {
        List list = IntStream.range(0, 100).boxed().collect(Collectors.toList());
        List futures = list.stream().map(x -> CompletableFuture.supplyAsync(() -> x)).collect(Collectors.toList());
        CompletableFuture futureList = (CompletableFuture)Monad.sequenceNative(CompletableFuture.class, futures);
        List collected = (List)futureList.join();
        Assert.assertThat((Object)collected.size(), (Matcher)Matchers.equalTo((Object)list.size()));
        for (Integer next : list) {
            Assert.assertThat(list.get(next), (Matcher)Matchers.equalTo(collected.get(next)));
        }
    }

    @Test
    public void testTraverseNative() {
        List list = IntStream.range(0, 100).boxed().collect(Collectors.toList());
        List futures = list.stream().map(x -> CompletableFuture.supplyAsync(() -> x)).collect(Collectors.toList());
        CompletableFuture futureList = (CompletableFuture)Monad.traverseNative(CompletableFuture.class, futures, i -> "hello" + i);
        List collected = (List)futureList.join();
        Assert.assertThat((Object)collected.size(), (Matcher)Matchers.equalTo((Object)list.size()));
        for (Integer next : list) {
            Assert.assertThat((Object)("hello" + list.get(next)), (Matcher)Matchers.equalTo(collected.get(next)));
        }
    }

    @Test
    public void testSequence() {
        List list = IntStream.range(0, 100).boxed().collect(Collectors.toList());
        List futures = list.stream().map(x -> CompletableFuture.supplyAsync(() -> x)).collect(Collectors.toList());
        Simplex futureList = Monad.sequence(CompletableFuture.class, futures).simplex();
        List collected = (List)((CompletableFuture)futureList.monad()).join();
        Assert.assertThat((Object)collected.size(), (Matcher)Matchers.equalTo((Object)list.size()));
        for (Integer next : list) {
            Assert.assertThat(list.get(next), (Matcher)Matchers.equalTo(collected.get(next)));
        }
    }

    @Test
    public void testTraverse() {
        List list = IntStream.range(0, 100).boxed().collect(Collectors.toList());
        List futures = list.stream().map(x -> CompletableFuture.supplyAsync(() -> x)).collect(Collectors.toList());
        Simplex futureList = Monad.traverse(CompletableFuture.class, futures, i -> "hello" + i).simplex();
        List collected = (List)((CompletableFuture)futureList.monad()).join();
        Assert.assertThat((Object)collected.size(), (Matcher)Matchers.equalTo((Object)list.size()));
        for (Integer next : list) {
            Assert.assertThat((Object)("hello" + list.get(next)), (Matcher)Matchers.equalTo(collected.get(next)));
        }
    }

    @Test
    public void zipOptional() {
        Stream zipped = AsGenericMonad.asMonad(Stream.of(1, 2, 3)).zip(AsGenericMonad.asMonad(Optional.of(2)), (a, b) -> Arrays.asList(a, b)).toStream();
        List zip = (List)zipped.collect(Collectors.toList()).get(0);
        Assert.assertThat(zip.get(0), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat(zip.get(1), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void zipStream() {
        Stream zipped = AsGenericMonad.monad(Stream.of(1, 2, 3)).zip(Stream.of(2, 3, 4), (a, b) -> Arrays.asList(a, b)).stream();
        List zip = (List)zipped.collect(Collectors.toList()).get(1);
        Assert.assertThat(zip.get(0), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat(zip.get(1), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void sliding() {
        List list = (List)AsGenericMonad.monad(Stream.of(1, 2, 3, 4, 5, 6)).sliding(2).collect(Collectors.toList());
        Assert.assertThat(list.get(0), (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2}));
        Assert.assertThat(list.get(1), (Matcher)Matchers.hasItems((Object[])new Integer[]{2, 3}));
    }

    @Test
    public void grouped() {
        List list = (List)AsGenericMonad.monad(Stream.of(1, 2, 3, 4, 5, 6)).grouped(3).collect(Collectors.toList());
        Assert.assertThat(list.get(0), (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat(list.get(1), (Matcher)Matchers.hasItems((Object[])new Integer[]{4, 5, 6}));
    }

    @Test
    public void groupedOptional() {
        List list = (List)AsGenericMonad.monad(Optional.of(Arrays.asList(1, 2, 3, 4, 5, 6))).streamedMonad().grouped(3).collect(Collectors.toList());
        Assert.assertThat(list.get(0), (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat(list.get(1), (Matcher)Matchers.hasItems((Object[])new Integer[]{4, 5, 6}));
    }

    @Test
    public void startsWith() {
        Assert.assertTrue((boolean)AsGenericMonad.monad(Stream.of(1, 2, 3, 4)).startsWith(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void startsWithIterator() {
        Assert.assertTrue((boolean)AsGenericMonad.monad(Stream.of(1, 2, 3, 4)).startsWith(Arrays.asList(1, 2, 3).iterator()));
    }

    @Test
    public void distinctOptional() {
        List list = (List)AsGenericMonad.monad(Optional.of(Arrays.asList(1, 2, 2, 2, 5, 6))).streamedMonad().distinct().collect(Collectors.toList());
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.equalTo((Object)4));
    }

    @Test
    public void scanLeft() {
        Assert.assertEquals(Arrays.asList("", "a", "ab", "abc"), (Object)AsGenericMonad.monad(Stream.of("a", "b", "c")).scanLeft(Reducers.toString((String)"")).toList());
    }

    @Test
    public void testCollectors() {
        List result = AsGenericMonad.monad(Stream.of(1, 2, 3)).collect(Stream.of(Collectors.toList(), Collectors.summingInt(Integer::intValue), Collectors.averagingInt(Integer::intValue)));
        Assert.assertThat(result.get(0), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
        Assert.assertThat(result.get(1), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat(result.get(2), (Matcher)Matchers.equalTo((Object)2.0));
    }

    @Test
    public void reducer1() {
        Monoid sum = Monoid.of((Object)0, (a, b) -> a + b);
        Monoid mult = Monoid.of((Object)1, (a, b) -> a * b);
        List result = AsGenericMonad.monad(Stream.of(1, 2, 3, 4)).reduce(Arrays.asList(sum, mult).stream());
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(10, 24)));
    }

    @Test
    public void reducer2() {
        Monoid sum = Monoid.of((Object)0, (a, b) -> a + b);
        Monoid mult = Monoid.of((Object)1, (a, b) -> a * b);
        List result = AsGenericMonad.monad(Optional.of(Stream.of(1, 2, 3, 4))).streamedMonad().reduce(Arrays.asList(sum, mult));
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(10, 24)));
    }

    @Test
    public void reducer3() {
        Monoid sum = Monoid.of((Object)0, (a, b) -> a + b);
        Monoid mult = Monoid.of((Object)1, (a, b) -> a * b);
        List result = AsGenericMonad.monad(Optional.of(Stream.of(new Object[0]))).streamedMonad().reduce(Arrays.asList(sum, mult));
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(0, 1)));
    }

    @Test
    public void reducer4() {
        Monoid sum = Monoid.of((Object)0, (a, b) -> a + b);
        Monoid mult = Monoid.of((Object)1, (a, b) -> a * b);
        List result = AsGenericMonad.monad(Optional.empty()).streamedMonad().reduce(Arrays.asList(sum, mult));
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(0, 1)));
    }

    @Test
    public void aggregate() {
        List result = AsGenericMonad.monad(Stream.of(1, 2, 3, 4)).aggregate(AsGenericMonad.monad(Optional.of(5))).toList();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 4, 5)));
    }

    @Test
    public void aggregate2() {
        List result = AsGenericMonad.monad(Optional.of(Arrays.asList(1, 2, 3, 4))).aggregate(AsGenericMonad.monad(CompletableFuture.completedFuture(5))).toList();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 4, 5)));
    }

    @Test
    public void aggregate3() {
        List result = AsGenericMonad.monad(Optional.of(Arrays.asList(1, 2, 3, 4))).aggregate(AsGenericMonad.monad(CompletableFuture.supplyAsync(() -> Arrays.asList(5, 6)))).toList();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 4, 5, 6)));
    }

    @Test
    public void testApplyM() {
        Simplex applied = AsGenericMonad.monad(Stream.of(1, 2, 3)).applyM(AsGenericMonad.monad((Streamable)Streamable.of((Object[])new Function[]{a -> a + 1, a -> a * 2}))).simplex();
        Assert.assertThat((Object)applied.toList(), (Matcher)Matchers.equalTo(Arrays.asList(2, 2, 3, 4, 4, 6)));
    }

    @Test
    public void testApplyMOptional() {
        Simplex applied = AsGenericMonad.monad(Optional.of(2)).applyM(AsGenericMonad.monad(Optional.of(a -> a + 1))).simplex();
        Assert.assertThat((Object)applied.toList(), (Matcher)Matchers.equalTo(Arrays.asList(3)));
    }

    @Test
    public void testApplyMOptionalEmpty() {
        Simplex applied = AsGenericMonad.monad(Optional.of(2)).applyM(AsGenericMonad.monad(Optional.empty())).simplex();
        Assert.assertThat((Object)applied.toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void testApplyMEmptyOptional() {
        Simplex empty = AsGenericMonad.monad(Optional.empty()).simplex();
        Simplex applied = empty.applyM(AsGenericMonad.monad(Optional.of(a -> a + 1))).simplex();
        Assert.assertThat((Object)applied.toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void testFilterM() {
        Simplex applied = AsGenericMonad.monad(Stream.of(1, 2, 3)).filterM(AsGenericMonad.monad((Streamable)Streamable.of((Object[])new Predicate[]{a -> a > 5, a -> a < 3}))).simplex();
        Assert.assertThat((Object)applied.map(s -> s.collect(Collectors.toList())).toList(), (Matcher)Matchers.equalTo(Arrays.asList(Arrays.asList(1), Arrays.asList(2), Arrays.asList(new Object[0]))));
    }

    @Test
    public void testFilterMOptional() {
        Simplex applied = AsGenericMonad.monad(Optional.of(2)).filterM(AsGenericMonad.monad((Streamable)Streamable.of((Object[])new Predicate[]{a -> a > 5, a -> a < 3}))).simplex();
        Assert.assertThat((Object)applied.toList(), (Matcher)Matchers.equalTo(Arrays.asList(2)));
    }

    @Test
    public void testReplicateM() {
        Simplex applied = AsGenericMonad.monad(Optional.of(2)).replicateM(5).simplex();
        Assert.assertThat((Object)applied.unwrap(), (Matcher)Matchers.equalTo(Optional.of(Arrays.asList(2, 2, 2, 2, 2))));
    }

    @Test
    public void testReplicateMStream() {
        Simplex applied = AsGenericMonad.monad(Stream.of(2, 3, 4)).replicateM(5).simplex();
        Assert.assertThat((Object)applied.toList(), (Matcher)Matchers.equalTo(Arrays.asList(2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4)));
    }

    @Test
    public void testSorted() {
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(4, 3, 6, 7)).sorted().toList(), (Matcher)Matchers.equalTo(Arrays.asList(3, 4, 6, 7)));
    }

    @Test
    public void testSortedCompartor() {
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(4, 3, 6, 7)).sorted((a, b) -> b - a).toList(), (Matcher)Matchers.equalTo(Arrays.asList(7, 6, 4, 3)));
    }

    @Test
    public void testSkip() {
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(4, 3, 6, 7)).skip(2).toList(), (Matcher)Matchers.equalTo(Arrays.asList(6, 7)));
    }

    @Test
    public void testSkipUntil() {
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(4, 3, 6, 7)).skipUntil(i -> i == 6).toList(), (Matcher)Matchers.equalTo(Arrays.asList(6, 7)));
    }

    @Test
    public void testSkipWhile() {
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(4, 3, 6, 7)).sorted().skipWhile(i -> i < 6).toList(), (Matcher)Matchers.equalTo(Arrays.asList(6, 7)));
    }

    @Test
    public void testLimit() {
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(4, 3, 6, 7)).limit(2).toList(), (Matcher)Matchers.equalTo(Arrays.asList(4, 3)));
    }

    @Test
    public void testLimitUntil() {
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(4, 3, 6, 7)).limitUntil(i -> i == 6).toList(), (Matcher)Matchers.equalTo(Arrays.asList(4, 3)));
    }

    @Test
    public void testLimitWhile() {
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(4, 3, 6, 7)).sorted().limitWhile(i -> i < 6).toList(), (Matcher)Matchers.equalTo(Arrays.asList(3, 4)));
    }

    @Test
    public void testLiftM() {
        Function lifted = Monad.liftMonad(a -> a + 3);
        Monad result = (Monad)lifted.apply(AsGenericMonad.monad(Optional.of(3)));
        Assert.assertThat(((Optional)result.unwrap()).get(), (Matcher)Matchers.equalTo((Object)6));
    }

    @Test
    public void testLiftMSimplex() {
        Function lifted = Monad.liftM(a -> a + 3);
        Simplex result = (Simplex)lifted.apply(AsSimplexMonad.simplex(Optional.of(3)));
        Assert.assertThat(((Optional)result.monad()).get(), (Matcher)Matchers.equalTo((Object)6));
    }

    @Test
    public void testLiftMNative() {
        Function lifted = Monad.liftMNative(a -> a + 3);
        Optional result = (Optional)lifted.apply(Optional.of(3));
        Assert.assertThat(result.get(), (Matcher)Matchers.equalTo((Object)6));
    }

    @Test
    public void testReduceM() {
        Monoid optionalAdd = Monoid.of(Optional.of(0), (a, b) -> Optional.of((Integer)a.get() + (Integer)b.get()));
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(2, 8, 3, 1)).reduceM(optionalAdd).unwrap(), (Matcher)Matchers.equalTo(Optional.of(14)));
    }
}

