/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.utils;

import com.aol.cyclops.lambda.api.AsStreamable;
import com.aol.cyclops.lambda.api.Monoid;
import com.aol.cyclops.lambda.api.Streamable;
import com.aol.cyclops.streams.StreamUtils;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class StreamUtilsTest
implements StreamUtils {
    @Test
    public void testReverse() {
        Assert.assertThat(StreamUtils.reverse(Stream.of(1, 2, 3)).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(3, 2, 1)));
    }

    @Test
    public void testReversedStream() {
        Assert.assertThat(StreamUtils.reversedStream(Arrays.asList(1, 2, 3)).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(3, 2, 1)));
    }

    @Test
    public void testCycleStreamOfU() {
        Assert.assertThat(StreamUtils.cycle(Stream.of(1, 2, 3)).limit(6L).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 1, 2, 3)));
    }

    @Test
    public void testCycleStreamableOfU() {
        Assert.assertThat(StreamUtils.cycle((Streamable)AsStreamable.asStreamable(Stream.of(1, 2, 3))).limit(6L).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 1, 2, 3)));
    }

    @Test
    public void testStreamIterableOfU() {
        Assert.assertThat(StreamUtils.stream(Arrays.asList(1, 2, 3)).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testStreamIteratorOfU() {
        Assert.assertThat(StreamUtils.stream(Arrays.asList(1, 2, 3).iterator()).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testStreamMapOfKV() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hello", "world");
        Assert.assertThat(StreamUtils.stream(map).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(new AbstractMap.SimpleEntry<String, String>("hello", "world"))));
    }

    @Test
    public void reducer() {
        Monoid concat = Monoid.of((Object)"", (a, b) -> a + b);
        Monoid join = Monoid.of((Object)"", (a, b) -> a + "," + b);
        Assert.assertThat((Object)StreamUtils.reduce(Stream.of("hello", "world", "woo!"), Stream.of(concat, join)), (Matcher)Matchers.equalTo(Arrays.asList("helloworldwoo!", ",hello,world,woo!")));
    }

    @Test
    public void reducer2() {
        Monoid sum = Monoid.of((Object)0, (a, b) -> a + b);
        Monoid mult = Monoid.of((Object)1, (a, b) -> a * b);
        List result = StreamUtils.reduce(Stream.of(1, 2, 3, 4), Arrays.asList(sum, mult));
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(10, 24)));
    }

    @Test
    public void testCollectors() {
        List result = StreamUtils.collect(Stream.of(1, 2, 3), Arrays.asList(Collectors.toList(), Collectors.summingInt(Integer::intValue), Collectors.averagingInt(Integer::intValue)));
        Assert.assertThat(result.get(0), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
        Assert.assertThat(result.get(1), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat(result.get(2), (Matcher)Matchers.equalTo((Object)2.0));
    }
}

