/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.comprehensions.converters;

import com.aol.cyclops.comprehensions.converters.StreamUpscaler;
import com.aol.cyclops.lambda.api.MonadicConverter;
import com.aol.cyclops.lambda.api.Reducers;
import com.aol.cyclops.streams.StreamUtils;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.pcollections.PStack;

public class MonadicConverters {
    private final StreamUpscaler upscaler = MonadicConverters.getConverter();
    private static final PStack<MonadicConverter> converters;

    private static StreamUpscaler getConverter() {
        try {
            Class.forName("org.jooq.lambda.Seq");
            return stream -> Seq.seq((Stream)stream);
        }
        catch (ClassNotFoundException e) {
            return stream -> stream;
        }
    }

    public Object convertToMonadicForm(Object o) {
        return this.upscaler.upscaleIfStream(converters.stream().filter(t -> t.accept(o)).map(m -> m.convertToMonadicForm(o)).findFirst().orElse(o));
    }

    public static PStack<MonadicConverter> getConverters() {
        return converters;
    }

    static {
        ServiceLoader<MonadicConverter> loader = ServiceLoader.load(MonadicConverter.class);
        converters = Reducers.toPStack().mapReduce(StreamUtils.stream(loader.iterator()).sorted((a, b) -> b.priority() - a.priority()));
    }
}

