/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exchange.resource.assets.search;

import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.mule.exchange.exceptions.ExchangexapiException;
import org.mule.exchange.resource.assets.search.model.SearchGETQueryParam;
import org.mule.exchange.resource.assets.search.model.SingleAsset;
import org.mule.exchange.responses.ExchangexapiResponse;

public class Search {
    private String _baseUrl;
    private Client _client;

    public Search() {
        this._baseUrl = null;
        this._client = null;
    }

    public Search(String baseUrl, Client _client) {
        this._baseUrl = baseUrl + "/search";
        this._client = _client;
    }

    protected Client getClient() {
        return this._client;
    }

    private String getBaseUri() {
        return this._baseUrl;
    }

    public ExchangexapiResponse<List<SingleAsset>> get(SearchGETQueryParam queryParameters, String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        if (queryParameters.getOrganizationId() != null) {
            target = target.queryParam("organizationId", new Object[]{queryParameters.getOrganizationId()});
        }
        if (queryParameters.getSearch() != null) {
            target = target.queryParam("search", new Object[]{queryParameters.getSearch()});
        }
        if (queryParameters.getTypes() != null) {
            target = target.queryParam("types", new Object[]{queryParameters.getTypes()});
        }
        if (queryParameters.getOffset() != null) {
            target = target.queryParam("offset", new Object[]{queryParameters.getOffset()});
        }
        if (queryParameters.getDomain() != null) {
            target = target.queryParam("domain", new Object[]{queryParameters.getDomain()});
        }
        if (queryParameters.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{queryParameters.getLimit()});
        }
        if (queryParameters.getMinMuleVersion() != null) {
            target = target.queryParam("minMuleVersion", new Object[]{queryParameters.getMinMuleVersion()});
        }
        if (queryParameters.getSort() != null) {
            target = target.queryParam("sort", new Object[]{queryParameters.getSort()});
        }
        if (queryParameters.getAscending() != null) {
            target = target.queryParam("ascending", new Object[]{queryParameters.getAscending()});
        }
        if (queryParameters.getMasterOrganizationId() != null) {
            target = target.queryParam("masterOrganizationId", new Object[]{queryParameters.getMasterOrganizationId()});
        }
        if (queryParameters.getSharedWithMe() != null) {
            target = target.queryParam("sharedWithMe", new Object[]{queryParameters.getSharedWithMe()});
        }
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("GET");
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(response.readEntity((GenericType)new GenericType<List<SingleAsset>>(){}), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }
}

