/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exchange.resource.assets;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.mule.exchange.exceptions.ExchangexapiException;
import org.mule.exchange.resource.assets.groupId.GroupId;
import org.mule.exchange.resource.assets.model.AssetsPOSTBody;
import org.mule.exchange.resource.assets.model.AssetsPOSTHeader;
import org.mule.exchange.resource.assets.search.Search;
import org.mule.exchange.responses.ExchangexapiResponse;

public class Assets {
    private String _baseUrl;
    private Client _client;
    public final Search search;

    public Assets() {
        this._baseUrl = null;
        this._client = null;
        this.search = null;
    }

    public Assets(String baseUrl, Client _client) {
        this._baseUrl = baseUrl + "/assets";
        this._client = _client;
        this.search = new Search(this.getBaseUri(), this.getClient());
    }

    protected Client getClient() {
        return this._client;
    }

    private String getBaseUri() {
        return this._baseUrl;
    }

    public ExchangexapiResponse<Void> post(AssetsPOSTBody body, AssetsPOSTHeader headers, String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (headers.getXAllowedApiSpecFormats() != null) {
            invocationBuilder.header("x-allowed-api-spec-formats", (Object)headers.getXAllowedApiSpecFormats());
        }
        if (headers.getContentType() != null) {
            invocationBuilder.header("Content-Type", (Object)headers.getContentType());
        }
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        FormDataMultiPart multiPart = new FormDataMultiPart();
        Response response = invocationBuilder.method("POST", Entity.entity((Object)multiPart, (MediaType)multiPart.getMediaType()));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(null, (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }

    public GroupId groupId(String groupId) {
        return new GroupId(this.getBaseUri(), this.getClient(), groupId);
    }
}

