/*
 * Decompiled with CFR 0.152.
 */
package com.antonzorin.dottedprogressbar;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import com.antonzorin.dottedprogressbar.R;

public class DottedProgressBar
extends View {
    private Paint mDotsPaint = new Paint(1);
    private Paint mArrowsPaint = new Paint(1);
    private Paint mCenterPaint = new Paint(1);
    private int mIterator;
    private float mCenter;
    private float mTimeInterval;
    private float mDeltaSize;
    private boolean isClockWiseDots;
    private boolean isCounterClockWiseArrows;
    private boolean hideArrows;
    private int mDotsCount;
    private int mMaxDotSizePercent;
    private int mMinDotSizePercent;
    private int mArrowWidthPercent;
    private int mArrowHourPaddingPercent;
    private int mArrowMinutePaddingPercent;
    private float mRotationSpeed;
    private float mMaxCircleSize;
    private float mSpaceBetweenDots;
    private float mMinuteArrowTopPadding;
    private float mHourArrowTopPadding;
    private float mArrowWidth;
    private float mHourArrowSpeed;
    private float mMinuteArrowSpeed;
    private float mMinuteArrowAngle;
    private float mHourArrowAngle;

    public DottedProgressBar(Context context) {
        super(context);
        this.init(context, null);
    }

    public DottedProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public DottedProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public int getBaseColor() {
        return this.mDotsPaint.getColor();
    }

    public void setBaseColor(int color2) {
        this.mDotsPaint.setColor(color2);
        this.invalidate();
    }

    public int getArrowsColor() {
        return this.mArrowsPaint.getColor();
    }

    public void setArrowsColor(int color2) {
        this.mArrowsPaint.setColor(color2);
        this.invalidate();
    }

    public int getCenterColor() {
        return this.mCenterPaint.getColor();
    }

    public void setCenterColor(int color2) {
        this.mCenterPaint.setColor(color2);
        this.invalidate();
    }

    public boolean isClockWiseDots() {
        return this.isClockWiseDots;
    }

    public void setClockWiseDots(boolean clockWiseDots) {
        this.isClockWiseDots = clockWiseDots;
        this.invalidate();
    }

    public boolean isCounterClockWiseArrows() {
        return this.isCounterClockWiseArrows;
    }

    public void setCounterClockWiseArrows(boolean counterClockWiseArrows) {
        this.isCounterClockWiseArrows = counterClockWiseArrows;
        this.invalidate();
    }

    public boolean isHideArrows() {
        return this.hideArrows;
    }

    public void setHideArrows(boolean hideArrows) {
        this.hideArrows = hideArrows;
        this.invalidate();
    }

    public int getMaxDotSizePercent() {
        return this.mMaxDotSizePercent;
    }

    public void setMaxDotSizePercent(int maxDotSizePercent) {
        this.mMaxDotSizePercent = maxDotSizePercent;
        this.invalidate();
    }

    public int getMinDotSizePercent() {
        return this.mMinDotSizePercent;
    }

    public void setMinDotSizePercent(int minDotSizePercent) {
        this.mMinDotSizePercent = minDotSizePercent;
        this.invalidate();
    }

    public int getArrowWidthPercent() {
        return this.mArrowWidthPercent;
    }

    public void setArrowWidthPercent(int arrowWidthPercent) {
        this.mArrowWidthPercent = arrowWidthPercent;
        this.invalidate();
    }

    public int getArrowHourPaddingPercent() {
        return this.mArrowHourPaddingPercent;
    }

    public void setArrowHourPaddingPercent(int arrowHourPaddingPercent) {
        this.mArrowHourPaddingPercent = arrowHourPaddingPercent;
        this.invalidate();
    }

    public int getArrowMinutePaddingPercent() {
        return this.mArrowMinutePaddingPercent;
    }

    public void setArrowMinutePaddingPercent(int arrowMinutePaddingPercent) {
        this.mArrowMinutePaddingPercent = arrowMinutePaddingPercent;
        this.invalidate();
    }

    public float getRotationSpeed() {
        return this.mRotationSpeed;
    }

    public void setRotationSpeed(float rotationSpeed) {
        this.mRotationSpeed = rotationSpeed;
        this.invalidate();
    }

    public float getMaxCircleSize() {
        return this.mMaxCircleSize;
    }

    public void setMaxCircleSize(float maxCircleSize) {
        this.mMaxCircleSize = maxCircleSize;
        this.invalidate();
    }

    public float getSpaceBetweenDots() {
        return this.mSpaceBetweenDots;
    }

    public void setSpaceBetweenDots(float spaceBetweenDots) {
        this.mSpaceBetweenDots = spaceBetweenDots;
        this.invalidate();
    }

    public float getMinuteArrowTopPadding() {
        return this.mMinuteArrowTopPadding;
    }

    public void setMinuteArrowTopPadding(float minuteArrowTopPadding) {
        this.mMinuteArrowTopPadding = minuteArrowTopPadding;
        this.invalidate();
    }

    public float getHourArrowTopPadding() {
        return this.mHourArrowTopPadding;
    }

    public void setHourArrowTopPadding(float hourArrowTopPadding) {
        this.mHourArrowTopPadding = hourArrowTopPadding;
        this.invalidate();
    }

    public float getArrowWidth() {
        return this.mArrowWidth;
    }

    public void setArrowWidth(float arrowWidth) {
        this.mArrowWidth = arrowWidth;
        this.invalidate();
    }

    public float getHourArrowSpeed() {
        return this.mHourArrowSpeed;
    }

    public void setHourArrowSpeed(float hourArrowSpeed) {
        this.mHourArrowSpeed = hourArrowSpeed;
        this.invalidate();
    }

    public float getMinuteArrowSpeed() {
        return this.mMinuteArrowSpeed;
    }

    public void setMinuteArrowSpeed(float minuteArrowSpeed) {
        this.mMinuteArrowSpeed = minuteArrowSpeed;
        this.invalidate();
    }

    public float getMinuteArrowAngle() {
        return this.mMinuteArrowAngle;
    }

    public void setMinuteArrowAngle(float minuteArrowAngle) {
        this.mMinuteArrowAngle = minuteArrowAngle;
        this.invalidate();
    }

    public float getHourArrowAngle() {
        return this.mHourArrowAngle;
    }

    public void setHourArrowAngle(float hourArrowAngle) {
        this.mHourArrowAngle = hourArrowAngle;
        this.invalidate();
    }

    void init(Context context, AttributeSet attrs) {
        Resources r = this.getResources();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DottedProgressBar);
        int defaultColor = r.getColor(R.color.defaultColor);
        int defaultDotsCount = r.getInteger(R.integer.defaultDotsCount);
        int defaultMaxDotSize = r.getInteger(R.integer.defaultMaxDotSize);
        int defaultMinDotSize = r.getInteger(R.integer.defaultMinDotSize);
        int defaultArrowWidthSize = r.getInteger(R.integer.defaultArrowWidthSize);
        int defaultArrowHourPadding = r.getInteger(R.integer.defaultHourArrowPadding);
        int defaultArrowMinutePadding = r.getInteger(R.integer.defaultMinuteArrowPadding);
        int defaultHourArrowSpeed = r.getInteger(R.integer.defaultHourArrowSpeed);
        int defaultMinuteArrowSpeed = r.getInteger(R.integer.defaultMinuteArrowSpeed);
        int defaultRotationSpeed = r.getInteger(R.integer.defaultRotationSpeed);
        this.mDotsPaint.setColor(a.getColor(R.styleable.DottedProgressBar_dpBaseColor, defaultColor));
        this.mCenterPaint.setColor(a.getColor(R.styleable.DottedProgressBar_dpCenterColor, a.getColor(R.styleable.DottedProgressBar_dpBaseColor, defaultColor)));
        this.mArrowsPaint.setColor(a.getColor(R.styleable.DottedProgressBar_dpArrowsColor, a.getColor(R.styleable.DottedProgressBar_dpBaseColor, defaultColor)));
        this.isClockWiseDots = a.getBoolean(R.styleable.DottedProgressBar_dpClockwiseDots, false);
        this.isCounterClockWiseArrows = a.getBoolean(R.styleable.DottedProgressBar_dpCounterClockwiseArrows, false);
        this.hideArrows = a.getBoolean(R.styleable.DottedProgressBar_dpHideArrows, false);
        this.mDotsCount = a.getInteger(R.styleable.DottedProgressBar_dotsCount, defaultDotsCount);
        this.mMaxDotSizePercent = a.getInteger(R.styleable.DottedProgressBar_dpMaxDotsSizePercent, defaultMaxDotSize);
        this.mMinDotSizePercent = a.getInteger(R.styleable.DottedProgressBar_dpMinDotsSizePercent, defaultMinDotSize);
        this.mArrowWidthPercent = a.getInteger(R.styleable.DottedProgressBar_dpArrowWidthPercent, defaultArrowWidthSize);
        this.mArrowHourPaddingPercent = a.getInteger(R.styleable.DottedProgressBar_dpArrowHourPaddingPercent, defaultArrowHourPadding);
        this.mArrowMinutePaddingPercent = a.getInteger(R.styleable.DottedProgressBar_dpArrowMinutePaddingPercent, defaultArrowMinutePadding);
        this.mHourArrowSpeed = a.getInteger(R.styleable.DottedProgressBar_dpArrowHourSpeed, defaultHourArrowSpeed);
        this.mHourArrowSpeed *= 0.1f;
        this.mMinuteArrowSpeed = a.getInteger(R.styleable.DottedProgressBar_dpArrowMinuteSpeed, defaultMinuteArrowSpeed);
        this.mMinuteArrowSpeed *= 0.1f;
        this.mRotationSpeed = a.getInteger(R.styleable.DottedProgressBar_dpRotationSpeed, defaultRotationSpeed);
        this.mRotationSpeed *= 0.1f;
        this.mSpaceBetweenDots = 360 / this.mDotsCount;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int w = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int h = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int smallestSide = Math.min(w, h);
        this.mCenter = (float)smallestSide * 0.5f;
        this.mMaxCircleSize = smallestSide / 100 * this.mMaxDotSizePercent;
        float minCircleSize = smallestSide / 100 * this.mMinDotSizePercent;
        this.mDeltaSize = (this.mMaxCircleSize - minCircleSize) / (float)this.mDotsCount;
        this.mHourArrowTopPadding = smallestSide / 100 * this.mArrowHourPaddingPercent;
        this.mMinuteArrowTopPadding = smallestSide / 100 * this.mArrowMinutePaddingPercent;
        this.mArrowWidth = smallestSide / 100 * this.mArrowWidthPercent;
        this.setMeasuredDimension(smallestSide, smallestSide);
    }

    protected void onDraw(Canvas canvas) {
        for (int i = 0 + this.mIterator; i <= this.mDotsCount + this.mIterator; ++i) {
            float circleSize = this.mMaxCircleSize - this.mDeltaSize * (float)(i - this.mIterator);
            canvas.save();
            float speed = this.mSpaceBetweenDots * (float)i;
            canvas.rotate(this.isClockWiseDots ? speed : -speed, this.mCenter, this.mCenter);
            canvas.drawCircle(this.mCenter, circleSize, circleSize, this.mDotsPaint);
            this.invalidate();
            canvas.restore();
        }
        this.mTimeInterval += this.mRotationSpeed;
        int updateThreshold = 3;
        if (this.mTimeInterval >= (float)updateThreshold) {
            ++this.mIterator;
            this.mTimeInterval = 0.0f;
        }
        if (!this.hideArrows) {
            canvas.save();
            float mSpeed = this.mMinuteArrowAngle += this.mMinuteArrowSpeed;
            canvas.rotate(this.isCounterClockWiseArrows ? -mSpeed : mSpeed, this.mCenter, this.mCenter);
            canvas.drawRect(this.mCenter - this.mArrowWidth * 0.5f, this.mMinuteArrowTopPadding, this.mCenter + this.mArrowWidth * 0.5f, this.mCenter, this.mArrowsPaint);
            this.invalidate();
            canvas.restore();
            canvas.save();
            float hSpeed = this.mHourArrowAngle += this.mHourArrowSpeed;
            canvas.rotate(this.isCounterClockWiseArrows ? -hSpeed : hSpeed, this.mCenter, this.mCenter);
            canvas.drawRect(this.mCenter - this.mArrowWidth * 0.5f, this.mHourArrowTopPadding, this.mCenter + this.mArrowWidth * 0.5f, this.mCenter, this.mArrowsPaint);
            this.invalidate();
            canvas.restore();
            canvas.drawCircle(this.mCenter, this.mCenter, this.mArrowWidth * 0.5f, this.mCenterPaint);
        }
    }
}

