/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.ThrowableIntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IntConsumer {
    public void accept(int var1);

    public static class Util {
        private Util() {
        }

        public static IntConsumer andThen(final @NotNull IntConsumer c1, final @NotNull IntConsumer c2) {
            Objects.requireNonNull(c1, "c1");
            Objects.requireNonNull(c2, "c2");
            return new IntConsumer(){

                @Override
                public void accept(int value) {
                    c1.accept(value);
                    c2.accept(value);
                }
            };
        }

        public static IntConsumer safe(@NotNull ThrowableIntConsumer<Throwable> throwableConsumer) {
            return Util.safe(throwableConsumer, null);
        }

        public static IntConsumer safe(final @NotNull ThrowableIntConsumer<Throwable> throwableConsumer, final @Nullable IntConsumer onFailedConsumer) {
            Objects.requireNonNull(throwableConsumer);
            return new IntConsumer(){

                @Override
                public void accept(int value) {
                    block2: {
                        try {
                            throwableConsumer.accept(value);
                        }
                        catch (Throwable ex) {
                            if (onFailedConsumer == null) break block2;
                            onFailedConsumer.accept(value);
                        }
                    }
                }
            };
        }
    }
}

