/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.ThrowableConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Consumer<T> {
    public void accept(T var1);

    public static class Util {
        private Util() {
        }

        public static <T> Consumer<T> andThen(final @NotNull Consumer<? super T> c1, final @NotNull Consumer<? super T> c2) {
            Objects.requireNonNull(c1, "c1");
            Objects.requireNonNull(c2, "c2");
            return new Consumer<T>(){

                @Override
                public void accept(T value) {
                    c1.accept(value);
                    c2.accept(value);
                }
            };
        }

        public static <T> Consumer<T> safe(@NotNull ThrowableConsumer<? super T, Throwable> throwableConsumer) {
            return Util.safe(throwableConsumer, null);
        }

        public static <T> Consumer<T> safe(final @NotNull ThrowableConsumer<? super T, Throwable> throwableConsumer, final @Nullable Consumer<? super T> onFailedConsumer) {
            Objects.requireNonNull(throwableConsumer);
            return new Consumer<T>(){

                @Override
                public void accept(T value) {
                    block2: {
                        Objects.requireNonNull(throwableConsumer);
                        try {
                            throwableConsumer.accept(value);
                        }
                        catch (Throwable ex) {
                            if (onFailedConsumer == null) break block2;
                            onFailedConsumer.accept(value);
                        }
                    }
                }
            };
        }
    }
}

