/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.DoubleStream;
import com.annimon.stream.Objects;
import com.annimon.stream.Optional;
import com.annimon.stream.OptionalInt;
import com.annimon.stream.OptionalLong;
import com.annimon.stream.function.DoubleConsumer;
import com.annimon.stream.function.DoubleFunction;
import com.annimon.stream.function.DoublePredicate;
import com.annimon.stream.function.DoubleSupplier;
import com.annimon.stream.function.DoubleToIntFunction;
import com.annimon.stream.function.DoubleToLongFunction;
import com.annimon.stream.function.DoubleUnaryOperator;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.Supplier;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptionalDouble {
    private static final OptionalDouble EMPTY = new OptionalDouble();
    private final boolean isPresent;
    private final double value;

    @NotNull
    public static OptionalDouble empty() {
        return EMPTY;
    }

    @NotNull
    public static OptionalDouble of(double value) {
        return new OptionalDouble(value);
    }

    @NotNull
    public static OptionalDouble ofNullable(@Nullable Double value) {
        return value == null ? EMPTY : new OptionalDouble(value);
    }

    private OptionalDouble() {
        this.isPresent = false;
        this.value = 0.0;
    }

    private OptionalDouble(double value) {
        this.isPresent = true;
        this.value = value;
    }

    public double getAsDouble() {
        return this.orElseThrow();
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public void ifPresent(@NotNull DoubleConsumer consumer) {
        if (this.isPresent) {
            consumer.accept(this.value);
        }
    }

    public void ifPresentOrElse(@NotNull DoubleConsumer consumer, @NotNull Runnable emptyAction) {
        if (this.isPresent) {
            consumer.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    @NotNull
    public OptionalDouble executeIfPresent(@NotNull DoubleConsumer consumer) {
        this.ifPresent(consumer);
        return this;
    }

    @NotNull
    public OptionalDouble executeIfAbsent(@NotNull Runnable action) {
        if (!this.isPresent()) {
            action.run();
        }
        return this;
    }

    @Nullable
    public <R> R custom(@NotNull Function<OptionalDouble, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    @NotNull
    public OptionalDouble filter(@NotNull DoublePredicate predicate) {
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : OptionalDouble.empty();
    }

    @NotNull
    public OptionalDouble filterNot(@NotNull DoublePredicate predicate) {
        return this.filter(DoublePredicate.Util.negate(predicate));
    }

    @NotNull
    public OptionalDouble map(@NotNull DoubleUnaryOperator mapper) {
        if (!this.isPresent()) {
            return OptionalDouble.empty();
        }
        Objects.requireNonNull(mapper);
        return OptionalDouble.of(mapper.applyAsDouble(this.value));
    }

    @NotNull
    public <U> Optional<U> mapToObj(@NotNull DoubleFunction<U> mapper) {
        if (!this.isPresent()) {
            return Optional.empty();
        }
        Objects.requireNonNull(mapper);
        return Optional.ofNullable(mapper.apply(this.value));
    }

    @NotNull
    public OptionalInt mapToInt(@NotNull DoubleToIntFunction mapper) {
        if (!this.isPresent()) {
            return OptionalInt.empty();
        }
        Objects.requireNonNull(mapper);
        return OptionalInt.of(mapper.applyAsInt(this.value));
    }

    @NotNull
    public OptionalLong mapToLong(@NotNull DoubleToLongFunction mapper) {
        if (!this.isPresent()) {
            return OptionalLong.empty();
        }
        Objects.requireNonNull(mapper);
        return OptionalLong.of(mapper.applyAsLong(this.value));
    }

    @NotNull
    public DoubleStream stream() {
        if (!this.isPresent()) {
            return DoubleStream.empty();
        }
        return DoubleStream.of(this.value);
    }

    @NotNull
    public OptionalDouble or(@NotNull Supplier<OptionalDouble> supplier) {
        if (this.isPresent()) {
            return this;
        }
        Objects.requireNonNull(supplier);
        return Objects.requireNonNull(supplier.get());
    }

    public double orElse(double other) {
        return this.isPresent ? this.value : other;
    }

    public double orElseGet(@NotNull DoubleSupplier other) {
        return this.isPresent ? this.value : other.getAsDouble();
    }

    public double orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> double orElseThrow(@NotNull Supplier<X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalDouble)) {
            return false;
        }
        OptionalDouble other = (OptionalDouble)obj;
        return this.isPresent && other.isPresent ? Double.compare(this.value, other.value) == 0 : this.isPresent == other.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? Objects.hashCode(this.value) : 0;
    }

    @NotNull
    public String toString() {
        return this.isPresent ? String.format("OptionalDouble[%s]", this.value) : "OptionalDouble.empty";
    }
}

