/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.DoubleStream;
import com.annimon.stream.IntStream;
import com.annimon.stream.Objects;
import com.annimon.stream.OptionalLong;
import com.annimon.stream.Stream;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.IndexedLongConsumer;
import com.annimon.stream.function.IndexedLongPredicate;
import com.annimon.stream.function.IndexedLongUnaryOperator;
import com.annimon.stream.function.LongBinaryOperator;
import com.annimon.stream.function.LongConsumer;
import com.annimon.stream.function.LongFunction;
import com.annimon.stream.function.LongPredicate;
import com.annimon.stream.function.LongSupplier;
import com.annimon.stream.function.LongToDoubleFunction;
import com.annimon.stream.function.LongToIntFunction;
import com.annimon.stream.function.LongUnaryOperator;
import com.annimon.stream.function.ObjLongConsumer;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ToLongFunction;
import com.annimon.stream.internal.Compose;
import com.annimon.stream.internal.Operators;
import com.annimon.stream.internal.Params;
import com.annimon.stream.internal.SpinedBuffer;
import com.annimon.stream.iterator.PrimitiveIndexedIterator;
import com.annimon.stream.iterator.PrimitiveIterator;
import com.annimon.stream.operator.LongArray;
import com.annimon.stream.operator.LongConcat;
import com.annimon.stream.operator.LongDropWhile;
import com.annimon.stream.operator.LongFilter;
import com.annimon.stream.operator.LongFilterIndexed;
import com.annimon.stream.operator.LongFlatMap;
import com.annimon.stream.operator.LongGenerate;
import com.annimon.stream.operator.LongIterate;
import com.annimon.stream.operator.LongLimit;
import com.annimon.stream.operator.LongMap;
import com.annimon.stream.operator.LongMapIndexed;
import com.annimon.stream.operator.LongMapToDouble;
import com.annimon.stream.operator.LongMapToInt;
import com.annimon.stream.operator.LongMapToObj;
import com.annimon.stream.operator.LongPeek;
import com.annimon.stream.operator.LongRangeClosed;
import com.annimon.stream.operator.LongSample;
import com.annimon.stream.operator.LongScan;
import com.annimon.stream.operator.LongScanIdentity;
import com.annimon.stream.operator.LongSkip;
import com.annimon.stream.operator.LongSorted;
import com.annimon.stream.operator.LongTakeUntil;
import com.annimon.stream.operator.LongTakeWhile;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LongStream
implements Closeable {
    private static final LongStream EMPTY = new LongStream(new PrimitiveIterator.OfLong(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public long nextLong() {
            return 0L;
        }
    });
    private final PrimitiveIterator.OfLong iterator;
    private final Params params;
    private static final ToLongFunction<Long> UNBOX_FUNCTION = new ToLongFunction<Long>(){

        @Override
        public long applyAsLong(Long t) {
            return t;
        }
    };

    @NotNull
    public static LongStream empty() {
        return EMPTY;
    }

    @NotNull
    public static LongStream of(@NotNull PrimitiveIterator.OfLong iterator) {
        Objects.requireNonNull(iterator);
        return new LongStream(iterator);
    }

    @NotNull
    public static LongStream of(long ... values) {
        Objects.requireNonNull(values);
        if (values.length == 0) {
            return LongStream.empty();
        }
        return new LongStream(new LongArray(values));
    }

    @NotNull
    public static LongStream of(long t) {
        return new LongStream(new LongArray(new long[]{t}));
    }

    @NotNull
    public static LongStream range(long startInclusive, long endExclusive) {
        if (startInclusive >= endExclusive) {
            return LongStream.empty();
        }
        return LongStream.rangeClosed(startInclusive, endExclusive - 1L);
    }

    @NotNull
    public static LongStream rangeClosed(long startInclusive, long endInclusive) {
        if (startInclusive > endInclusive) {
            return LongStream.empty();
        }
        if (startInclusive == endInclusive) {
            return LongStream.of(startInclusive);
        }
        return new LongStream(new LongRangeClosed(startInclusive, endInclusive));
    }

    @NotNull
    public static LongStream generate(@NotNull LongSupplier s) {
        Objects.requireNonNull(s);
        return new LongStream(new LongGenerate(s));
    }

    @NotNull
    public static LongStream iterate(long seed, @NotNull LongUnaryOperator f) {
        Objects.requireNonNull(f);
        return new LongStream(new LongIterate(seed, f));
    }

    @NotNull
    public static LongStream iterate(long seed, @NotNull LongPredicate predicate, @NotNull LongUnaryOperator op) {
        Objects.requireNonNull(predicate);
        return LongStream.iterate(seed, op).takeWhile(predicate);
    }

    @NotNull
    public static LongStream concat(@NotNull LongStream a, @NotNull LongStream b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        LongStream result = new LongStream(new LongConcat(a.iterator, b.iterator));
        return result.onClose(Compose.closeables(a, b));
    }

    @NotNull
    public static LongStream concat(@NotNull LongStream a, @NotNull LongStream b, LongStream ... rest) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Objects.requireNonNull(rest);
        ArrayList<PrimitiveIterator.OfLong> iterators = new ArrayList<PrimitiveIterator.OfLong>(rest.length + 2);
        ArrayList<LongStream> closeables = new ArrayList<LongStream>(rest.length + 2);
        Collections.addAll(iterators, a.iterator, b.iterator);
        Collections.addAll(closeables, a, b);
        for (LongStream stream : rest) {
            iterators.add(stream.iterator);
            closeables.add(stream);
        }
        LongStream result = new LongStream(new LongConcat(iterators));
        return result.onClose(Compose.closeables(closeables));
    }

    private LongStream(PrimitiveIterator.OfLong iterator) {
        this(null, iterator);
    }

    LongStream(Params params, PrimitiveIterator.OfLong iterator) {
        this.params = params;
        this.iterator = iterator;
    }

    public PrimitiveIterator.OfLong iterator() {
        return this.iterator;
    }

    @Nullable
    public <R> R custom(@NotNull Function<LongStream, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    @NotNull
    public Stream<Long> boxed() {
        return new Stream<Long>(this.params, this.iterator);
    }

    @NotNull
    public LongStream prepend(@NotNull LongStream stream) {
        return LongStream.concat(stream, this);
    }

    @NotNull
    public LongStream append(@NotNull LongStream stream) {
        return LongStream.concat(this, stream);
    }

    @NotNull
    public LongStream filter(@NotNull LongPredicate predicate) {
        return new LongStream(this.params, new LongFilter(this.iterator, predicate));
    }

    @NotNull
    public LongStream filterIndexed(@NotNull IndexedLongPredicate predicate) {
        return this.filterIndexed(0, 1, predicate);
    }

    @NotNull
    public LongStream filterIndexed(int from, int step, @NotNull IndexedLongPredicate predicate) {
        return new LongStream(this.params, new LongFilterIndexed(new PrimitiveIndexedIterator.OfLong(from, step, this.iterator), predicate));
    }

    @NotNull
    public LongStream filterNot(@NotNull LongPredicate predicate) {
        return this.filter(LongPredicate.Util.negate(predicate));
    }

    @NotNull
    public LongStream map(@NotNull LongUnaryOperator mapper) {
        return new LongStream(this.params, new LongMap(this.iterator, mapper));
    }

    @NotNull
    public LongStream mapIndexed(@NotNull IndexedLongUnaryOperator mapper) {
        return this.mapIndexed(0, 1, mapper);
    }

    @NotNull
    public LongStream mapIndexed(int from, int step, @NotNull IndexedLongUnaryOperator mapper) {
        return new LongStream(this.params, new LongMapIndexed(new PrimitiveIndexedIterator.OfLong(from, step, this.iterator), mapper));
    }

    @NotNull
    public <R> Stream<R> mapToObj(@NotNull LongFunction<? extends R> mapper) {
        return new Stream<R>(this.params, new LongMapToObj<R>(this.iterator, mapper));
    }

    @NotNull
    public IntStream mapToInt(@NotNull LongToIntFunction mapper) {
        return new IntStream(this.params, new LongMapToInt(this.iterator, mapper));
    }

    @NotNull
    public DoubleStream mapToDouble(@NotNull LongToDoubleFunction mapper) {
        return new DoubleStream(this.params, new LongMapToDouble(this.iterator, mapper));
    }

    @NotNull
    public LongStream flatMap(@NotNull LongFunction<? extends LongStream> mapper) {
        return new LongStream(this.params, new LongFlatMap(this.iterator, mapper));
    }

    @NotNull
    public LongStream mapMulti(final @NotNull LongMapMultiConsumer mapper) {
        return this.flatMap((LongFunction<? extends LongStream>)new LongFunction<LongStream>(){

            @Override
            public LongStream apply(long value) {
                SpinedBuffer.OfLong buffer = new SpinedBuffer.OfLong();
                mapper.accept(value, buffer);
                return LongStream.of(buffer.iterator());
            }
        });
    }

    @NotNull
    public LongStream distinct() {
        return this.boxed().distinct().mapToLong(UNBOX_FUNCTION);
    }

    @NotNull
    public LongStream sorted() {
        return new LongStream(this.params, new LongSorted(this.iterator));
    }

    @NotNull
    public LongStream sorted(@Nullable Comparator<Long> comparator) {
        return this.boxed().sorted(comparator).mapToLong(UNBOX_FUNCTION);
    }

    @NotNull
    public LongStream sample(int stepWidth) {
        if (stepWidth <= 0) {
            throw new IllegalArgumentException("stepWidth cannot be zero or negative");
        }
        if (stepWidth == 1) {
            return this;
        }
        return new LongStream(this.params, new LongSample(this.iterator, stepWidth));
    }

    @NotNull
    public LongStream peek(@NotNull LongConsumer action) {
        return new LongStream(this.params, new LongPeek(this.iterator, action));
    }

    @NotNull
    public LongStream scan(@NotNull LongBinaryOperator accumulator) {
        Objects.requireNonNull(accumulator);
        return new LongStream(this.params, new LongScan(this.iterator, accumulator));
    }

    @NotNull
    public LongStream scan(long identity, @NotNull LongBinaryOperator accumulator) {
        Objects.requireNonNull(accumulator);
        return new LongStream(this.params, new LongScanIdentity(this.iterator, identity, accumulator));
    }

    @NotNull
    public LongStream takeWhile(@NotNull LongPredicate predicate) {
        return new LongStream(this.params, new LongTakeWhile(this.iterator, predicate));
    }

    @NotNull
    public LongStream takeUntil(@NotNull LongPredicate stopPredicate) {
        return new LongStream(this.params, new LongTakeUntil(this.iterator, stopPredicate));
    }

    @NotNull
    public LongStream dropWhile(@NotNull LongPredicate predicate) {
        return new LongStream(this.params, new LongDropWhile(this.iterator, predicate));
    }

    @NotNull
    public LongStream limit(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("maxSize cannot be negative");
        }
        if (maxSize == 0L) {
            return LongStream.empty();
        }
        return new LongStream(this.params, new LongLimit(this.iterator, maxSize));
    }

    @NotNull
    public LongStream skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n cannot be negative");
        }
        if (n == 0L) {
            return this;
        }
        return new LongStream(this.params, new LongSkip(this.iterator, n));
    }

    public void forEach(@NotNull LongConsumer action) {
        while (this.iterator.hasNext()) {
            action.accept(this.iterator.nextLong());
        }
    }

    public void forEachIndexed(@NotNull IndexedLongConsumer action) {
        this.forEachIndexed(0, 1, action);
    }

    public void forEachIndexed(int from, int step, @NotNull IndexedLongConsumer action) {
        int index = from;
        while (this.iterator.hasNext()) {
            action.accept(index, this.iterator.nextLong());
            index += step;
        }
    }

    public long reduce(long identity, @NotNull LongBinaryOperator accumulator) {
        long result = identity;
        while (this.iterator.hasNext()) {
            long value = this.iterator.nextLong();
            result = accumulator.applyAsLong(result, value);
        }
        return result;
    }

    @NotNull
    public OptionalLong reduce(@NotNull LongBinaryOperator accumulator) {
        boolean foundAny = false;
        long result = 0L;
        while (this.iterator.hasNext()) {
            long value = this.iterator.nextLong();
            if (!foundAny) {
                foundAny = true;
                result = value;
                continue;
            }
            result = accumulator.applyAsLong(result, value);
        }
        return foundAny ? OptionalLong.of(result) : OptionalLong.empty();
    }

    @NotNull
    public long[] toArray() {
        return Operators.toLongArray(this.iterator);
    }

    @Nullable
    public <R> R collect(@NotNull Supplier<R> supplier, @NotNull ObjLongConsumer<R> accumulator) {
        R result = supplier.get();
        while (this.iterator.hasNext()) {
            long value = this.iterator.nextLong();
            accumulator.accept(result, value);
        }
        return result;
    }

    public long sum() {
        long sum = 0L;
        while (this.iterator.hasNext()) {
            sum += this.iterator.nextLong();
        }
        return sum;
    }

    @NotNull
    public OptionalLong min() {
        return this.reduce(new LongBinaryOperator(){

            @Override
            public long applyAsLong(long left, long right) {
                return Math.min(left, right);
            }
        });
    }

    @NotNull
    public OptionalLong max() {
        return this.reduce(new LongBinaryOperator(){

            @Override
            public long applyAsLong(long left, long right) {
                return Math.max(left, right);
            }
        });
    }

    public long count() {
        long count = 0L;
        while (this.iterator.hasNext()) {
            this.iterator.nextLong();
            ++count;
        }
        return count;
    }

    public boolean anyMatch(@NotNull LongPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextLong())) continue;
            return true;
        }
        return false;
    }

    public boolean allMatch(@NotNull LongPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (predicate.test(this.iterator.nextLong())) continue;
            return false;
        }
        return true;
    }

    public boolean noneMatch(@NotNull LongPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextLong())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public OptionalLong findFirst() {
        if (this.iterator.hasNext()) {
            return OptionalLong.of(this.iterator.nextLong());
        }
        return OptionalLong.empty();
    }

    public long findFirstOrElse(long other) {
        if (this.iterator.hasNext()) {
            return this.iterator.nextLong();
        }
        return other;
    }

    @NotNull
    public OptionalLong findLast() {
        return this.reduce(new LongBinaryOperator(){

            @Override
            public long applyAsLong(long left, long right) {
                return right;
            }
        });
    }

    public long single() {
        if (!this.iterator.hasNext()) {
            throw new NoSuchElementException("LongStream contains no element");
        }
        long singleCandidate = this.iterator.nextLong();
        if (this.iterator.hasNext()) {
            throw new IllegalStateException("LongStream contains more than one element");
        }
        return singleCandidate;
    }

    @NotNull
    public OptionalLong findSingle() {
        if (!this.iterator.hasNext()) {
            return OptionalLong.empty();
        }
        long singleCandidate = this.iterator.nextLong();
        if (this.iterator.hasNext()) {
            throw new IllegalStateException("LongStream contains more than one element");
        }
        return OptionalLong.of(singleCandidate);
    }

    @NotNull
    public LongStream onClose(@NotNull Runnable closeHandler) {
        Objects.requireNonNull(closeHandler);
        Params newParams = Params.wrapWithCloseHandler(this.params, closeHandler);
        return new LongStream(newParams, this.iterator);
    }

    @Override
    public void close() {
        if (this.params != null && this.params.closeHandler != null) {
            this.params.closeHandler.run();
            this.params.closeHandler = null;
        }
    }

    public static interface LongMapMultiConsumer {
        public void accept(long var1, LongConsumer var3);
    }
}

