/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.function.Supplier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

public final class Objects {
    private Objects() {
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean deepEquals(Object a, Object b) {
        return a == b || a != null && b != null && Arrays.deepEquals(new Object[]{a}, new Object[]{b});
    }

    public static int hashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static int hash(Object ... values) {
        if (values == null) {
            return 0;
        }
        int result = 1;
        for (Object element : values) {
            result = 31 * result + Objects.hashCode(element);
        }
        return result;
    }

    public static String toString(Object o, String nullDefault) {
        return o != null ? o.toString() : nullDefault;
    }

    public static <T> int compare(T a, T b, Comparator<? super T> c) {
        return a == b ? 0 : c.compare(a, b);
    }

    public static int compareInt(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compareLong(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static <T> T requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static <T> T requireNonNull(T obj, Supplier<String> messageSupplier) {
        if (obj == null) {
            throw new NullPointerException(messageSupplier.get());
        }
        return obj;
    }

    public static <T> T requireNonNullElse(T obj, T defaultObj) {
        return obj != null ? obj : Objects.requireNonNull(defaultObj, "defaultObj");
    }

    public static <T> T requireNonNullElseGet(T obj, Supplier<? extends T> supplier) {
        if (obj != null) {
            return obj;
        }
        T suppliedObj = Objects.requireNonNull(supplier, "supplier").get();
        return Objects.requireNonNull(suppliedObj, "supplier.get()");
    }

    public static <T> Collection<T> requireNonNullElements(Collection<T> collection) {
        Objects.requireNonNull(collection);
        for (T t : collection) {
            Objects.requireNonNull(t);
        }
        return collection;
    }

    public static boolean isNull(Object obj) {
        return obj == null;
    }

    public static boolean nonNull(Object obj) {
        return obj != null;
    }
}

