package com.annimon.stream.operator;

import com.annimon.stream.internal.Operators;
import com.annimon.stream.PrimitiveExtIterator;
import com.annimon.stream.PrimitiveIterator;
import java.util.Arrays;

public class DoubleSorted extends PrimitiveExtIterator.OfDouble {

    private final PrimitiveIterator.OfDouble iterator;
    private int index;
    private double[] array;

    public DoubleSorted(PrimitiveIterator.OfDouble iterator) {
        this.iterator = iterator;
        index = 0;
    }

    @Override
    protected void nextIteration() {
        if (!isInit) {
            array = Operators.toDoubleArray(iterator);
            Arrays.sort(array);
        }
        hasNext = index < array.length;
        if (hasNext) {
            next = array[index++];
        }
    }
}
