/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.DoubleStream;
import com.annimon.stream.IntStream;
import com.annimon.stream.LsaIterator;
import com.annimon.stream.Objects;
import com.annimon.stream.OptionalLong;
import com.annimon.stream.PrimitiveExtIterator;
import com.annimon.stream.PrimitiveIterator;
import com.annimon.stream.SpinedBuffer;
import com.annimon.stream.Stream;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.LongBinaryOperator;
import com.annimon.stream.function.LongConsumer;
import com.annimon.stream.function.LongFunction;
import com.annimon.stream.function.LongPredicate;
import com.annimon.stream.function.LongSupplier;
import com.annimon.stream.function.LongToDoubleFunction;
import com.annimon.stream.function.LongToIntFunction;
import com.annimon.stream.function.LongUnaryOperator;
import com.annimon.stream.function.ObjLongConsumer;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ToLongFunction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;

public final class LongStream {
    private static final LongStream EMPTY = new LongStream(new PrimitiveIterator.OfLong(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public long nextLong() {
            return 0L;
        }
    });
    private final PrimitiveIterator.OfLong iterator;
    private static final ToLongFunction<Long> UNBOX_FUNCTION = new ToLongFunction<Long>(){

        @Override
        public long applyAsLong(Long t) {
            return t;
        }
    };

    public static LongStream empty() {
        return EMPTY;
    }

    public static LongStream of(PrimitiveIterator.OfLong iterator) {
        Objects.requireNonNull(iterator);
        return new LongStream(iterator);
    }

    public static LongStream of(final long ... values) {
        Objects.requireNonNull(values);
        return new LongStream(new PrimitiveIterator.OfLong(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < values.length;
            }

            @Override
            public long nextLong() {
                return values[this.index++];
            }
        });
    }

    public static LongStream of(final long t) {
        return new LongStream(new PrimitiveIterator.OfLong(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index == 0;
            }

            @Override
            public long nextLong() {
                ++this.index;
                return t;
            }
        });
    }

    public static LongStream range(long startInclusive, long endExclusive) {
        if (startInclusive >= endExclusive) {
            return LongStream.empty();
        }
        return LongStream.rangeClosed(startInclusive, endExclusive - 1L);
    }

    public static LongStream rangeClosed(final long startInclusive, final long endInclusive) {
        if (startInclusive > endInclusive) {
            return LongStream.empty();
        }
        if (startInclusive == endInclusive) {
            return LongStream.of(startInclusive);
        }
        return new LongStream(new PrimitiveIterator.OfLong(){
            private long current;
            private boolean hasNext;
            {
                this.current = startInclusive;
                this.hasNext = this.current <= endInclusive;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public long nextLong() {
                if (this.current >= endInclusive) {
                    this.hasNext = false;
                    return endInclusive;
                }
                return this.current++;
            }
        });
    }

    public static LongStream generate(final LongSupplier s) {
        Objects.requireNonNull(s);
        return new LongStream(new PrimitiveIterator.OfLong(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public long nextLong() {
                return s.getAsLong();
            }
        });
    }

    public static LongStream iterate(final long seed, final LongUnaryOperator f) {
        Objects.requireNonNull(f);
        return new LongStream(new PrimitiveIterator.OfLong(){
            private long current;
            {
                this.current = seed;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public long nextLong() {
                long old = this.current;
                this.current = f.applyAsLong(this.current);
                return old;
            }
        });
    }

    public static LongStream concat(LongStream a, LongStream b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        final PrimitiveIterator.OfLong it1 = a.iterator;
        final PrimitiveIterator.OfLong it2 = b.iterator;
        return new LongStream(new PrimitiveIterator.OfLong(){
            private boolean firstStreamIsCurrent = true;

            @Override
            public boolean hasNext() {
                if (this.firstStreamIsCurrent) {
                    if (it1.hasNext()) {
                        return true;
                    }
                    this.firstStreamIsCurrent = false;
                }
                return it2.hasNext();
            }

            @Override
            public long nextLong() {
                return this.firstStreamIsCurrent ? it1.nextLong() : it2.nextLong();
            }
        });
    }

    private LongStream(PrimitiveIterator.OfLong iterator) {
        this.iterator = iterator;
    }

    public PrimitiveIterator.OfLong iterator() {
        return this.iterator;
    }

    public <R> R custom(Function<LongStream, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    public Stream<Long> boxed() {
        return Stream.of(this.iterator);
    }

    public LongStream filter(final LongPredicate predicate) {
        return new LongStream(new PrimitiveIterator.OfLong(){
            private long next;

            @Override
            public boolean hasNext() {
                while (LongStream.this.iterator.hasNext()) {
                    this.next = LongStream.this.iterator.next();
                    if (!predicate.test(this.next)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public long nextLong() {
                return this.next;
            }
        });
    }

    public LongStream filterNot(LongPredicate predicate) {
        return this.filter(LongPredicate.Util.negate(predicate));
    }

    public LongStream map(final LongUnaryOperator mapper) {
        return new LongStream(new PrimitiveIterator.OfLong(){

            @Override
            public boolean hasNext() {
                return LongStream.this.iterator.hasNext();
            }

            @Override
            public long nextLong() {
                return mapper.applyAsLong(LongStream.this.iterator.nextLong());
            }
        });
    }

    public <R> Stream<R> mapToObj(final LongFunction<? extends R> mapper) {
        return Stream.of(new LsaIterator<R>(){

            @Override
            public boolean hasNext() {
                return LongStream.this.iterator.hasNext();
            }

            @Override
            public R nextIteration() {
                return mapper.apply(LongStream.this.iterator.nextLong());
            }
        });
    }

    public IntStream mapToInt(final LongToIntFunction mapper) {
        return IntStream.of(new PrimitiveIterator.OfInt(){

            @Override
            public boolean hasNext() {
                return LongStream.this.iterator.hasNext();
            }

            @Override
            public int nextInt() {
                return mapper.applyAsInt(LongStream.this.iterator.nextLong());
            }
        });
    }

    public DoubleStream mapToDouble(final LongToDoubleFunction mapper) {
        return DoubleStream.of(new PrimitiveIterator.OfDouble(){

            @Override
            public boolean hasNext() {
                return LongStream.this.iterator.hasNext();
            }

            @Override
            public double nextDouble() {
                return mapper.applyAsDouble(LongStream.this.iterator.nextLong());
            }
        });
    }

    public LongStream flatMap(final LongFunction<? extends LongStream> mapper) {
        return new LongStream(new PrimitiveIterator.OfLong(){
            private PrimitiveIterator.OfLong inner;

            @Override
            public boolean hasNext() {
                if (this.inner != null && this.inner.hasNext()) {
                    return true;
                }
                while (LongStream.this.iterator.hasNext()) {
                    long arg = LongStream.this.iterator.next();
                    LongStream result = (LongStream)mapper.apply(arg);
                    if (result == null || !result.iterator.hasNext()) continue;
                    this.inner = result.iterator;
                    return true;
                }
                return false;
            }

            @Override
            public long nextLong() {
                return this.inner.nextLong();
            }
        });
    }

    public LongStream distinct() {
        return this.boxed().distinct().mapToLong(UNBOX_FUNCTION);
    }

    public LongStream sorted() {
        return new LongStream(new PrimitiveExtIterator.OfLong(){
            private int index = 0;
            private long[] array;

            @Override
            protected void nextIteration() {
                if (!this.isInit) {
                    this.array = LongStream.this.toArray();
                    Arrays.sort(this.array);
                }
                boolean bl = this.hasNext = this.index < this.array.length;
                if (this.hasNext) {
                    this.next = this.array[this.index++];
                }
            }
        });
    }

    public LongStream sorted(Comparator<Long> comparator) {
        return this.boxed().sorted(comparator).mapToLong(UNBOX_FUNCTION);
    }

    public LongStream sample(final int stepWidth) {
        if (stepWidth <= 0) {
            throw new IllegalArgumentException("stepWidth cannot be zero or negative");
        }
        if (stepWidth == 1) {
            return this;
        }
        return new LongStream(new PrimitiveIterator.OfLong(){

            @Override
            public boolean hasNext() {
                return LongStream.this.iterator.hasNext();
            }

            @Override
            public long nextLong() {
                long result = LongStream.this.iterator.nextLong();
                for (int skip = 1; skip < stepWidth && LongStream.this.iterator.hasNext(); ++skip) {
                    LongStream.this.iterator.nextLong();
                }
                return result;
            }
        });
    }

    public LongStream peek(final LongConsumer action) {
        return new LongStream(new PrimitiveIterator.OfLong(){

            @Override
            public boolean hasNext() {
                return LongStream.this.iterator.hasNext();
            }

            @Override
            public long nextLong() {
                long value = LongStream.this.iterator.nextLong();
                action.accept(value);
                return value;
            }
        });
    }

    public LongStream takeWhile(final LongPredicate predicate) {
        return new LongStream(new PrimitiveExtIterator.OfLong(){

            @Override
            protected void nextIteration() {
                this.hasNext = LongStream.this.iterator.hasNext() && predicate.test(this.next = LongStream.this.iterator.next().longValue());
            }
        });
    }

    public LongStream dropWhile(final LongPredicate predicate) {
        return new LongStream(new PrimitiveExtIterator.OfLong(){

            @Override
            protected void nextIteration() {
                if (!this.isInit) {
                    while (this.hasNext = LongStream.this.iterator.hasNext()) {
                        this.next = LongStream.this.iterator.next();
                        if (predicate.test(this.next)) continue;
                        return;
                    }
                }
                boolean bl = this.hasNext = this.hasNext && LongStream.this.iterator.hasNext();
                if (!this.hasNext) {
                    return;
                }
                this.next = LongStream.this.iterator.next();
            }
        });
    }

    public LongStream limit(final long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("maxSize cannot be negative");
        }
        if (maxSize == 0L) {
            return LongStream.empty();
        }
        return new LongStream(new PrimitiveIterator.OfLong(){
            private long index = 0L;

            @Override
            public boolean hasNext() {
                return this.index < maxSize && LongStream.this.iterator.hasNext();
            }

            @Override
            public long nextLong() {
                ++this.index;
                return LongStream.this.iterator.nextLong();
            }
        });
    }

    public LongStream skip(final long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n cannot be negative");
        }
        if (n == 0L) {
            return this;
        }
        return new LongStream(new PrimitiveIterator.OfLong(){
            private long skippedCount = 0L;

            @Override
            public boolean hasNext() {
                while (LongStream.this.iterator.hasNext() && this.skippedCount != n) {
                    LongStream.this.iterator.nextLong();
                    ++this.skippedCount;
                }
                return LongStream.this.iterator.hasNext();
            }

            @Override
            public long nextLong() {
                return LongStream.this.iterator.nextLong();
            }
        });
    }

    public void forEach(LongConsumer action) {
        while (this.iterator.hasNext()) {
            action.accept(this.iterator.nextLong());
        }
    }

    public long reduce(long identity, LongBinaryOperator accumulator) {
        long result = identity;
        while (this.iterator.hasNext()) {
            long value = this.iterator.nextLong();
            result = accumulator.applyAsLong(result, value);
        }
        return result;
    }

    public OptionalLong reduce(LongBinaryOperator accumulator) {
        boolean foundAny = false;
        long result = 0L;
        while (this.iterator.hasNext()) {
            long value = this.iterator.nextLong();
            if (!foundAny) {
                foundAny = true;
                result = value;
                continue;
            }
            result = accumulator.applyAsLong(result, value);
        }
        return foundAny ? OptionalLong.of(result) : OptionalLong.empty();
    }

    public long[] toArray() {
        SpinedBuffer.OfLong b = new SpinedBuffer.OfLong();
        this.forEach(b);
        return (long[])b.asPrimitiveArray();
    }

    public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator) {
        R result = supplier.get();
        while (this.iterator.hasNext()) {
            long value = this.iterator.nextLong();
            accumulator.accept(result, value);
        }
        return result;
    }

    public long sum() {
        long sum = 0L;
        while (this.iterator.hasNext()) {
            sum += this.iterator.nextLong();
        }
        return sum;
    }

    public OptionalLong min() {
        return this.reduce(new LongBinaryOperator(){

            @Override
            public long applyAsLong(long left, long right) {
                return Math.min(left, right);
            }
        });
    }

    public OptionalLong max() {
        return this.reduce(new LongBinaryOperator(){

            @Override
            public long applyAsLong(long left, long right) {
                return Math.max(left, right);
            }
        });
    }

    public long count() {
        long count = 0L;
        while (this.iterator.hasNext()) {
            this.iterator.nextLong();
            ++count;
        }
        return count;
    }

    public boolean anyMatch(LongPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextLong())) continue;
            return true;
        }
        return false;
    }

    public boolean allMatch(LongPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (predicate.test(this.iterator.nextLong())) continue;
            return false;
        }
        return true;
    }

    public boolean noneMatch(LongPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextLong())) continue;
            return false;
        }
        return true;
    }

    public OptionalLong findFirst() {
        if (this.iterator.hasNext()) {
            return OptionalLong.of(this.iterator.nextLong());
        }
        return OptionalLong.empty();
    }

    public long single() {
        if (!this.iterator.hasNext()) {
            throw new NoSuchElementException("LongStream contains no element");
        }
        long singleCandidate = this.iterator.next();
        if (this.iterator.hasNext()) {
            throw new IllegalStateException("LongStream contains more than one element");
        }
        return singleCandidate;
    }

    public OptionalLong findSingle() {
        if (!this.iterator.hasNext()) {
            return OptionalLong.empty();
        }
        long singleCandidate = this.iterator.next();
        if (this.iterator.hasNext()) {
            throw new IllegalStateException("LongStream contains more than one element");
        }
        return OptionalLong.of(singleCandidate);
    }
}

