/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.IntStream;
import com.annimon.stream.function.IntSupplier;
import java.util.Random;

public final class RandomCompat {
    private final Random random;

    public RandomCompat() {
        this.random = new Random();
    }

    public RandomCompat(long seed) {
        this.random = new Random(seed);
    }

    public RandomCompat(Random random) {
        this.random = random;
    }

    public Random getRandom() {
        return this.random;
    }

    public IntStream ints(long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException();
        }
        if (streamSize == 0L) {
            return IntStream.empty();
        }
        return this.ints().limit(streamSize);
    }

    public IntStream ints() {
        return IntStream.generate(new IntSupplier(){

            @Override
            public int getAsInt() {
                return RandomCompat.this.random.nextInt();
            }
        });
    }

    public IntStream ints(long streamSize, int randomNumberOrigin, int randomNumberBound) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException();
        }
        if (streamSize == 0L) {
            return IntStream.empty();
        }
        return this.ints(randomNumberOrigin, randomNumberBound).limit(streamSize);
    }

    public IntStream ints(final int randomNumberOrigin, final int randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException();
        }
        return IntStream.generate(new IntSupplier(){
            private final int bound;
            {
                this.bound = randomNumberBound - randomNumberOrigin;
            }

            @Override
            public int getAsInt() {
                return randomNumberOrigin + RandomCompat.this.random.nextInt(this.bound);
            }
        });
    }
}

