/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.oss.ossbuilder;

import com.anji.plus.gaea.oss.config.OSSAmazonS3Properties;
import com.anji.plus.gaea.oss.config.OSSMinioProperties;
import com.anji.plus.gaea.oss.config.OSSProperties;
import com.anji.plus.gaea.oss.ossbuilder.GaeaOSSTemplate;
import com.anji.plus.gaea.oss.ossbuilder.builders.AmazonS3Client;
import com.anji.plus.gaea.oss.ossbuilder.builders.MinioClient;
import com.anji.plus.gaea.oss.ossbuilder.builders.NFSClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.StringUtils;

public class FileClientFactory
implements FactoryBean<GaeaOSSTemplate> {
    private static Logger logger = LoggerFactory.getLogger(FileClientFactory.class);
    private GaeaOSSTemplate gaeaOSSTemplate;
    private OSSProperties ossProperties;

    public FileClientFactory(OSSProperties ossProperties) {
        this.ossProperties = ossProperties;
        this.initFileClient();
    }

    public GaeaOSSTemplate getObject() throws Exception {
        return this.gaeaOSSTemplate;
    }

    public Class<?> getObjectType() {
        return GaeaOSSTemplate.class;
    }

    public boolean isSingleton() {
        return super.isSingleton();
    }

    private void initFileClient() {
        OSSMinioProperties minio = this.ossProperties.getMinio();
        if (minio != null && !StringUtils.isEmpty((Object)minio.getUrl())) {
            this.gaeaOSSTemplate = new MinioClient(this.ossProperties);
            return;
        }
        OSSAmazonS3Properties amazonS3 = this.ossProperties.getAmazonS3();
        if (amazonS3 != null && !StringUtils.isEmpty((Object)amazonS3.getUrl())) {
            this.gaeaOSSTemplate = new AmazonS3Client(this.ossProperties);
            return;
        }
        this.gaeaOSSTemplate = new NFSClient(this.ossProperties);
    }
}

