/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class Maths {
    public static boolean gt(String value, String value2) {
        BigDecimal bigDecimal = new BigDecimal(value);
        BigDecimal bigDecimal1 = new BigDecimal(value2);
        return bigDecimal.compareTo(bigDecimal1) > 0;
    }

    public static boolean ge(String value, String value2) {
        return Maths.gt(value, value2) || Maths.eq(value, value2);
    }

    public static boolean eq(String value, String value2) {
        BigDecimal bigDecimal = new BigDecimal(value);
        BigDecimal bigDecimal1 = new BigDecimal(value2);
        return bigDecimal.compareTo(bigDecimal1) == 0;
    }

    public static <T> String plus(List<T> values, Function<T, String> function) {
        Optional<BigDecimal> reduce = values.stream().map(function).filter(StringUtils::isNotBlank).map(BigDecimal::new).reduce(BigDecimal::add);
        if (reduce.isPresent()) {
            return Double.toString(reduce.get().doubleValue());
        }
        return Double.toString(BigDecimal.ZERO.doubleValue());
    }

    public static String plus(List<String> values) {
        return Maths.plus(values, (T value) -> value);
    }

    public static String plus(String ... values) {
        List<String> listValues = Arrays.asList(values);
        return Maths.plus(listValues);
    }

    public static String minus(List<String> values) {
        Optional<BigDecimal> reduce = values.stream().map(BigDecimal::new).reduce(BigDecimal::subtract);
        if (reduce.isPresent()) {
            return Double.toString(reduce.get().doubleValue());
        }
        return Double.toString(BigDecimal.ZERO.doubleValue());
    }

    public static String minus(String ... values) {
        return Maths.minus(Arrays.asList(values));
    }

    public static <T> String multiply(List<T> values, Function<T, String> function) {
        Optional<BigDecimal> reduce = values.stream().map(function).map(BigDecimal::new).reduce(BigDecimal::multiply);
        if (reduce.isPresent()) {
            return Double.toString(reduce.get().doubleValue());
        }
        return Double.toString(BigDecimal.ZERO.doubleValue());
    }

    public static String multiply(String ... values) {
        return Maths.multiply(6, values);
    }

    public static String multiply(int scale, String ... values) {
        Optional<BigDecimal> reduce = Arrays.asList(values).stream().map(BigDecimal::new).reduce(BigDecimal::multiply);
        if (reduce.isPresent()) {
            BigDecimal bigDecimal = reduce.get();
            bigDecimal = bigDecimal.setScale(scale, 4);
            return bigDecimal.toPlainString();
        }
        return Double.toString(BigDecimal.ZERO.doubleValue());
    }

    public static String divide(String value, String value2) {
        BigDecimal bigDecimal = new BigDecimal(value);
        BigDecimal bigDecimal2 = new BigDecimal(value2);
        BigDecimal divide = bigDecimal.divide(bigDecimal2, 6, 4);
        return Double.toString(divide.doubleValue());
    }

    public static String strFormat(String value) {
        DecimalFormat format = new DecimalFormat("0.00");
        return format.format(new BigDecimal(value));
    }

    public static void main(String[] args) {
        String plus = Maths.multiply("12", "10");
        System.out.println(plus);
    }
}

