/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.utils;

import com.anji.plus.gaea.GaeaProperties;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class JwtBean {
    private GaeaProperties gaeaProperties;

    public JwtBean() {
    }

    public JwtBean(GaeaProperties gaeaProperties) {
        this.gaeaProperties = gaeaProperties;
    }

    public GaeaProperties getGaeaProperties() {
        return this.gaeaProperties;
    }

    public String createToken(String username, String uuid) {
        String token = JWT.create().withClaim("username", username).withClaim("uuid", uuid).sign(Algorithm.HMAC256((String)this.gaeaProperties.getSecurity().getJwtSecret()));
        return token;
    }

    public String createToken(String username, String uuid, Integer type, String tenantCode) {
        String token = JWT.create().withClaim("username", username).withClaim("uuid", uuid).withClaim("type", type).withClaim("tenant", tenantCode).sign(Algorithm.HMAC256((String)this.gaeaProperties.getSecurity().getJwtSecret()));
        return token;
    }

    public String createToken(String username, List<String> roles, List<String> authorities, List<String> menus) {
        JWTCreator.Builder builder = JWT.create();
        if (!CollectionUtils.isEmpty(roles)) {
            builder.withClaim("role", roles);
        }
        if (!CollectionUtils.isEmpty(authorities)) {
            builder.withClaim("authorities", authorities);
        }
        if (!CollectionUtils.isEmpty(authorities)) {
            builder.withClaim("menus", menus);
        }
        String token = builder.withClaim("username", username).sign(Algorithm.HMAC256((String)this.gaeaProperties.getSecurity().getJwtSecret()));
        return token;
    }

    public Map<String, Claim> getClaim(String token) {
        JWTVerifier jwtVerifier = JWT.require((Algorithm)Algorithm.HMAC256((String)this.gaeaProperties.getSecurity().getJwtSecret())).build();
        DecodedJWT decodedJWT = jwtVerifier.verify(token);
        return decodedJWT.getClaims();
    }

    public String getUsername(String token) {
        Claim claim = this.getClaim(token).get("username");
        if (claim == null) {
            return null;
        }
        return claim.asString();
    }

    public String getTenant(String token) {
        Claim claim = this.getClaim(token).get("tenant");
        if (claim == null) {
            return null;
        }
        return claim.asString();
    }

    public Integer getUserType(String token) {
        Claim claim = this.getClaim(token).get("type");
        if (claim == null) {
            return null;
        }
        return claim.asInt();
    }

    public String getUUID(String token) {
        Claim claim = this.getClaim(token).get("uuid");
        if (claim == null) {
            return null;
        }
        return claim.asString();
    }
}

