/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.introspector;

import com.anji.plus.gaea.holder.UserContentHolder;
import com.anji.plus.gaea.utils.GaeaDateUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateDeSerializer
extends JsonDeserializer<Date> {
    private static Logger logger = LoggerFactory.getLogger(DateDeSerializer.class);
    private final String pattern;

    public DateDeSerializer(String pattern) {
        this.pattern = pattern;
    }

    public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String text = p.getText().trim();
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        if (text.matches("^\\d{1,13}")) {
            return GaeaDateUtils.timeMillisToDate(text);
        }
        TimeZone timeZone = StringUtils.isNotBlank((CharSequence)UserContentHolder.getTimeZone()) ? TimeZone.getTimeZone(UserContentHolder.getTimeZone()) : TimeZone.getDefault();
        if ("yyyy-MM".equals(this.pattern) || "yyyy-MM-dd".equals(this.pattern)) {
            return GaeaDateUtils.StringToDate(text, this.pattern);
        }
        return GaeaDateUtils.sourceTimeZoneToTargetTimeZone(text, this.pattern, timeZone, TimeZone.getDefault());
    }
}

