/*
 * Decompiled with CFR 0.152.
 */
package com.mixiaoxiao.fastscroll.helper;

import android.graphics.Canvas;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import com.mixiaoxiao.fastscroll.helper.ItemTouchHelperAdapter;
import com.mixiaoxiao.fastscroll.helper.ItemTouchHelperViewHolder;

public class SimpleItemTouchHelperCallback
extends ItemTouchHelper.Callback {
    public static final float ALPHA_FULL = 1.0f;
    private final ItemTouchHelperAdapter mAdapter;
    public Validator mValidator;

    public SimpleItemTouchHelperCallback(ItemTouchHelperAdapter adapter, Validator validator) {
        this.mAdapter = adapter;
        this.mValidator = validator;
    }

    public boolean isLongPressDragEnabled() {
        return false;
    }

    public boolean isItemViewSwipeEnabled() {
        return true;
    }

    private boolean isMovable(int position) {
        if (this.mValidator != null) {
            return this.mValidator.isMovable(position);
        }
        return false;
    }

    private boolean isSwipable(int position) {
        if (this.mValidator != null) {
            return this.mValidator.isSwipable(position);
        }
        return false;
    }

    public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        if (recyclerView.getLayoutManager() instanceof GridLayoutManager) {
            int dragFlags = this.isMovable(viewHolder.getAdapterPosition()) ? 15 : 0;
            boolean swipeFlags = false;
            return SimpleItemTouchHelperCallback.makeMovementFlags((int)dragFlags, (int)0);
        }
        int dragFlags = this.isMovable(viewHolder.getAdapterPosition()) ? 3 : 0;
        int swipeFlags = this.isSwipable(viewHolder.getAdapterPosition()) ? 48 : 0;
        return SimpleItemTouchHelperCallback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
    }

    public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder source, RecyclerView.ViewHolder target) {
        if (source.getItemViewType() != target.getItemViewType()) {
            return false;
        }
        this.mAdapter.onItemMove(source.getAdapterPosition(), target.getAdapterPosition());
        return true;
    }

    public void onSwiped(RecyclerView.ViewHolder viewHolder, int i) {
        this.mAdapter.onItemDismiss(viewHolder.getAdapterPosition());
    }

    public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        if (actionState == 1) {
            float alpha = 1.0f - Math.abs(dX) / (float)viewHolder.itemView.getWidth();
            viewHolder.itemView.setAlpha(alpha);
            viewHolder.itemView.setTranslationX(dX);
        } else {
            super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        }
    }

    public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
        if (actionState != 0 && viewHolder instanceof ItemTouchHelperViewHolder) {
            ItemTouchHelperViewHolder itemViewHolder = (ItemTouchHelperViewHolder)viewHolder;
            itemViewHolder.onItemSelected();
        }
        super.onSelectedChanged(viewHolder, actionState);
    }

    public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        super.clearView(recyclerView, viewHolder);
        viewHolder.itemView.setAlpha(1.0f);
        if (viewHolder instanceof ItemTouchHelperViewHolder) {
            ItemTouchHelperViewHolder itemViewHolder = (ItemTouchHelperViewHolder)viewHolder;
            itemViewHolder.onItemClear();
        }
    }

    public static interface Validator {
        public boolean isMovable(int var1);

        public boolean isSwipable(int var1);
    }
}

