/*
 * Decompiled with CFR 0.152.
 */
package com.mixiaoxiao.fastscroll.helper;

import android.content.Context;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.mixiaoxiao.fastscroll.FastScrollRecyclerView;

public class RecyclerListAdapter_SectionedGrid
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private final Context mContext;
    private static final int SECTION_TYPE = 0;
    private boolean mValid = true;
    private int mSectionResourceId;
    private SectionBinder mSectionBinder;
    private LayoutInflater mLayoutInflater;
    private RecyclerView.Adapter mBaseAdapter;
    public SparseArray<Section> mSections = new SparseArray();
    private FastScrollRecyclerView mRecyclerView;

    public RecyclerListAdapter_SectionedGrid(Context context, int sectionResourceId, FastScrollRecyclerView recyclerView, RecyclerView.Adapter baseAdapter, SectionBinder sectionBinder) {
        this.mLayoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mSectionResourceId = sectionResourceId;
        this.mBaseAdapter = baseAdapter;
        this.mContext = context;
        this.mRecyclerView = recyclerView;
        this.mSectionBinder = sectionBinder;
        this.mBaseAdapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                RecyclerListAdapter_SectionedGrid.this.mValid = RecyclerListAdapter_SectionedGrid.this.mBaseAdapter.getItemCount() > 0;
                RecyclerListAdapter_SectionedGrid.this.notifyDataSetChanged();
            }

            public void onItemRangeChanged(int positionStart, int itemCount) {
                RecyclerListAdapter_SectionedGrid.this.mValid = RecyclerListAdapter_SectionedGrid.this.mBaseAdapter.getItemCount() > 0;
                RecyclerListAdapter_SectionedGrid.this.notifyItemRangeChanged(positionStart, itemCount);
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                RecyclerListAdapter_SectionedGrid.this.mValid = RecyclerListAdapter_SectionedGrid.this.mBaseAdapter.getItemCount() > 0;
                RecyclerListAdapter_SectionedGrid.this.notifyItemRangeInserted(positionStart, itemCount);
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                RecyclerListAdapter_SectionedGrid.this.mValid = RecyclerListAdapter_SectionedGrid.this.mBaseAdapter.getItemCount() > 0;
                RecyclerListAdapter_SectionedGrid.this.notifyItemRangeRemoved(positionStart, itemCount);
            }
        });
        final GridLayoutManager layoutManager = (GridLayoutManager)this.mRecyclerView.getLayoutManager();
        layoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

            public int getSpanSize(int position) {
                return RecyclerListAdapter_SectionedGrid.this.isSectionHeaderPosition(position) ? layoutManager.getSpanCount() : 1;
            }
        });
        recyclerView.setAdapter(this);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int typeView) {
        if (typeView == 0) {
            View view = this.mLayoutInflater.inflate(this.mSectionResourceId, parent, false);
            return new SectionViewHolder(view);
        }
        return this.mBaseAdapter.onCreateViewHolder(parent, typeView - 1);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder sectionViewHolder, int position) {
        if (this.isSectionHeaderPosition(position)) {
            if (this.mSectionBinder != null) {
                this.mSectionBinder.onBindView(this, (SectionViewHolder)sectionViewHolder, position);
            }
        } else {
            this.mBaseAdapter.onBindViewHolder(sectionViewHolder, this.sectionedPositionToPosition(position));
        }
    }

    public int getItemViewType(int position) {
        return this.isSectionHeaderPosition(position) ? 0 : this.mBaseAdapter.getItemViewType(this.sectionedPositionToPosition(position)) + 1;
    }

    public void setSections(Section[] sections) {
        this.mSections.clear();
        int offset = 0;
        for (Section section : sections) {
            section.sectionedPosition = section.firstPosition + offset;
            this.mSections.append(section.sectionedPosition, (Object)section);
            ++offset;
        }
        this.notifyDataSetChanged();
    }

    public int positionToSectionedPosition(int position) {
        int offset = 0;
        for (int i = 0; i < this.mSections.size() && ((Section)this.mSections.valueAt((int)i)).firstPosition <= position; ++i) {
            ++offset;
        }
        return position + offset;
    }

    public int sectionedPositionToPosition(int sectionedPosition) {
        if (this.isSectionHeaderPosition(sectionedPosition)) {
            return -1;
        }
        int offset = 0;
        for (int i = 0; i < this.mSections.size() && ((Section)this.mSections.valueAt((int)i)).sectionedPosition <= sectionedPosition; ++i) {
            --offset;
        }
        return sectionedPosition + offset;
    }

    public boolean isSectionHeaderPosition(int position) {
        return this.mSections.get(position) != null;
    }

    public long getItemId(int position) {
        return this.isSectionHeaderPosition(position) ? (long)(Integer.MAX_VALUE - this.mSections.indexOfKey(position)) : this.mBaseAdapter.getItemId(this.sectionedPositionToPosition(position));
    }

    public int getItemCount() {
        return this.mValid ? this.mBaseAdapter.getItemCount() + this.mSections.size() : 0;
    }

    public static class SectionViewHolder
    extends RecyclerView.ViewHolder {
        public View mItemView;

        public SectionViewHolder(View view) {
            super(view);
            this.mItemView = view;
        }
    }

    public static class Section {
        int firstPosition;
        int sectionedPosition;
        CharSequence title;

        public Section(int firstPosition, CharSequence title) {
            this.firstPosition = firstPosition;
            this.title = title;
        }

        public CharSequence getTitle() {
            return this.title;
        }
    }

    public static interface SectionBinder {
        public void onBindView(RecyclerListAdapter_SectionedGrid var1, SectionViewHolder var2, int var3);
    }
}

