/*
 * Decompiled with CFR 0.152.
 */
package com.mixiaoxiao.fastscroll.helper;

import android.content.Context;
import android.graphics.PointF;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import java.util.HashSet;
import java.util.List;

public class FixedGridLayoutManager
extends RecyclerView.LayoutManager {
    private static final String TAG = FixedGridLayoutManager.class.getSimpleName();
    private static final int DEFAULT_COUNT = 1;
    private static final int REMOVE_VISIBLE = 0;
    private static final int REMOVE_INVISIBLE = 1;
    private static final int DIRECTION_NONE = -1;
    private static final int DIRECTION_START = 0;
    private static final int DIRECTION_END = 1;
    private static final int DIRECTION_UP = 2;
    private static final int DIRECTION_DOWN = 3;
    private int mFirstVisiblePosition;
    private int mDecoratedChildWidth;
    private int mDecoratedChildHeight;
    private int mTotalColumnCount = 1;
    private int mVisibleColumnCount;
    private int mVisibleRowCount;
    private int mFirstChangedPosition;
    private int mChangedPositionCount;

    public void setTotalColumnCount(int count) {
        this.mTotalColumnCount = count;
        this.requestLayout();
    }

    public boolean supportsPredictiveItemAnimations() {
        return true;
    }

    public void onItemsRemoved(RecyclerView recyclerView, int positionStart, int itemCount) {
        this.mFirstChangedPosition = positionStart;
        this.mChangedPositionCount = itemCount;
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        int childTop;
        int childLeft;
        if (this.getItemCount() == 0) {
            this.detachAndScrapAttachedViews(recycler);
            return;
        }
        if (this.getChildCount() == 0 && state.isPreLayout()) {
            return;
        }
        if (!state.isPreLayout()) {
            this.mChangedPositionCount = 0;
            this.mFirstChangedPosition = 0;
        }
        if (this.getChildCount() == 0) {
            View scrap = recycler.getViewForPosition(0);
            this.addView(scrap);
            this.measureChildWithMargins(scrap, 0, 0);
            this.mDecoratedChildWidth = this.getDecoratedMeasuredWidth(scrap);
            this.mDecoratedChildHeight = this.getDecoratedMeasuredHeight(scrap);
            this.detachAndScrapView(scrap, recycler);
        }
        this.updateWindowSizing();
        SparseIntArray removedCache = null;
        if (state.isPreLayout()) {
            int i;
            removedCache = new SparseIntArray(this.getChildCount());
            for (i = 0; i < this.getChildCount(); ++i) {
                View view = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)view.getLayoutParams();
                if (!lp.isItemRemoved()) continue;
                removedCache.put(lp.getViewLayoutPosition(), 0);
            }
            if (removedCache.size() == 0 && this.mChangedPositionCount > 0) {
                for (i = this.mFirstChangedPosition; i < this.mFirstChangedPosition + this.mChangedPositionCount; ++i) {
                    removedCache.put(i, 1);
                }
            }
        }
        if (this.getChildCount() == 0) {
            this.mFirstVisiblePosition = 0;
            childLeft = this.getPaddingLeft();
            childTop = this.getPaddingTop();
        } else if (!state.isPreLayout() && this.getVisibleChildCount() >= state.getItemCount()) {
            this.mFirstVisiblePosition = 0;
            childLeft = this.getPaddingLeft();
            childTop = this.getPaddingTop();
        } else {
            boolean isOutOfColBounds;
            View topChild = this.getChildAt(0);
            childLeft = this.getDecoratedLeft(topChild);
            childTop = this.getDecoratedTop(topChild);
            if (!state.isPreLayout() && this.getVerticalSpace() > this.getTotalRowCount() * this.mDecoratedChildHeight) {
                this.mFirstVisiblePosition %= this.getTotalColumnCount();
                childTop = this.getPaddingTop();
                if (this.mFirstVisiblePosition + this.mVisibleColumnCount > state.getItemCount()) {
                    this.mFirstVisiblePosition = Math.max(state.getItemCount() - this.mVisibleColumnCount, 0);
                    childLeft = this.getPaddingLeft();
                }
            }
            int maxFirstRow = this.getTotalRowCount() - (this.mVisibleRowCount - 1);
            int maxFirstCol = this.getTotalColumnCount() - (this.mVisibleColumnCount - 1);
            boolean isOutOfRowBounds = this.getFirstVisibleRow() > maxFirstRow;
            boolean bl = isOutOfColBounds = this.getFirstVisibleColumn() > maxFirstCol;
            if (isOutOfRowBounds || isOutOfColBounds) {
                int firstRow = isOutOfRowBounds ? maxFirstRow : this.getFirstVisibleRow();
                int firstCol = isOutOfColBounds ? maxFirstCol : this.getFirstVisibleColumn();
                this.mFirstVisiblePosition = firstRow * this.getTotalColumnCount() + firstCol;
                childLeft = this.getHorizontalSpace() - this.mDecoratedChildWidth * this.mVisibleColumnCount;
                childTop = this.getVerticalSpace() - this.mDecoratedChildHeight * this.mVisibleRowCount;
                if (this.getFirstVisibleRow() == 0) {
                    childTop = Math.min(childTop, this.getPaddingTop());
                }
                if (this.getFirstVisibleColumn() == 0) {
                    childLeft = Math.min(childLeft, this.getPaddingLeft());
                }
            }
        }
        this.detachAndScrapAttachedViews(recycler);
        this.fillGrid(-1, childLeft, childTop, recycler, state, removedCache);
        if (!state.isPreLayout() && !recycler.getScrapList().isEmpty()) {
            List scrapList = recycler.getScrapList();
            HashSet<View> disappearingViews = new HashSet<View>(scrapList.size());
            for (RecyclerView.ViewHolder holder : scrapList) {
                View child = holder.itemView;
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.isItemRemoved()) continue;
                disappearingViews.add(child);
            }
            for (View child : disappearingViews) {
                this.layoutDisappearingView(child);
            }
        }
    }

    public void onAdapterChanged(RecyclerView.Adapter oldAdapter, RecyclerView.Adapter newAdapter) {
        this.removeAllViews();
    }

    private void updateWindowSizing() {
        this.mVisibleColumnCount = this.getHorizontalSpace() / this.mDecoratedChildWidth + 1;
        if (this.getHorizontalSpace() % this.mDecoratedChildWidth > 0) {
            ++this.mVisibleColumnCount;
        }
        if (this.mVisibleColumnCount > this.getTotalColumnCount()) {
            this.mVisibleColumnCount = this.getTotalColumnCount();
        }
        this.mVisibleRowCount = this.getVerticalSpace() / this.mDecoratedChildHeight + 1;
        if (this.getVerticalSpace() % this.mDecoratedChildHeight > 0) {
            ++this.mVisibleRowCount;
        }
        if (this.mVisibleRowCount > this.getTotalRowCount()) {
            this.mVisibleRowCount = this.getTotalRowCount();
        }
    }

    private void fillGrid(int direction, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.fillGrid(direction, 0, 0, recycler, state, null);
    }

    private void fillGrid(int direction, int emptyLeft, int emptyTop, RecyclerView.Recycler recycler, RecyclerView.State state, SparseIntArray removedPositions) {
        int i;
        if (this.mFirstVisiblePosition < 0) {
            this.mFirstVisiblePosition = 0;
        }
        if (this.mFirstVisiblePosition >= this.getItemCount()) {
            this.mFirstVisiblePosition = this.getItemCount() - 1;
        }
        SparseArray viewCache = new SparseArray(this.getChildCount());
        int startLeftOffset = emptyLeft;
        int startTopOffset = emptyTop;
        if (this.getChildCount() != 0) {
            int i2;
            View topView = this.getChildAt(0);
            startLeftOffset = this.getDecoratedLeft(topView);
            startTopOffset = this.getDecoratedTop(topView);
            switch (direction) {
                case 0: {
                    startLeftOffset -= this.mDecoratedChildWidth;
                    break;
                }
                case 1: {
                    startLeftOffset += this.mDecoratedChildWidth;
                    break;
                }
                case 2: {
                    startTopOffset -= this.mDecoratedChildHeight;
                    break;
                }
                case 3: {
                    startTopOffset += this.mDecoratedChildHeight;
                }
            }
            for (i2 = 0; i2 < this.getChildCount(); ++i2) {
                int position = this.positionOfIndex(i2);
                View child = this.getChildAt(i2);
                viewCache.put(position, (Object)child);
            }
            for (i2 = 0; i2 < viewCache.size(); ++i2) {
                this.detachView((View)viewCache.valueAt(i2));
            }
        }
        switch (direction) {
            case 0: {
                --this.mFirstVisiblePosition;
                break;
            }
            case 1: {
                ++this.mFirstVisiblePosition;
                break;
            }
            case 2: {
                this.mFirstVisiblePosition -= this.getTotalColumnCount();
                break;
            }
            case 3: {
                this.mFirstVisiblePosition += this.getTotalColumnCount();
            }
        }
        int leftOffset = startLeftOffset;
        int topOffset = startTopOffset;
        for (i = 0; i < this.getVisibleChildCount(); ++i) {
            int nextPosition = this.positionOfIndex(i);
            int offsetPositionDelta = 0;
            if (state.isPreLayout()) {
                int offsetPosition = nextPosition;
                for (int offset = 0; offset < removedPositions.size(); ++offset) {
                    if (removedPositions.valueAt(offset) != 1 || removedPositions.keyAt(offset) >= nextPosition) continue;
                    --offsetPosition;
                }
                offsetPositionDelta = nextPosition - offsetPosition;
                nextPosition = offsetPosition;
            }
            if (nextPosition < 0 || nextPosition >= state.getItemCount()) continue;
            View view = (View)viewCache.get(nextPosition);
            if (view == null) {
                view = recycler.getViewForPosition(nextPosition);
                this.addView(view);
                if (!state.isPreLayout()) {
                    LayoutParams lp = (LayoutParams)view.getLayoutParams();
                    lp.row = this.getGlobalRowOfPosition(nextPosition);
                    lp.column = this.getGlobalColumnOfPosition(nextPosition);
                }
                this.measureChildWithMargins(view, 0, 0);
                this.layoutDecorated(view, leftOffset, topOffset, leftOffset + this.mDecoratedChildWidth, topOffset + this.mDecoratedChildHeight);
            } else {
                this.attachView(view);
                viewCache.remove(nextPosition);
            }
            if (i % this.mVisibleColumnCount == this.mVisibleColumnCount - 1) {
                leftOffset = startLeftOffset;
                topOffset += this.mDecoratedChildHeight;
                if (!state.isPreLayout()) continue;
                this.layoutAppearingViews(recycler, view, nextPosition, removedPositions.size(), offsetPositionDelta);
                continue;
            }
            leftOffset += this.mDecoratedChildWidth;
        }
        for (i = 0; i < viewCache.size(); ++i) {
            View removingView = (View)viewCache.valueAt(i);
            recycler.recycleView(removingView);
        }
    }

    public void scrollToPosition(int position) {
        if (position >= this.getItemCount()) {
            Log.e((String)TAG, (String)("Cannot scroll to " + position + ", item count is " + this.getItemCount()));
            return;
        }
        this.mFirstVisiblePosition = position;
        this.removeAllViews();
        this.requestLayout();
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        if (position >= this.getItemCount()) {
            Log.e((String)TAG, (String)("Cannot scroll to " + position + ", item count is " + this.getItemCount()));
            return;
        }
        LinearSmoothScroller scroller = new LinearSmoothScroller(recyclerView.getContext()){

            public PointF computeScrollVectorForPosition(int targetPosition) {
                int rowOffset = FixedGridLayoutManager.this.getGlobalRowOfPosition(targetPosition) - FixedGridLayoutManager.this.getGlobalRowOfPosition(FixedGridLayoutManager.this.mFirstVisiblePosition);
                int columnOffset = FixedGridLayoutManager.this.getGlobalColumnOfPosition(targetPosition) - FixedGridLayoutManager.this.getGlobalColumnOfPosition(FixedGridLayoutManager.this.mFirstVisiblePosition);
                return new PointF((float)(columnOffset * FixedGridLayoutManager.this.mDecoratedChildWidth), (float)(rowOffset * FixedGridLayoutManager.this.mDecoratedChildHeight));
            }
        };
        scroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)scroller);
    }

    public boolean canScrollHorizontally() {
        return true;
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        int delta;
        boolean rightBoundReached;
        if (this.getChildCount() == 0) {
            return 0;
        }
        View topView = this.getChildAt(0);
        View bottomView = this.getChildAt(this.mVisibleColumnCount - 1);
        int viewSpan = this.getDecoratedRight(bottomView) - this.getDecoratedLeft(topView);
        if (viewSpan < this.getHorizontalSpace()) {
            return 0;
        }
        boolean leftBoundReached = this.getFirstVisibleColumn() == 0;
        boolean bl = rightBoundReached = this.getLastVisibleColumn() >= this.getTotalColumnCount();
        if (dx > 0) {
            if (rightBoundReached) {
                int rightOffset = this.getHorizontalSpace() - this.getDecoratedRight(bottomView) + this.getPaddingRight();
                delta = Math.max(-dx, rightOffset);
            } else {
                delta = -dx;
            }
        } else if (leftBoundReached) {
            int leftOffset = -this.getDecoratedLeft(topView) + this.getPaddingLeft();
            delta = Math.min(-dx, leftOffset);
        } else {
            delta = -dx;
        }
        this.offsetChildrenHorizontal(delta);
        if (dx > 0) {
            if (this.getDecoratedRight(topView) < 0 && !rightBoundReached) {
                this.fillGrid(1, recycler, state);
            } else if (!rightBoundReached) {
                this.fillGrid(-1, recycler, state);
            }
        } else if (this.getDecoratedLeft(topView) > 0 && !leftBoundReached) {
            this.fillGrid(0, recycler, state);
        } else if (!leftBoundReached) {
            this.fillGrid(-1, recycler, state);
        }
        return -delta;
    }

    public boolean canScrollVertically() {
        return true;
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        int delta;
        boolean bottomBoundReached;
        if (this.getChildCount() == 0) {
            return 0;
        }
        View topView = this.getChildAt(0);
        View bottomView = this.getChildAt(this.getChildCount() - 1);
        int viewSpan = this.getDecoratedBottom(bottomView) - this.getDecoratedTop(topView);
        if (viewSpan < this.getVerticalSpace()) {
            return 0;
        }
        int maxRowCount = this.getTotalRowCount();
        boolean topBoundReached = this.getFirstVisibleRow() == 0;
        boolean bl = bottomBoundReached = this.getLastVisibleRow() >= maxRowCount;
        if (dy > 0) {
            if (bottomBoundReached) {
                int bottomOffset = this.rowOfIndex(this.getChildCount() - 1) >= maxRowCount - 1 ? this.getVerticalSpace() - this.getDecoratedBottom(bottomView) + this.getPaddingBottom() : this.getVerticalSpace() - (this.getDecoratedBottom(bottomView) + this.mDecoratedChildHeight) + this.getPaddingBottom();
                delta = Math.max(-dy, bottomOffset);
            } else {
                delta = -dy;
            }
        } else if (topBoundReached) {
            int topOffset = -this.getDecoratedTop(topView) + this.getPaddingTop();
            delta = Math.min(-dy, topOffset);
        } else {
            delta = -dy;
        }
        this.offsetChildrenVertical(delta);
        if (dy > 0) {
            if (this.getDecoratedBottom(topView) < 0 && !bottomBoundReached) {
                this.fillGrid(3, recycler, state);
            } else if (!bottomBoundReached) {
                this.fillGrid(-1, recycler, state);
            }
        } else if (this.getDecoratedTop(topView) > 0 && !topBoundReached) {
            this.fillGrid(2, recycler, state);
        } else if (!topBoundReached) {
            this.fillGrid(-1, recycler, state);
        }
        return -delta;
    }

    public View findViewByPosition(int position) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (this.positionOfIndex(i) != position) continue;
            return this.getChildAt(i);
        }
        return null;
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public RecyclerView.LayoutParams generateLayoutParams(Context c, AttributeSet attrs) {
        return new LayoutParams(c, attrs);
    }

    public RecyclerView.LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
        }
        return new LayoutParams(lp);
    }

    public boolean checkLayoutParams(RecyclerView.LayoutParams lp) {
        return lp instanceof LayoutParams;
    }

    private void layoutAppearingViews(RecyclerView.Recycler recycler, View referenceView, int referencePosition, int extraCount, int offset) {
        if (extraCount < 1) {
            return;
        }
        for (int extra = 1; extra <= extraCount; ++extra) {
            int extraPosition = referencePosition + extra;
            if (extraPosition < 0 || extraPosition >= this.getItemCount()) continue;
            View appearing = recycler.getViewForPosition(extraPosition);
            this.addView(appearing);
            int newRow = this.getGlobalRowOfPosition(extraPosition + offset);
            int rowDelta = newRow - this.getGlobalRowOfPosition(referencePosition + offset);
            int newCol = this.getGlobalColumnOfPosition(extraPosition + offset);
            int colDelta = newCol - this.getGlobalColumnOfPosition(referencePosition + offset);
            this.layoutTempChildView(appearing, rowDelta, colDelta, referenceView);
        }
    }

    private void layoutDisappearingView(View disappearingChild) {
        this.addDisappearingView(disappearingChild);
        LayoutParams lp = (LayoutParams)disappearingChild.getLayoutParams();
        int newRow = this.getGlobalRowOfPosition(lp.getViewAdapterPosition());
        int rowDelta = newRow - lp.row;
        int newCol = this.getGlobalColumnOfPosition(lp.getViewAdapterPosition());
        int colDelta = newCol - lp.column;
        this.layoutTempChildView(disappearingChild, rowDelta, colDelta, disappearingChild);
    }

    private void layoutTempChildView(View child, int rowDelta, int colDelta, View referenceView) {
        int layoutTop = this.getDecoratedTop(referenceView) + rowDelta * this.mDecoratedChildHeight;
        int layoutLeft = this.getDecoratedLeft(referenceView) + colDelta * this.mDecoratedChildWidth;
        this.measureChildWithMargins(child, 0, 0);
        this.layoutDecorated(child, layoutLeft, layoutTop, layoutLeft + this.mDecoratedChildWidth, layoutTop + this.mDecoratedChildHeight);
    }

    private int getGlobalColumnOfPosition(int position) {
        return position % this.mTotalColumnCount;
    }

    private int getGlobalRowOfPosition(int position) {
        return position / this.mTotalColumnCount;
    }

    private int positionOfIndex(int childIndex) {
        int row = childIndex / this.mVisibleColumnCount;
        int column = childIndex % this.mVisibleColumnCount;
        return this.mFirstVisiblePosition + row * this.getTotalColumnCount() + column;
    }

    private int rowOfIndex(int childIndex) {
        int position = this.positionOfIndex(childIndex);
        return position / this.getTotalColumnCount();
    }

    private int getFirstVisibleColumn() {
        return this.mFirstVisiblePosition % this.getTotalColumnCount();
    }

    private int getLastVisibleColumn() {
        return this.getFirstVisibleColumn() + this.mVisibleColumnCount;
    }

    private int getFirstVisibleRow() {
        return this.mFirstVisiblePosition / this.getTotalColumnCount();
    }

    private int getLastVisibleRow() {
        return this.getFirstVisibleRow() + this.mVisibleRowCount;
    }

    private int getVisibleChildCount() {
        return this.mVisibleColumnCount * this.mVisibleRowCount;
    }

    private int getTotalColumnCount() {
        if (this.getItemCount() < this.mTotalColumnCount) {
            return this.getItemCount();
        }
        return this.mTotalColumnCount;
    }

    private int getTotalRowCount() {
        if (this.getItemCount() == 0 || this.mTotalColumnCount == 0) {
            return 0;
        }
        int maxRow = this.getItemCount() / this.mTotalColumnCount;
        if (this.getItemCount() % this.mTotalColumnCount != 0) {
            ++maxRow;
        }
        return maxRow;
    }

    private int getHorizontalSpace() {
        return this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
    }

    private int getVerticalSpace() {
        return this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
    }

    public static class LayoutParams
    extends RecyclerView.LayoutParams {
        public int row;
        public int column;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(RecyclerView.LayoutParams source) {
            super(source);
        }
    }
}

