/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Ints;
import com.android.zipflinger.Source;
import com.android.zipflinger.ZipWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class LocalFileHeader {
    private static final int SIGNATURE = 67324752;
    public static final short DEFAULT_VERSION_NEEDED = 20;
    public static final int LOCAL_FILE_HEADER_SIZE = 30;
    public static final long VIRTUAL_HEADER_SIZE = 30L;
    public static final short COMPRESSION_NONE = 0;
    public static final short COMPRESSION_DEFLATE = 8;
    static final long VIRTUAL_ENTRY_MAX_SIZE = 65565L;
    static final long OFFSET_TO_NAME = 26L;
    private final byte[] nameBytes;
    private final short compressionFlag;
    private final int crc;
    private final long compressedSize;
    private final long uncompressedSize;
    private final int extraPadding;

    LocalFileHeader(byte[] nameBytes, short compressionFlag, int crc, long compressedSize, long uncompressedSize, int extraPadding) {
        this.nameBytes = nameBytes;
        this.compressionFlag = compressionFlag;
        this.crc = crc;
        this.compressedSize = compressedSize;
        this.uncompressedSize = uncompressedSize;
        this.extraPadding = extraPadding;
        if ((long)extraPadding > 65535L) {
            String err = String.format("Padding cannot be more than %s bytes", 65535L);
            throw new IllegalStateException(err);
        }
    }

    public static void fillVirtualEntry(ByteBuffer virtualEntry) {
        int sizeToFill = virtualEntry.capacity();
        if ((long)sizeToFill < 30L) {
            String message = String.format("Not enough space for virtual entry (%d)", sizeToFill);
            throw new IllegalStateException(message);
        }
        virtualEntry.order(ByteOrder.LITTLE_ENDIAN);
        virtualEntry.putInt(67324752);
        virtualEntry.putShort((short)20);
        virtualEntry.putShort((short)0);
        virtualEntry.putShort((short)0);
        virtualEntry.putShort((short)2081);
        virtualEntry.putShort((short)545);
        virtualEntry.putInt(0);
        virtualEntry.putInt(0);
        virtualEntry.putInt(0);
        virtualEntry.putShort((short)0);
        virtualEntry.putShort(Ints.intToUshort(virtualEntry.remaining() - 2));
        virtualEntry.rewind();
    }

    public void write(ZipWriter writer) throws IOException {
        ByteBuffer extraField = ByteBuffer.allocate(this.extraPadding);
        int bytesNeeded = 30 + this.nameBytes.length + extraField.capacity();
        ByteBuffer buffer = ByteBuffer.allocate(bytesNeeded).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(67324752);
        buffer.putShort((short)20);
        buffer.putShort((short)0);
        buffer.putShort(this.compressionFlag);
        buffer.putShort((short)2081);
        buffer.putShort((short)545);
        buffer.putInt(this.crc);
        buffer.putInt(Ints.longToUint(this.compressedSize));
        buffer.putInt(Ints.longToUint(this.uncompressedSize));
        buffer.putShort(Ints.intToUshort(this.nameBytes.length));
        buffer.putShort(Ints.intToUshort(extraField.capacity()));
        buffer.put(this.nameBytes);
        buffer.put(extraField);
        buffer.rewind();
        writer.write(buffer);
    }

    public static long sizeFor(Source source) {
        return 30 + source.getNameBytes().length;
    }
}

