/*
 * Decompiled with CFR 0.152.
 */
package com.log.kit.util;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;

public class MainHandler {
    private Handler mHandler = new Handler(Looper.getMainLooper());

    private MainHandler() {
    }

    public static MainHandler getInstance() {
        return SingleHolder.INSTANCE;
    }

    public void post(Runnable runnable) {
        this.mHandler.post(runnable);
    }

    public void postDelay(Long delayMills, Runnable runnable) {
        this.mHandler.postDelayed(runnable, delayMills.longValue());
    }

    public void sendAtFrontOfQueue(Runnable runnable) {
        Message message = Message.obtain((Handler)this.mHandler, (Runnable)runnable);
        this.mHandler.sendMessageAtFrontOfQueue(message);
    }

    public void remove(Runnable runnable) {
        this.mHandler.removeCallbacks(runnable);
    }

    private static class SingleHolder {
        public static volatile MainHandler INSTANCE = new MainHandler();

        private SingleHolder() {
        }
    }
}

