/*
 * Decompiled with CFR 0.152.
 */
package com.log.kit.print.view;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.log.kit.ILogConfig;
import com.log.kit.print.ILogPrinter;
import com.log.kit.print.view.ILogAdapter;
import com.log.kit.print.view.ILogModel;
import com.log.kit.print.view.IViewPrintProvider;
import com.log.kit.util.MainHandler;

public class IViewPrinter
implements ILogPrinter {
    private RecyclerView mRecyclerView;
    private ILogAdapter mAdapter;
    private final IViewPrintProvider mViewPrintProvider;

    public IViewPrinter(Activity activity) {
        FrameLayout rootView = (FrameLayout)activity.findViewById(0x1020002);
        this.mRecyclerView = new RecyclerView((Context)activity);
        this.mAdapter = new ILogAdapter(LayoutInflater.from((Context)this.mRecyclerView.getContext()));
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.mRecyclerView.getContext());
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mViewPrintProvider = new IViewPrintProvider(rootView, this.mRecyclerView, this.mAdapter);
    }

    @Override
    public void print(@NonNull ILogConfig config, final int level, final String tag, final @NonNull String printString) {
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                IViewPrinter.this.mAdapter.addItem(new ILogModel(System.currentTimeMillis(), level, tag, printString));
                IViewPrinter.this.mRecyclerView.smoothScrollToPosition(IViewPrinter.this.mAdapter.getItemCount() - 1);
            }
        });
    }

    public IViewPrintProvider getViewPrintProvider() {
        return this.mViewPrintProvider;
    }
}

