/*
 * Decompiled with CFR 0.152.
 */
package com.crash.kit;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.crash.kit.CrashKitManager;
import com.crash.kit.R;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/crash/kit/CrashLogActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "crashLogAdapter", "Lcom/crash/kit/CrashLogActivity$CrashLogAdapter;", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "", "menu", "Landroid/view/Menu;", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "CrashLogAdapter", "crash-kit_release"})
public final class CrashLogActivity
extends AppCompatActivity {
    private CrashLogAdapter crashLogAdapter;
    private HashMap _$_findViewCache;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_crash_log);
        File[] crashFiles = CrashKitManager.INSTANCE.crashFiles();
        ArrayList<File> list = new ArrayList<File>();
        for (File file : crashFiles) {
            list.add(file);
        }
        RecyclerView recyclerView = (RecyclerView)this._$_findCachedViewById(R.id.recycler_view);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"recycler_view");
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.crashLogAdapter = new CrashLogAdapter(list);
        RecyclerView recyclerView2 = (RecyclerView)this._$_findCachedViewById(R.id.recycler_view);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView2, (String)"recycler_view");
        recyclerView2.setAdapter((RecyclerView.Adapter)this.crashLogAdapter);
        DividerItemDecoration decoration = new DividerItemDecoration((Context)this, 1);
        Drawable drawable2 = ContextCompat.getDrawable((Context)((Context)this), (int)R.drawable.shape_divider);
        if (drawable2 == null) {
            Intrinsics.throwNpe();
        }
        decoration.setDrawable(drawable2);
        ((RecyclerView)this._$_findCachedViewById(R.id.recycler_view)).addItemDecoration((RecyclerView.ItemDecoration)decoration);
    }

    public boolean onCreateOptionsMenu(@Nullable Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_crash, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        int n = item.getItemId();
        if (n == R.id.delete) {
            CrashKitManager.INSTANCE.deleteFiles();
            CrashLogAdapter crashLogAdapter = this.crashLogAdapter;
            if (crashLogAdapter != null) {
                crashLogAdapter.clearData();
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0016R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/crash/kit/CrashLogActivity$CrashLogAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "crashFilesList", "Ljava/util/ArrayList;", "Ljava/io/File;", "Lkotlin/collections/ArrayList;", "(Lcom/crash/kit/CrashLogActivity;Ljava/util/ArrayList;)V", "getCrashFilesList", "()Ljava/util/ArrayList;", "clearData", "", "getItemCount", "", "onBindViewHolder", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "crash-kit_release"})
    public final class CrashLogAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        @NotNull
        private final ArrayList<File> crashFilesList;

        public int getItemCount() {
            return this.crashFilesList.size();
        }

        @NotNull
        public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
            Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
            return new RecyclerView.ViewHolder(this, parent, CrashLogActivity.this.getLayoutInflater().inflate(R.layout.activity_crash_log_list_item, parent, false)){
                final /* synthetic */ CrashLogAdapter this$0;
                final /* synthetic */ ViewGroup $parent;
                {
                    this.this$0 = $outer;
                    this.$parent = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            };
        }

        public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
            Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            File file = this.crashFilesList.get(position);
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"crashFilesList.get(position)");
            File file2 = file;
            View view = holder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"holder.itemView");
            TextView textView = (TextView)view.findViewById(R.id.file_title);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"holder.itemView.file_title");
            textView.setText((CharSequence)file2.getName());
            View view2 = holder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"holder.itemView");
            ((TextView)view2.findViewById(R.id.file_share)).setOnClickListener(new View.OnClickListener(this, file2){
                final /* synthetic */ CrashLogAdapter this$0;
                final /* synthetic */ File $file;

                public final void onClick(View it) {
                    Intent intent = new Intent("android.intent.action.SEND");
                    intent.putExtra("subject", "");
                    intent.putExtra("body", "");
                    Uri uri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)((Context)this.this$0.CrashLogActivity.this), (String)(this.this$0.CrashLogActivity.this.getPackageName() + ".fileProvider"), (File)this.$file) : Uri.fromFile((File)this.$file);
                    intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
                    String string = this.$file.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
                    if (StringsKt.endsWith$default((String)string, (String)".txt", (boolean)false, (int)2, null)) {
                        intent.setType("text/plain");
                    } else {
                        intent.setType("application/octet-stream");
                    }
                    this.this$0.CrashLogActivity.this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"\u5206\u4eabCrash \u65e5\u5fd7\u6587\u4ef6"));
                }
                {
                    this.this$0 = crashLogAdapter;
                    this.$file = file;
                }
            });
        }

        public final void clearData() {
            this.crashFilesList.clear();
            this.notifyDataSetChanged();
        }

        @NotNull
        public final ArrayList<File> getCrashFilesList() {
            return this.crashFilesList;
        }

        public CrashLogAdapter(ArrayList<File> crashFilesList) {
            Intrinsics.checkParameterIsNotNull(crashFilesList, (String)"crashFilesList");
            this.crashFilesList = crashFilesList;
        }
    }
}

