/*
 * Decompiled with CFR 0.152.
 */
package com.cc.rnbridge.util;

import android.os.Bundle;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.cc.rnbridge.util.RNArrayUtil;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableMap;
import java.util.HashMap;
import java.util.Map;

public class RNMapUtil {
    public static JSONObject toJSONObject(ReadableMap readableMap) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        ReadableMapKeySetIterator iterator = readableMap.keySetIterator();
        while (iterator.hasNextKey()) {
            String key = iterator.nextKey();
            ReadableType type = readableMap.getType(key);
            switch (type) {
                case Null: {
                    jsonObject.put(key, null);
                    break;
                }
                case Boolean: {
                    jsonObject.put(key, (Object)readableMap.getBoolean(key));
                    break;
                }
                case Number: {
                    jsonObject.put(key, (Object)readableMap.getDouble(key));
                    break;
                }
                case String: {
                    jsonObject.put(key, (Object)readableMap.getString(key));
                    break;
                }
                case Map: {
                    jsonObject.put(key, (Object)RNMapUtil.toJSONObject(readableMap.getMap(key)));
                    break;
                }
                case Array: {
                    jsonObject.put(key, (Object)RNArrayUtil.toJSONArray(readableMap.getArray(key)));
                }
            }
        }
        return jsonObject;
    }

    public static Map<String, Object> toMap(JSONObject jsonObject) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : jsonObject.keySet()) {
            Object[] value = jsonObject.get((Object)key);
            if (value instanceof JSONObject) {
                value = RNMapUtil.toMap((JSONObject)value);
            }
            if (value instanceof JSONArray) {
                value = RNArrayUtil.toArray((JSONArray)value);
            }
            map.put(key, value);
        }
        return map;
    }

    public static <T> WritableMap toWritableMap(Object object) {
        if (object != null) {
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)object));
            return RNMapUtil.toWritableMap(RNMapUtil.toMap(jsonObject));
        }
        return Arguments.createMap();
    }

    public static WritableMap toWritableMap(Bundle bundle) {
        return Arguments.fromBundle((Bundle)bundle);
    }

    public static WritableMap toWritableMap(Map<String, Object> objects) {
        return Arguments.makeNativeMap(objects);
    }

    public static Bundle toBundle(ReadableMap writableMap) {
        return Arguments.toBundle((ReadableMap)writableMap);
    }

    public static Map<String, Object> toMap(ReadableMap writableMap) {
        return writableMap.toHashMap();
    }
}

