/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.view;

import android.content.Context;
import android.support.design.widget.Snackbar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.liujc.baseutils.R;
import java.lang.ref.WeakReference;

public class SnackbarUtil {
    private static WeakReference<Snackbar> snackbarWeakReference;

    private SnackbarUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void showShortSnackbar(View parent, CharSequence text, int textColor, int bgColor) {
        SnackbarUtil.showSnackbar(parent, text, -1, textColor, bgColor, null, -1, null);
    }

    public static void showShortSnackbar(View parent, CharSequence text, int textColor, int bgColor, CharSequence actionText, int actionTextColor, View.OnClickListener listener) {
        SnackbarUtil.showSnackbar(parent, text, -1, textColor, bgColor, actionText, actionTextColor, listener);
    }

    public static void showLongSnackbar(View parent, CharSequence text, int textColor, int bgColor) {
        SnackbarUtil.showSnackbar(parent, text, 0, textColor, bgColor, null, -1, null);
    }

    public static void showLongSnackbar(View parent, CharSequence text, int textColor, int bgColor, CharSequence actionText, int actionTextColor, View.OnClickListener listener) {
        SnackbarUtil.showSnackbar(parent, text, 0, textColor, bgColor, actionText, actionTextColor, listener);
    }

    public static void showIndefiniteSnackbar(View parent, CharSequence text, int duration, int textColor, int bgColor) {
        SnackbarUtil.showSnackbar(parent, text, duration, textColor, bgColor, null, -1, null);
    }

    public static void showIndefiniteSnackbar(View parent, CharSequence text, int duration, int textColor, int bgColor, CharSequence actionText, int actionTextColor, View.OnClickListener listener) {
        SnackbarUtil.showSnackbar(parent, text, duration, textColor, bgColor, actionText, actionTextColor, listener);
    }

    private static void showSnackbar(View parent, CharSequence text, int duration, int textColor, int bgColor, CharSequence actionText, int actionTextColor, View.OnClickListener listener) {
        switch (duration) {
            default: {
                snackbarWeakReference = new WeakReference<Snackbar>(Snackbar.make((View)parent, (CharSequence)text, (int)duration));
                break;
            }
            case -2: {
                snackbarWeakReference = new WeakReference<Snackbar>(Snackbar.make((View)parent, (CharSequence)text, (int)-2).setDuration(duration));
            }
        }
        View view = ((Snackbar)snackbarWeakReference.get()).getView();
        ((TextView)view.findViewById(R.id.snackbar_text)).setTextColor(textColor);
        view.setBackgroundColor(bgColor);
        if (actionText != null && actionText.length() > 0 && listener != null) {
            ((Snackbar)snackbarWeakReference.get()).setActionTextColor(actionTextColor);
            ((Snackbar)snackbarWeakReference.get()).setAction(actionText, listener);
        }
        ((Snackbar)snackbarWeakReference.get()).show();
    }

    public static void addView(int layoutId, int index) {
        Snackbar snackbar = (Snackbar)snackbarWeakReference.get();
        if (snackbar != null) {
            View view = snackbar.getView();
            Snackbar.SnackbarLayout layout = (Snackbar.SnackbarLayout)view;
            View child = LayoutInflater.from((Context)view.getContext()).inflate(layoutId, null);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            params.gravity = 16;
            layout.addView(child, index, (ViewGroup.LayoutParams)params);
        }
    }

    public static void dismissSnackbar() {
        if (snackbarWeakReference != null && snackbarWeakReference.get() != null) {
            ((Snackbar)snackbarWeakReference.get()).dismiss();
            snackbarWeakReference = null;
        }
    }
}

