/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Dimension;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import com.liujc.baseutils.view.SelectorFactory;

public class SelectorFactory {
    public static ShapeSelector newShapeSelector() {
        return new ShapeSelector();
    }

    public static ColorSelector newColorSelector() {
        return new ColorSelector();
    }

    public static GeneralSelector newGeneralSelector() {
        return new GeneralSelector();
    }

    public static final class GeneralSelector {
        private Drawable mDefaultDrawable = new ColorDrawable(0);
        private Drawable mDisabledDrawable;
        private Drawable mPressedDrawable;
        private Drawable mSelectedDrawable;
        private Drawable mFocusedDrawable;
        private boolean hasSetDisabledDrawable = false;
        private boolean hasSetPressedDrawable = false;
        private boolean hasSetSelectedDrawable = false;
        private boolean hasSetFocusedDrawable = false;

        private GeneralSelector() {
        }

        public GeneralSelector setDefaultDrawable(Drawable drawable2) {
            this.mDefaultDrawable = drawable2;
            if (!this.hasSetDisabledDrawable) {
                this.mDisabledDrawable = drawable2;
            }
            if (!this.hasSetPressedDrawable) {
                this.mPressedDrawable = drawable2;
            }
            if (!this.hasSetSelectedDrawable) {
                this.mSelectedDrawable = drawable2;
            }
            if (!this.hasSetFocusedDrawable) {
                this.mFocusedDrawable = drawable2;
            }
            return this;
        }

        public GeneralSelector setDisabledDrawable(Drawable drawable2) {
            this.mDisabledDrawable = drawable2;
            this.hasSetDisabledDrawable = true;
            return this;
        }

        public GeneralSelector setPressedDrawable(Drawable drawable2) {
            this.mPressedDrawable = drawable2;
            this.hasSetPressedDrawable = true;
            return this;
        }

        public GeneralSelector setSelectedDrawable(Drawable drawable2) {
            this.mSelectedDrawable = drawable2;
            this.hasSetSelectedDrawable = true;
            return this;
        }

        public GeneralSelector setFocusedDrawable(Drawable drawable2) {
            this.mFocusedDrawable = drawable2;
            this.hasSetFocusedDrawable = true;
            return this;
        }

        public StateListDrawable create() {
            StateListDrawable selector = new StateListDrawable();
            if (this.hasSetDisabledDrawable) {
                selector.addState(new int[]{-16842910}, this.mDisabledDrawable);
            }
            if (this.hasSetPressedDrawable) {
                selector.addState(new int[]{16842919}, this.mPressedDrawable);
            }
            if (this.hasSetSelectedDrawable) {
                selector.addState(new int[]{0x10100A1}, this.mSelectedDrawable);
            }
            if (this.hasSetFocusedDrawable) {
                selector.addState(new int[]{16842908}, this.mFocusedDrawable);
            }
            selector.addState(new int[0], this.mDefaultDrawable);
            return selector;
        }

        public GeneralSelector setDefaultDrawable(Context context, @DrawableRes int drawableRes) {
            return this.setDefaultDrawable(ContextCompat.getDrawable((Context)context, (int)drawableRes));
        }

        public GeneralSelector setDisabledDrawable(Context context, @DrawableRes int drawableRes) {
            return this.setDisabledDrawable(ContextCompat.getDrawable((Context)context, (int)drawableRes));
        }

        public GeneralSelector setPressedDrawable(Context context, @DrawableRes int drawableRes) {
            return this.setPressedDrawable(ContextCompat.getDrawable((Context)context, (int)drawableRes));
        }

        public GeneralSelector setSelectedDrawable(Context context, @DrawableRes int drawableRes) {
            return this.setSelectedDrawable(ContextCompat.getDrawable((Context)context, (int)drawableRes));
        }

        public GeneralSelector setFocusedDrawable(Context context, @DrawableRes int drawableRes) {
            return this.setFocusedDrawable(ContextCompat.getDrawable((Context)context, (int)drawableRes));
        }
    }

    public static final class ColorSelector {
        private int mDefaultColor = -16777216;
        private int mDisabledColor = -7829368;
        private int mPressedColor = -16777216;
        private int mSelectedColor = -16777216;
        private int mFocusedColor = -16777216;
        private boolean hasSetDisabledColor = false;
        private boolean hasSetPressedColor = false;
        private boolean hasSetSelectedColor = false;
        private boolean hasSetFocusedColor = false;

        private ColorSelector() {
        }

        public ColorSelector setDefaultColor(@ColorInt int color) {
            this.mDefaultColor = color;
            if (!this.hasSetDisabledColor) {
                this.mDisabledColor = color;
            }
            if (!this.hasSetPressedColor) {
                this.mPressedColor = color;
            }
            if (!this.hasSetSelectedColor) {
                this.mSelectedColor = color;
            }
            if (!this.hasSetFocusedColor) {
                this.mFocusedColor = color;
            }
            return this;
        }

        public ColorSelector setDisabledColor(@ColorInt int color) {
            this.mDisabledColor = color;
            this.hasSetDisabledColor = true;
            return this;
        }

        public ColorSelector setPressedColor(@ColorInt int color) {
            this.mPressedColor = color;
            this.hasSetPressedColor = true;
            return this;
        }

        public ColorSelector setSelectedColor(@ColorInt int color) {
            this.mSelectedColor = color;
            this.hasSetSelectedColor = true;
            return this;
        }

        public ColorSelector setFocusedColor(@ColorInt int color) {
            this.mFocusedColor = color;
            this.hasSetFocusedColor = true;
            return this;
        }

        public ColorStateList create() {
            int[] colors = new int[]{this.hasSetDisabledColor ? this.mDisabledColor : this.mDefaultColor, this.hasSetPressedColor ? this.mPressedColor : this.mDefaultColor, this.hasSetSelectedColor ? this.mSelectedColor : this.mDefaultColor, this.hasSetFocusedColor ? this.mFocusedColor : this.mDefaultColor, this.mDefaultColor};
            int[][] states = new int[][]{{-16842910}, {16842919}, {0x10100A1}, {16842908}, new int[0]};
            return new ColorStateList((int[][])states, colors);
        }
    }

    public static final class ShapeSelector {
        private int mShape = 0;
        private int mDefaultBgColor = 0;
        private int mDisabledBgColor = 0;
        private int mPressedBgColor = 0;
        private int mSelectedBgColor = 0;
        private int mFocusedBgColor = 0;
        private int mStrokeWidth = 0;
        private int mDefaultStrokeColor = 0;
        private int mDisabledStrokeColor = 0;
        private int mPressedStrokeColor = 0;
        private int mSelectedStrokeColor = 0;
        private int mFocusedStrokeColor = 0;
        private int mCornerRadius = 0;
        private boolean hasSetDisabledBgColor = false;
        private boolean hasSetPressedBgColor = false;
        private boolean hasSetSelectedBgColor = false;
        private boolean hasSetFocusedBgColor = false;
        private boolean hasSetDisabledStrokeColor = false;
        private boolean hasSetPressedStrokeColor = false;
        private boolean hasSetSelectedStrokeColor = false;
        private boolean hasSetFocusedStrokeColor = false;

        private ShapeSelector() {
        }

        public ShapeSelector setShape(@Shape int shape) {
            this.mShape = shape;
            return this;
        }

        public ShapeSelector setDefaultBgColor(@ColorInt int color) {
            this.mDefaultBgColor = color;
            if (!this.hasSetDisabledBgColor) {
                this.mDisabledBgColor = color;
            }
            if (!this.hasSetPressedBgColor) {
                this.mPressedBgColor = color;
            }
            if (!this.hasSetSelectedBgColor) {
                this.mSelectedBgColor = color;
            }
            if (!this.hasSetFocusedBgColor) {
                this.mFocusedBgColor = color;
            }
            return this;
        }

        public ShapeSelector setDisabledBgColor(@ColorInt int color) {
            this.mDisabledBgColor = color;
            this.hasSetDisabledBgColor = true;
            return this;
        }

        public ShapeSelector setPressedBgColor(@ColorInt int color) {
            this.mPressedBgColor = color;
            this.hasSetPressedBgColor = true;
            return this;
        }

        public ShapeSelector setSelectedBgColor(@ColorInt int color) {
            this.mSelectedBgColor = color;
            this.hasSetSelectedBgColor = true;
            return this;
        }

        public ShapeSelector setFocusedBgColor(@ColorInt int color) {
            this.mFocusedBgColor = color;
            this.hasSetPressedBgColor = true;
            return this;
        }

        public ShapeSelector setStrokeWidth(@Dimension int width) {
            this.mStrokeWidth = width;
            return this;
        }

        public ShapeSelector setDefaultStrokeColor(@ColorInt int color) {
            this.mDefaultStrokeColor = color;
            if (!this.hasSetDisabledStrokeColor) {
                this.mDisabledStrokeColor = color;
            }
            if (!this.hasSetPressedStrokeColor) {
                this.mPressedStrokeColor = color;
            }
            if (!this.hasSetSelectedStrokeColor) {
                this.mSelectedStrokeColor = color;
            }
            if (!this.hasSetFocusedStrokeColor) {
                this.mFocusedStrokeColor = color;
            }
            return this;
        }

        public ShapeSelector setDisabledStrokeColor(@ColorInt int color) {
            this.mDisabledStrokeColor = color;
            this.hasSetDisabledStrokeColor = true;
            return this;
        }

        public ShapeSelector setPressedStrokeColor(@ColorInt int color) {
            this.mPressedStrokeColor = color;
            this.hasSetPressedStrokeColor = true;
            return this;
        }

        public ShapeSelector setSelectedStrokeColor(@ColorInt int color) {
            this.mSelectedStrokeColor = color;
            this.hasSetSelectedStrokeColor = true;
            return this;
        }

        public ShapeSelector setFocusedStrokeColor(@ColorInt int color) {
            this.mFocusedStrokeColor = color;
            this.hasSetFocusedStrokeColor = true;
            return this;
        }

        public ShapeSelector setCornerRadius(@Dimension int radius) {
            this.mCornerRadius = radius;
            return this;
        }

        public StateListDrawable create() {
            StateListDrawable selector = new StateListDrawable();
            if (this.hasSetDisabledBgColor || this.hasSetDisabledStrokeColor) {
                GradientDrawable disabledShape = this.getItemShape(this.mShape, this.mCornerRadius, this.mDisabledBgColor, this.mStrokeWidth, this.mDisabledStrokeColor);
                selector.addState(new int[]{-16842910}, (Drawable)disabledShape);
            }
            if (this.hasSetPressedBgColor || this.hasSetPressedStrokeColor) {
                GradientDrawable pressedShape = this.getItemShape(this.mShape, this.mCornerRadius, this.mPressedBgColor, this.mStrokeWidth, this.mPressedStrokeColor);
                selector.addState(new int[]{16842919}, (Drawable)pressedShape);
            }
            if (this.hasSetSelectedBgColor || this.hasSetSelectedStrokeColor) {
                GradientDrawable selectedShape = this.getItemShape(this.mShape, this.mCornerRadius, this.mSelectedBgColor, this.mStrokeWidth, this.mSelectedStrokeColor);
                selector.addState(new int[]{0x10100A1}, (Drawable)selectedShape);
            }
            if (this.hasSetFocusedBgColor || this.hasSetFocusedStrokeColor) {
                GradientDrawable focusedShape = this.getItemShape(this.mShape, this.mCornerRadius, this.mFocusedBgColor, this.mStrokeWidth, this.mFocusedStrokeColor);
                selector.addState(new int[]{16842908}, (Drawable)focusedShape);
            }
            GradientDrawable defaultShape = this.getItemShape(this.mShape, this.mCornerRadius, this.mDefaultBgColor, this.mStrokeWidth, this.mDefaultStrokeColor);
            selector.addState(new int[0], (Drawable)defaultShape);
            return selector;
        }

        private GradientDrawable getItemShape(int shape, int cornerRadius, int solidColor, int strokeWidth, int strokeColor) {
            GradientDrawable drawable2 = new GradientDrawable();
            drawable2.setShape(shape);
            drawable2.setStroke(strokeWidth, strokeColor);
            drawable2.setCornerRadius((float)cornerRadius);
            drawable2.setColor(solidColor);
            return drawable2;
        }
    }
}

