/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.view;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.liujc.baseutils.common.LogUtil;
import java.util.ArrayList;

public class NotificationUtil {
    private static int LedID = 0;

    public static void notification(Context context, Uri uri, int icon, String ticker, String title, String msg) {
        LogUtil.d("notiry uri :" + uri);
        Intent intent = new Intent();
        if (Build.VERSION.SDK_INT >= 4) {
            intent.setPackage(context.getPackageName());
        }
        intent.setData(uri);
        NotificationUtil.notification(context, intent, 0, icon, ticker, title, msg);
    }

    public static void notification(Context context, String activityClass, Bundle bundle, int icon, String ticker, String title, String msg) {
        Intent intent = new Intent();
        if (Build.VERSION.SDK_INT >= 4) {
            intent.setPackage(context.getPackageName());
        }
        intent.putExtras(bundle);
        intent.setComponent(new ComponentName(context.getPackageName(), activityClass));
        NotificationUtil.notification(context, intent, 0, icon, ticker, title, msg);
    }

    public static void notification(Context context, Intent intent, int id, int icon, String ticker, String title, String msg) {
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        NotificationUtil.notification(context, pendingIntent, id, icon, ticker, title, msg);
    }

    public static void notification(Context context, PendingIntent pendingIntent, int id, int icon, String ticker, String title, String msg) {
        if (Build.VERSION.SDK_INT >= 11) {
            Notification.Builder builder = new Notification.Builder(context);
            builder.setSmallIcon(icon);
            builder.setContentTitle((CharSequence)title);
            builder.setTicker((CharSequence)ticker);
            builder.setContentText((CharSequence)msg);
            builder.setDefaults(1);
            builder.setLights(-256, 0, 2000);
            builder.setVibrate(new long[]{0L, 100L, 300L});
            builder.setAutoCancel(true);
            builder.setContentIntent(pendingIntent);
            Notification baseNF = Build.VERSION.SDK_INT < 16 ? builder.getNotification() : builder.build();
            NotificationManager nm = (NotificationManager)context.getSystemService("notification");
            nm.notify(id, baseNF);
        } else {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            Notification notification = new Notification(icon, (CharSequence)ticker, System.currentTimeMillis());
            notification.flags |= 3;
            notification.defaults = -1;
            notification.ledARGB = -16711936;
            notification.ledOnMS = 5000;
            notification.tickerText = ticker;
            notificationManager.notify(id, notification);
        }
    }

    public static void lightLed(Context context, int colorOx, int durationMS) {
        NotificationUtil.lightLed(context, colorOx, 0, durationMS);
    }

    public static void lightLed(Context context, int colorOx, int startOffMS, int durationMS) {
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        Notification notification = new Notification();
        notification.ledARGB = colorOx;
        notification.ledOffMS = startOffMS;
        notification.ledOnMS = durationMS;
        notification.flags = 1;
        nm.notify(++LedID, notification);
        nm.cancel(LedID);
    }

    public static void lightLed(final Context context, final int colorOx, final int startOffMS, final int durationMS, int repeat) {
        if (repeat < 1) {
            repeat = 1;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        for (int i = 0; i < repeat; ++i) {
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    NotificationUtil.lightLed(context, colorOx, startOffMS, durationMS);
                }
            }, (long)((startOffMS + durationMS) * i));
        }
    }

    public static void lightLed(Context context, ArrayList<LightPattern> patterns) {
        if (patterns == null) {
            return;
        }
        for (LightPattern lp : patterns) {
            NotificationUtil.lightLed(context, lp.argb, lp.startOffMS, lp.durationMS);
        }
    }

    public static class LightPattern {
        public int argb = 0;
        public int startOffMS = 0;
        public int durationMS = 0;

        public LightPattern(int argb, int startOffMS, int durationMS) {
            this.argb = argb;
            this.startOffMS = startOffMS;
            this.durationMS = durationMS;
        }
    }
}

