/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.support.design.widget.TabLayout;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.LinearLayout;

public class DisplayUtil {
    private static onGetSizeListener mListener;

    private DisplayUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dp(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int px2sp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static float applyDimension(int unit, float value, DisplayMetrics metrics) {
        switch (unit) {
            case 0: {
                return value;
            }
            case 1: {
                return value * metrics.density;
            }
            case 2: {
                return value * metrics.scaledDensity;
            }
            case 3: {
                return value * metrics.xdpi * 0.013888889f;
            }
            case 4: {
                return value * metrics.xdpi;
            }
            case 5: {
                return value * metrics.xdpi * 0.03937008f;
            }
        }
        return 0.0f;
    }

    public static int[] getWidgetWH(final View view) {
        ViewTreeObserver vto2 = view.getViewTreeObserver();
        vto2.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
        return new int[]{view.getWidth(), view.getHeight()};
    }

    public static int getViewHeight(final View view) {
        ViewTreeObserver vto2 = view.getViewTreeObserver();
        vto2.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
        return view.getHeight();
    }

    public static int getViewWidth(final View view) {
        ViewTreeObserver vto2 = view.getViewTreeObserver();
        vto2.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
        return view.getWidth();
    }

    public static int getScreenWidth(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.widthPixels;
    }

    public static int getScreenHeight(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.heightPixels;
    }

    public static int getStatusBarHeight(Context context) {
        int statusBarHeight = -1;
        try {
            Class<?> clazz = Class.forName("com.android.internal.R$dimen");
            Object object = clazz.newInstance();
            int height = Integer.parseInt(clazz.getField("status_bar_height").get(object).toString());
            statusBarHeight = context.getResources().getDimensionPixelSize(height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statusBarHeight;
    }

    public static int getWidgetWidth(View view) {
        int w = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int h = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(w, h);
        int width = view.getMeasuredWidth();
        return width;
    }

    public static int getWidgetHeight(View view) {
        int w = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int h = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(w, h);
        int height = view.getMeasuredHeight();
        return height;
    }

    public static void setWidgetWidth(View view, int width) {
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
        params.width = width;
        view.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public static void setWidgetHeight(View view, int height) {
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
        params.height = height;
        view.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public static Bitmap snapShotWithStatusBar(Activity activity) {
        View view = activity.getWindow().getDecorView();
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bmp = view.getDrawingCache();
        int width = DisplayUtil.getScreenWidth((Context)activity);
        int height = DisplayUtil.getScreenHeight((Context)activity);
        Bitmap bp = null;
        bp = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)width, (int)height);
        view.destroyDrawingCache();
        return bp;
    }

    public static Bitmap snapShotWithoutStatusBar(Activity activity) {
        View view = activity.getWindow().getDecorView();
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bmp = view.getDrawingCache();
        Rect frame = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(frame);
        int statusBarHeight = frame.top;
        int width = DisplayUtil.getScreenWidth((Context)activity);
        int height = DisplayUtil.getScreenHeight((Context)activity);
        Bitmap bp = null;
        bp = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)statusBarHeight, (int)width, (int)(height - statusBarHeight));
        view.destroyDrawingCache();
        return bp;
    }

    public static void dynamicSetTabLayoutMode(Context context, TabLayout tabLayout) {
        int screenWidth;
        int tabWidth = DisplayUtil.calculateTabWidth(tabLayout);
        if (tabWidth <= (screenWidth = DisplayUtil.getScreenWidth(context))) {
            tabLayout.setTabMode(1);
        } else {
            tabLayout.setTabMode(0);
        }
    }

    private static int calculateTabWidth(TabLayout tabLayout) {
        int tabWidth = 0;
        for (int i = 0; i < tabLayout.getChildCount(); ++i) {
            View view = tabLayout.getChildAt(i);
            view.measure(0, 0);
            tabWidth += view.getMeasuredWidth();
        }
        return tabWidth;
    }

    public static void forceGetViewSize(final View view, final onGetSizeListener listener) {
        view.post(new Runnable(){

            @Override
            public void run() {
                if (listener != null) {
                    listener.onGetSize(view);
                }
            }
        });
    }

    public static void setListener(onGetSizeListener listener) {
        mListener = listener;
    }

    public static interface onGetSizeListener {
        public void onGetSize(View var1);
    }
}

