/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.view;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.Html;
import android.view.View;

public class DialogUtil {
    public static AlertDialog.Builder dialogBuilder(Context context, String title, String msg) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        if (msg != null) {
            builder.setMessage((CharSequence)msg);
        }
        if (title != null) {
            builder.setTitle((CharSequence)title);
        }
        return builder;
    }

    public static AlertDialog.Builder dialogBuilder(Context context, String title, String msg, int i) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        if (msg != null) {
            builder.setMessage((CharSequence)Html.fromHtml((String)msg));
        }
        if (title != null) {
            builder.setTitle((CharSequence)title);
        }
        return builder;
    }

    public static AlertDialog.Builder dialogBuilder(Context context, int title, View view) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        if (view != null) {
            builder.setView(view);
        }
        if (title > 0) {
            builder.setTitle(title);
        }
        return builder;
    }

    public static AlertDialog.Builder dialogBuilder(Context context, int titleResId, int msgResId) {
        String title = titleResId > 0 ? context.getResources().getString(titleResId) : null;
        String msg = msgResId > 0 ? context.getResources().getString(msgResId) : null;
        return DialogUtil.dialogBuilder(context, title, msg);
    }

    public static Dialog showTips(Context context, String title, String des) {
        return DialogUtil.showTips(context, title, des, null, null);
    }

    public static Dialog showTips(Context context, int title, int des) {
        return DialogUtil.showTips(context, context.getString(title), context.getString(des));
    }

    public static Dialog showTips(Context context, int title, int des, int btn, DialogInterface.OnDismissListener dismissListener) {
        return DialogUtil.showTips(context, context.getString(title), context.getString(des), context.getString(btn), dismissListener);
    }

    public static Dialog showTips(Context context, String title, String des, String btn, DialogInterface.OnDismissListener dismissListener) {
        AlertDialog.Builder builder = DialogUtil.dialogBuilder(context, title, des);
        builder.setCancelable(true);
        builder.setPositiveButton((CharSequence)btn, null);
        AlertDialog dialog = builder.show();
        dialog.setCanceledOnTouchOutside(true);
        dialog.setOnDismissListener(dismissListener);
        return dialog;
    }
}

