/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.view;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.liujc.baseutils.common.LogUtil;
import com.liujc.baseutils.system.IntentUtil;
import java.util.List;
import java.util.Stack;

public class ActivityUtil {
    private Context context;
    private static ActivityUtil activityManager;
    private static Stack<Activity> activityStack;

    private ActivityUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActivityUtil getActivityManager(Context context) {
        if (activityManager != null) return activityManager;
        Class<ActivityUtil> clazz = ActivityUtil.class;
        synchronized (ActivityUtil.class) {
            if (activityManager != null) return activityManager;
            activityManager = new ActivityUtil(context);
            activityStack = new Stack();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return activityManager;
        }
    }

    private ActivityUtil(Context context) {
        this.context = context;
    }

    public static boolean isActivityExists(Context context, String packageName, String className) {
        Intent intent = new Intent();
        intent.setClassName(packageName, className);
        return context.getPackageManager().resolveActivity(intent, 0) != null && intent.resolveActivity(context.getPackageManager()) != null && context.getPackageManager().queryIntentActivities(intent, 0).size() != 0;
    }

    public static void launchActivity(Context context, String packageName, String className) {
        ActivityUtil.launchActivity(context, packageName, className, null);
    }

    public static void launchActivity(Context context, String packageName, String className, Bundle bundle) {
        context.startActivity(IntentUtil.getComponentIntent(packageName, className, bundle));
    }

    public static String getLauncherActivity(Context context, String packageName) {
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        PackageManager pm = context.getPackageManager();
        List infos = pm.queryIntentActivities(intent, 0);
        for (ResolveInfo info : infos) {
            if (!info.activityInfo.packageName.equals(packageName)) continue;
            return info.activityInfo.name;
        }
        return "no " + packageName;
    }

    public static void startActivity(Activity context, Class<?> forwardActivity) {
        ActivityUtil.startActivity(context, forwardActivity, false);
    }

    public static void startActivity(Activity context, Class<?> forwardActivity, Boolean isFinish) {
        Intent intent = new Intent((Context)context, forwardActivity);
        context.startActivity(intent);
        if (isFinish.booleanValue()) {
            context.finish();
        }
    }

    public static void startActivity(Activity context, Class<?> forwardActivity, Bundle bundle, Boolean isFinish, int animIn, int animOut) {
        Intent intent = new Intent((Context)context, forwardActivity);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        context.startActivity(intent);
        if (isFinish.booleanValue()) {
            context.finish();
        }
        try {
            context.overridePendingTransition(animIn, animOut);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.e("Exception", e);
        }
    }

    public static void startActivity(Activity context, Class<?> forwardActivity, Bundle bundle, Boolean isFinish) {
        Intent intent = new Intent((Context)context, forwardActivity);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        context.startActivity(intent);
        if (isFinish.booleanValue()) {
            context.finish();
        }
    }

    public static void startActivityForResult(Activity context, Class<?> forwardActivity, int requestCode, Bundle bundle, Boolean isFinish) {
        Intent intent = new Intent((Context)context, forwardActivity);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        context.startActivityForResult(intent, requestCode);
        if (isFinish.booleanValue()) {
            context.finish();
        }
    }

    public static void startActivityForResult(Activity context, Class<?> forwardActivity, int requestCode, Bundle bundle, Boolean isFinish, int animIn, int animOut) {
        Intent intent = new Intent((Context)context, forwardActivity);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        context.startActivityForResult(intent, requestCode);
        if (isFinish.booleanValue()) {
            context.finish();
        }
        try {
            context.overridePendingTransition(animIn, animOut);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.e("Exception", e);
        }
    }

    public static String getTopActivity(Context context) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List runningTaskInfo = manager.getRunningTasks(1);
        if (runningTaskInfo != null) {
            return ((ActivityManager.RunningTaskInfo)runningTaskInfo.get((int)0)).topActivity.getClassName().toString();
        }
        return "";
    }

    public static boolean isTopActivity(Context context, String className) {
        String topActivity = ActivityUtil.getTopActivity(context);
        return className.equals(topActivity);
    }

    public static void setFullScreen(Activity activity, boolean isFull) {
        Window window = activity.getWindow();
        WindowManager.LayoutParams params = window.getAttributes();
        if (isFull) {
            params.flags |= 0x400;
            window.setAttributes(params);
            window.addFlags(512);
        } else {
            params.flags &= 0xFFFFFBFF;
            window.setAttributes(params);
            window.clearFlags(512);
        }
    }

    public static void hideSoftInput(Activity activity) {
        activity.getWindow().setSoftInputMode(2);
    }

    public static void hideSoftInput(Activity activity, IBinder token) {
        if (token != null) {
            InputMethodManager im = (InputMethodManager)activity.getSystemService("input_method");
            im.hideSoftInputFromWindow(token, 2);
        }
    }

    public static boolean isShouldHideInput(View v, MotionEvent event) {
        if (v != null && v instanceof EditText) {
            int[] l = new int[]{0, 0};
            v.getLocationInWindow(l);
            int left = l[0];
            int top = l[1];
            int bottom = top + v.getHeight();
            int right = left + v.getWidth();
            return !(event.getX() > (float)left) || !(event.getX() < (float)right) || !(event.getY() > (float)top) || !(event.getY() < (float)bottom);
        }
        return false;
    }

    public static void hideTitleBar(Activity activity) {
        activity.requestWindowFeature(1);
    }

    public static void setScreenVertical(Activity activity) {
        activity.setRequestedOrientation(1);
    }

    public static void setScreenHorizontal(Activity activity) {
        activity.setRequestedOrientation(0);
    }

    public static void adjustSoftInput(Activity activity) {
        activity.getWindow().setSoftInputMode(16);
    }

    public void addActivity(Activity activity) {
        if (activityStack == null) {
            activityStack = new Stack();
        }
        activityStack.add(activity);
    }

    public Activity currentActivity() {
        try {
            Activity activity = (Activity)activityStack.lastElement();
            return activity;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Activity preActivity() {
        int index = activityStack.size() - 2;
        if (index < 0) {
            return null;
        }
        Activity activity = (Activity)activityStack.get(index);
        return activity;
    }

    public void finishActivity() {
        Activity activity = (Activity)activityStack.lastElement();
        this.finishActivity(activity);
    }

    public void finishActivity(Activity activity) {
        if (activity != null) {
            activityStack.remove(activity);
            activity.finish();
            activity = null;
        }
    }

    public void removeActivity(Activity activity) {
        if (activity != null) {
            activityStack.remove(activity);
            activity = null;
        }
    }

    public void finishActivity(Class<?> cls) {
        try {
            for (Activity activity : activityStack) {
                if (!activity.getClass().equals(cls)) continue;
                this.finishActivity(activity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finishAllActivity() {
        int size = activityStack.size();
        for (int i = 0; i < size; ++i) {
            if (null == activityStack.get(i)) continue;
            ((Activity)activityStack.get(i)).finish();
        }
        activityStack.clear();
    }

    public void returnToActivity(Class<?> cls) {
        while (activityStack.size() != 0 && activityStack.peek().getClass() != cls) {
            this.finishActivity(activityStack.peek());
        }
    }

    public boolean isOpenActivity(Class<?> cls) {
        if (activityStack != null) {
            int size = activityStack.size();
            for (int i = 0; i < size; ++i) {
                if (cls != activityStack.peek().getClass()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void AppExit(Context context, Boolean isBackground) {
        try {
            this.finishAllActivity();
            ActivityManager activityMgr = (ActivityManager)context.getSystemService("activity");
            activityMgr.restartPackage(context.getPackageName());
        }
        catch (Exception exception) {
        }
        finally {
            if (!isBackground.booleanValue()) {
                System.exit(0);
            }
        }
    }
}

